/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.forwardsecrecy;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemObjectGenerator;
import org.bouncycastle.util.io.pem.PemWriter;
import org.cryptacular.generator.KeyPairGenerator;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.refcodes.runtime.SystemProperty;

public class ForwardSecrecyWorkshopTest {
    private static final int RSA_BIT_LENGTH = 2048;
    private static final SecureRandom SECURE_RANDOM;
    private static final String PATH_TO_SERVICE_KEY = "/tmp/rsa-service-key.pem";
    private static final String PATH_TO_SERVICE_PUB_KEY = "/tmp/rsa-service-pub-key.pem";
    private static final String PATH_TO_SERVER_KEY = "/tmp/rsa-server-key.pem";
    private static final String PATH_TO_SERVER_PUB_KEY = "/tmp/rsa-server-pub-key.pem";
    private static final String HALLO_WELT = "Hallo Welt";

    @Disabled(value="As of being a workshop no units are tested. Caution: When enabling, files are written to the FS!")
    @Test
    public void testAsysmetricCryptography() throws Exception {
        KeyPair theServerKeyPair = KeyPairGenerator.generateRSA((SecureRandom)SECURE_RANDOM, (int)2048);
        this.writeKeyToFile("The server's private key", PATH_TO_SERVER_KEY, theServerKeyPair.getPrivate().getEncoded());
        this.writeKeyToFile("The server's public key", PATH_TO_SERVER_PUB_KEY, theServerKeyPair.getPublic().getEncoded());
        KeyPair theServiceKeyPair = KeyPairGenerator.generateRSA((SecureRandom)SECURE_RANDOM, (int)2048);
        this.writeKeyToFile("The service's private key", PATH_TO_SERVICE_KEY, theServiceKeyPair.getPrivate().getEncoded());
        this.writeKeyToFile("The service's public key", PATH_TO_SERVICE_PUB_KEY, theServiceKeyPair.getPublic().getEncoded());
        Cipher theEncryptAlgorithm = Cipher.getInstance("RSA");
        theEncryptAlgorithm.init(1, theServerKeyPair.getPublic());
        byte[] theEncrypted = theEncryptAlgorithm.doFinal(HALLO_WELT.getBytes());
        String theEncryptedText = new String(theEncrypted);
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            System.out.println("Encrypted  = " + theEncryptedText);
        }
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            System.out.println("Length     = " + theEncryptedText.length());
        }
        Cipher theDecryptAlgorithm = Cipher.getInstance("RSA");
        theDecryptAlgorithm.init(2, theServerKeyPair.getPrivate());
        byte[] theDecrypted = theDecryptAlgorithm.doFinal(theEncryptedText.getBytes());
        String theDecryptedText = new String(theDecrypted);
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            System.out.println("Decrypted = " + theDecryptedText);
        }
        String theTestString = "0123456789 0123456789 0123456789 0123456789 0123456789 0123456789 0123456789";
        long theStartTime = System.currentTimeMillis();
        int theRuns = 1000;
        for (int i = 0; i < 1000; ++i) {
            theEncrypted = theEncryptAlgorithm.doFinal(("0123456789 0123456789 0123456789 0123456789 0123456789 0123456789 0123456789" + i).getBytes());
        }
        long theEndTime = System.currentTimeMillis();
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            System.out.println("ASYMETRIC ENCRYPTION:");
        }
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            System.out.println("1000 / seconds = " + (theEndTime - theStartTime) / 1000L);
        }
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            System.out.println("1 / milliseconds = " + ((double)theEndTime - (double)theStartTime) / 1000.0);
        }
        theStartTime = System.currentTimeMillis();
        for (int i = 0; i < 1000; ++i) {
            theDecrypted = theDecryptAlgorithm.doFinal(theEncrypted);
        }
        theEndTime = System.currentTimeMillis();
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            System.out.println("ASYMETRIC DECRYPTION:");
        }
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            System.out.println("1000 / seconds = " + (theEndTime - theStartTime) / 1000L);
        }
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            System.out.println("1 / milliseconds = " + ((double)theEndTime - (double)theStartTime) / 1000.0);
        }
    }

    protected void writeKeyToFile(String aDescription, String aFileName, byte[] aEncodedKey) throws IOException {
        try (PemWriter theServerPemWriter = new PemWriter((Writer)new FileWriter(new File(aFileName)));){
            PemObject theServerPrivateObject = new PemObject(aDescription, aEncodedKey);
            theServerPemWriter.writeObject((PemObjectGenerator)theServerPrivateObject);
        }
    }

    static {
        block2: {
            SecureRandom theSecureRandom = null;
            try {
                theSecureRandom = SecureRandom.getInstanceStrong();
            }
            catch (NoSuchAlgorithmException e) {
                SECURE_RANDOM = new SecureRandom();
                break block2;
            }
            SECURE_RANDOM = theSecureRandom;
        }
    }
}

