/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.generator;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Base64;
import java.util.Random;
import org.refcodes.data.Padding;
import org.refcodes.data.Text;
import org.refcodes.generator.IdGenerator;
import org.refcodes.numerical.NumericalUtility;

public class UniqueIdGeneratorImpl
implements IdGenerator {
    private static final int UUID_LENGTH = 36;
    private int _idLength;
    private static byte[] IP_ADDRESS = new byte[2];
    private static long COUNTER = 0L;
    private static long SEED;

    public static void initSeed() {
        SEED = new Random().nextLong();
        try {
            byte[] ipAddress = InetAddress.getLocalHost().getAddress();
            UniqueIdGeneratorImpl.IP_ADDRESS[0] = ipAddress[ipAddress.length - 2];
            UniqueIdGeneratorImpl.IP_ADDRESS[1] = ipAddress[ipAddress.length - 1];
        }
        catch (UnknownHostException e) {
            new Random().nextBytes(IP_ADDRESS);
        }
    }

    public UniqueIdGeneratorImpl() {
        this(36);
    }

    public UniqueIdGeneratorImpl(int aIdLength) {
        this._idLength = aIdLength;
    }

    @Override
    public boolean hasNext() {
        return true;
    }

    @Override
    public String next() {
        int theRemainingLength;
        String thePrefix = null;
        thePrefix = Base64.getEncoder().encodeToString(IP_ADDRESS);
        if (this._idLength <= (thePrefix = thePrefix.replaceAll(Padding.BASE64.getChar() + "", "")).length()) {
            throw new IllegalStateException("The desired length of <" + this._idLength + "> is too short as the prefix \"" + thePrefix + "\" has already a length of <" + thePrefix.length());
        }
        Long theTime = System.currentTimeMillis();
        String theTimeString = null;
        theTimeString = Base64.getEncoder().encodeToString(NumericalUtility.toBytes((long)theTime));
        theTimeString = theTimeString.replaceAll(Padding.BASE64.getChar() + "", "");
        String theSeedString = null;
        while (theSeedString == null || theSeedString.length() == 0) {
            theSeedString = Base64.getEncoder().encodeToString(NumericalUtility.toBytes((long)SEED++));
            if ((theSeedString = theSeedString.replaceAll(Padding.BASE64.getChar() + "", "")) != null && theSeedString.length() != 0) continue;
            UniqueIdGeneratorImpl.initSeed();
        }
        if (this._idLength <= 4) {
            thePrefix = "";
        }
        int theSeedLength = 4;
        if (this._idLength <= 6) {
            theSeedLength -= 7 - this._idLength;
        }
        if (theSeedString.length() > theSeedLength) {
            theSeedString = theSeedString.substring(theSeedString.length() - theSeedLength);
        }
        if ((theRemainingLength = this._idLength - theSeedString.length() - thePrefix.length()) < 0) {
            throw new IllegalStateException("Cannot create an ID of length <" + this._idLength + "> as we are short of <" + Math.abs(theRemainingLength) + "> digits; enlarge your length accordinbgly.");
        }
        if (theTimeString.length() >= theRemainingLength) {
            int beginIndex = theTimeString.length() - theRemainingLength;
            return thePrefix + theSeedString + theTimeString.substring(beginIndex);
        }
        String theCounterString = Base64.getEncoder().encodeToString(NumericalUtility.toBytes((long)COUNTER++));
        if ((theCounterString = theCounterString.replaceAll(Padding.BASE64.getChar() + "", "")).length() != theRemainingLength) {
            if (theCounterString.length() > theRemainingLength) {
                theCounterString = theCounterString.substring(0, theRemainingLength);
            } else {
                StringBuffer theBuffer = new StringBuffer();
                theBuffer.append(theCounterString);
                for (int i = 0; i < theRemainingLength - theCounterString.length(); ++i) {
                    theBuffer.append('0');
                }
                theCounterString = theBuffer.toString();
            }
        }
        return thePrefix + theSeedString + theTimeString + theCounterString;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException(Text.UNSUPPORTED_OPERATION.getText());
    }

    static {
        UniqueIdGeneratorImpl.initSeed();
    }
}

