/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.graphical.ext.javafx;

import javafx.animation.TranslateTransition;
import javafx.application.Platform;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;
import javafx.util.Duration;
import org.refcodes.graphical.Dimension;
import org.refcodes.graphical.FieldDimension;
import org.refcodes.graphical.MoveMode;
import org.refcodes.graphical.Opacity;
import org.refcodes.graphical.ext.javafx.FxDragSpriteEventHandler;
import org.refcodes.logger.RuntimeLogger;
import org.refcodes.logger.RuntimeLoggerFactorySingleton;

public class FxDragSpriteEventHandlerImpl
implements FxDragSpriteEventHandler {
    private static RuntimeLogger LOGGER = RuntimeLoggerFactorySingleton.createRuntimeLogger();
    private double _sceneX;
    private double _sceneY;
    public double _posX;
    private double _posY;
    private Node _sprite;
    private Pane _scene;
    private int _fieldWidth = 1;
    private int _fieldHeight = 1;
    private int _fieldGap = 0;
    private double _prevOpacity = 1.0;
    private double _dragOpacity = Opacity.DRAG.getOpacity();
    private MoveMode _moveMode = MoveMode.SMOOTH;
    private int _offsetY = 0;
    private int _offsetX = 0;
    private EventHandler<MouseEvent> _onMousePressedEventHandler = new EventHandler<MouseEvent>(){

        public void handle(MouseEvent aEvent) {
            Node theSprite = (Node)aEvent.getSource();
            FxDragSpriteEventHandlerImpl.this._prevOpacity = theSprite.getOpacity();
            theSprite.setOpacity(FxDragSpriteEventHandlerImpl.this._dragOpacity);
            FxDragSpriteEventHandlerImpl.this._sceneX = aEvent.getSceneX();
            FxDragSpriteEventHandlerImpl.this._sceneY = aEvent.getSceneY();
            FxDragSpriteEventHandlerImpl.this._posX = theSprite.getTranslateX();
            FxDragSpriteEventHandlerImpl.this._posY = theSprite.getTranslateY();
            if (LOGGER.isLogDebug()) {
                LOGGER.debug("Sprite mouse press X := " + aEvent.getSceneX());
                LOGGER.debug("Sprite mouse press Y := " + aEvent.getSceneY());
            }
            aEvent.consume();
        }
    };
    private EventHandler<MouseEvent> _onMouseDraggedEventHandler = new EventHandler<MouseEvent>(){

        public void handle(MouseEvent aEvent) {
            Node theSprite = (Node)aEvent.getSource();
            double theSceneOffsetX = aEvent.getSceneX() - FxDragSpriteEventHandlerImpl.this._sceneX;
            double theSceneOffsetY = aEvent.getSceneY() - FxDragSpriteEventHandlerImpl.this._sceneY;
            double theTranslateX = FxDragSpriteEventHandlerImpl.this._posX + theSceneOffsetX;
            double theTranslateY = FxDragSpriteEventHandlerImpl.this._posY + theSceneOffsetY;
            switch (FxDragSpriteEventHandlerImpl.this._moveMode) {
                case SMOOTH: {
                    theTranslateX = FxDragSpriteEventHandlerImpl.this.toBoundsX(theTranslateX, theSprite);
                    theTranslateY = FxDragSpriteEventHandlerImpl.this.toBoundsY(theTranslateY, theSprite);
                    break;
                }
                case JUMPY: {
                    theTranslateX = FxDragSpriteEventHandlerImpl.this.toSnapX(theTranslateX, theSprite);
                    theTranslateY = FxDragSpriteEventHandlerImpl.this.toSnapY(theTranslateY, theSprite);
                }
            }
            theSprite.setTranslateX(theTranslateX);
            theSprite.setTranslateY(theTranslateY);
            FxDragSpriteEventHandlerImpl.this._offsetX = (int)Math.round(theTranslateX / (double)(FxDragSpriteEventHandlerImpl.this.getFieldWidth() + FxDragSpriteEventHandlerImpl.this.getFieldGap()));
            FxDragSpriteEventHandlerImpl.this._offsetY = (int)Math.round(theTranslateY / (double)(FxDragSpriteEventHandlerImpl.this.getFieldHeight() + FxDragSpriteEventHandlerImpl.this.getFieldGap()));
            aEvent.consume();
        }
    };
    private EventHandler<MouseEvent> _onMouseReleasedEventHandler = new EventHandler<MouseEvent>(){

        public void handle(MouseEvent aEvent) {
            final Node theSprite = (Node)aEvent.getSource();
            double theSceneOffsetX = aEvent.getSceneX() - FxDragSpriteEventHandlerImpl.this._sceneX;
            double theSceneOffsetY = aEvent.getSceneY() - FxDragSpriteEventHandlerImpl.this._sceneY;
            double theTranslateX = FxDragSpriteEventHandlerImpl.this._posX + theSceneOffsetX;
            double theTranslateY = FxDragSpriteEventHandlerImpl.this._posY + theSceneOffsetY;
            final double theToX = FxDragSpriteEventHandlerImpl.this.toSnapX(theTranslateX, theSprite);
            final double theToY = FxDragSpriteEventHandlerImpl.this.toSnapY(theTranslateY, theSprite);
            theSprite.setOpacity(FxDragSpriteEventHandlerImpl.this._prevOpacity);
            switch (FxDragSpriteEventHandlerImpl.this._moveMode) {
                case SMOOTH: {
                    Runnable theRunner = new Runnable(){

                        @Override
                        public void run() {
                            TranslateTransition theTransition = new TranslateTransition(Duration.millis((double)150.0), theSprite);
                            theTransition.setToX(theToX);
                            theTransition.setToY(theToY);
                            theTransition.setCycleCount(1);
                            theTransition.setAutoReverse(false);
                            theTransition.play();
                        }
                    };
                    if (Platform.isFxApplicationThread()) {
                        theRunner.run();
                        break;
                    }
                    Platform.runLater((Runnable)theRunner);
                    break;
                }
                case JUMPY: {
                    theSprite.setTranslateX(theToX);
                    theSprite.setTranslateY(theToY);
                }
            }
            if (LOGGER.isLogDebug()) {
                LOGGER.debug("Sprite mouse release X := " + aEvent.getSceneX());
                LOGGER.debug("Sprite mouse release Y := " + aEvent.getSceneY());
                LOGGER.debug("Sprite mouse release offset X := " + theSceneOffsetX);
                LOGGER.debug("Sprite mouse release offset Y := " + theSceneOffsetY);
                LOGGER.debug("Sprite translate X := " + theTranslateX);
                LOGGER.debug("Sprite translate Y := " + theTranslateY);
            }
            aEvent.consume();
        }
    };

    public FxDragSpriteEventHandlerImpl(Node aSprite, Pane aScene) {
        aSprite.setOnMousePressed(this._onMousePressedEventHandler);
        aSprite.setOnMouseDragged(this._onMouseDraggedEventHandler);
        aSprite.setOnMouseReleased(this._onMouseReleasedEventHandler);
        this._sprite = aSprite;
        this._scene = aScene;
    }

    public int getFieldWidth() {
        return this._fieldWidth;
    }

    public int getFieldHeight() {
        return this._fieldHeight;
    }

    public int getFieldGap() {
        return this._fieldGap;
    }

    public void setFieldWidth(int aWidth) {
        this._fieldWidth = aWidth;
    }

    public FxDragSpriteEventHandlerImpl withFieldWidth(int aWidth) {
        this._fieldWidth = aWidth;
        return this;
    }

    public void setFieldHeight(int aHeight) {
        this._fieldHeight = aHeight;
    }

    public int getOffsetX() {
        return this._offsetX;
    }

    public int getOffsetY() {
        return this._offsetY;
    }

    public FxDragSpriteEventHandlerImpl withFieldHeight(int aHeight) {
        this._fieldHeight = aHeight;
        return this;
    }

    public FxDragSpriteEventHandlerImpl withFieldDimension(int aWidth, int aHeight) {
        this.setFieldDimension(aWidth, aHeight);
        return this;
    }

    public FxDragSpriteEventHandlerImpl withFieldDimension(int aWidth, int aHeight, int aGap) {
        this.setFieldDimension(aWidth, aHeight, aGap);
        return this;
    }

    public FxDragSpriteEventHandlerImpl withFieldDimension(FieldDimension aDimension) {
        this.setFieldDimension(aDimension);
        return this;
    }

    public void setFieldDimension(int aWidth, int aHeight) {
        this._fieldWidth = aWidth;
        this._fieldHeight = aHeight;
    }

    public void setFieldDimension(int aWidth, int aHeight, int aGap) {
        this._fieldWidth = aWidth;
        this._fieldHeight = aHeight;
        this._fieldGap = aGap;
    }

    public void setFieldDimension(FieldDimension aDimension) {
        this._fieldWidth = aDimension.getFieldWidth();
        this._fieldHeight = aDimension.getFieldHeight();
        this._fieldGap = aDimension.getFieldGap();
    }

    public FxDragSpriteEventHandlerImpl withFieldDimension(Dimension aDimension) {
        this.setFieldDimension(aDimension.getWidth(), aDimension.getHeight());
        return this;
    }

    public void setFieldDimension(Dimension aDimension) {
        this._fieldWidth = aDimension.getWidth();
        this._fieldHeight = aDimension.getHeight();
    }

    public void setFieldGap(int aFieldGap) {
        this._fieldGap = aFieldGap;
    }

    public FxDragSpriteEventHandlerImpl withFieldGap(int aFieldGap) {
        this.setFieldGap(aFieldGap);
        return this;
    }

    public double getDragOpacity() {
        return this._dragOpacity;
    }

    public void setDragOpacity(double aOpacity) {
        this._dragOpacity = aOpacity;
    }

    public FxDragSpriteEventHandler withDragOpacity(double aOpacity) {
        this.setDragOpacity(aOpacity);
        return this;
    }

    public Node getSprite() {
        return this._sprite;
    }

    public MoveMode getMoveMode() {
        return this._moveMode;
    }

    public void setMoveMode(MoveMode aMoveMode) {
        this._moveMode = aMoveMode;
    }

    public FxDragSpriteEventHandler withMoveMode(MoveMode aMoveMode) {
        this.setMoveMode(aMoveMode);
        return this;
    }

    public void dispose() {
        this._sprite.setOnMousePressed(null);
        this._sprite.setOnMouseDragged(null);
        this._sprite.setOnMouseReleased(null);
        this._sprite = null;
    }

    private double toBoundsX(double aTranslateX, Node aSprite) {
        return this.toBounds(aTranslateX, aSprite.getBoundsInParent().getWidth(), this._scene.getWidth());
    }

    private double toBoundsY(double aTranslateY, Node aSprite) {
        return this.toBounds(aTranslateY, aSprite.getBoundsInParent().getHeight(), this._scene.getHeight());
    }

    private double toBounds(double aTranslateSize, double aSpriteSize, double aBackgroundSize) {
        if (aSpriteSize < aBackgroundSize) {
            if (aSpriteSize + aTranslateSize > aBackgroundSize) {
                aTranslateSize = aBackgroundSize - aSpriteSize;
            }
            if (aTranslateSize < 0.0) {
                aTranslateSize = 0.0;
            }
        } else {
            if (aSpriteSize + aTranslateSize < aBackgroundSize) {
                aTranslateSize = aBackgroundSize - aSpriteSize;
            }
            if (aTranslateSize > 0.0) {
                aTranslateSize = 0.0;
            }
        }
        return aTranslateSize;
    }

    private double toSnapX(double aTranslateX, Node aSprite) {
        return this.toSnap(aTranslateX, aSprite.getBoundsInParent().getWidth(), this.getFieldWidth(), this._scene.getWidth());
    }

    private double toSnapY(double aTranslateY, Node aSprite) {
        return this.toSnap(aTranslateY, aSprite.getBoundsInParent().getHeight(), this.getFieldHeight(), this._scene.getHeight());
    }

    private double toSnap(double aTranslateSize, double aSpriteSize, int aFieldSize, double aBackgroundSize) {
        if (aSpriteSize > aBackgroundSize && aSpriteSize + aTranslateSize == aBackgroundSize) {
            return aTranslateSize;
        }
        return this.toBounds(Math.round(aTranslateSize / (double)(aFieldSize + this.getFieldGap())) * (long)(aFieldSize + this.getFieldGap()), aSpriteSize, aBackgroundSize);
    }
}

