/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.graphical.ext.javafx;

import java.util.ArrayList;
import java.util.List;
import javafx.animation.PauseTransition;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.util.Duration;
import org.refcodes.component.LifeCycleStatus;
import org.refcodes.graphical.ext.javafx.FxFlipBookBuilder;

public class FxFlipBookBuilderImpl
extends ImageView
implements FxFlipBookBuilder {
    private List<Image> _startUpImages = new ArrayList<Image>();
    private List<Image> _mainLoopImages = new ArrayList<Image>();
    private List<Image> _ceaseImages = new ArrayList<Image>();
    private LifeCycleStatus _lifeCycleRequest = LifeCycleStatus.NONE;
    private LifeCycleStatus _lifeCycleStatus = LifeCycleStatus.INITIALIZED;
    private int _imageDurationInMs = 250;
    private int _startUpDelayInMs = 1000;
    private PauseTransition _transition = null;

    public FxFlipBookBuilderImpl() {
        this.setVisible(false);
    }

    public void addStartUpImage(Image aImage) {
        if (this._startUpImages.size() == 0) {
            this.setImage(aImage);
        }
        this._startUpImages.add(aImage);
    }

    public void addMainLoopImage(Image aImage) {
        if (this._mainLoopImages.size() == 0 && this._startUpImages.size() == 0) {
            this.setImage(aImage);
        }
        this._mainLoopImages.add(aImage);
    }

    public void addCeaseImage(Image aImage) {
        if (this._ceaseImages.size() == 0 && this._mainLoopImages.size() == 0 && this._startUpImages.size() == 0) {
            this.setImage(aImage);
        }
        this._ceaseImages.add(aImage);
    }

    public void setImageDurationInMs(int aDurationInMs) {
        this._imageDurationInMs = aDurationInMs;
    }

    public int getImageDurationInMs() {
        return this._imageDurationInMs;
    }

    public void setStartUpDelayInMs(int aStartUpDelayInMs) {
        this._startUpDelayInMs = aStartUpDelayInMs;
    }

    public int getStartUpDelayInMs() {
        return this._startUpDelayInMs;
    }

    @Override
    public FxFlipBookBuilderImpl withImageDurationInMs(int aDurationInMs) {
        this.setImageDurationInMs(aDurationInMs);
        return this;
    }

    @Override
    public FxFlipBookBuilderImpl withStartUpDelayInMs(int aStartUpDelayInMs) {
        this.setStartUpDelayInMs(aStartUpDelayInMs);
        return this;
    }

    public void initialize() {
        this._lifeCycleStatus = LifeCycleStatus.INITIALIZED;
    }

    public void start() {
        if (this._lifeCycleStatus != LifeCycleStatus.INITIALIZED || this._startUpImages.size() == 0) {
            this._lifeCycleStatus = LifeCycleStatus.STARTED;
        }
        if (this._transition != null) {
            throw new IllegalStateException("The flip book must not be started again after it has been started but not stopped (destroyed) again");
        }
        AnimationDaemon theRunner = new AnimationDaemon();
        if (Platform.isFxApplicationThread()) {
            theRunner.run();
        } else {
            Platform.runLater((Runnable)theRunner);
        }
    }

    public void pause() {
        this._lifeCycleRequest = LifeCycleStatus.PAUSED;
    }

    public void resume() {
        this._lifeCycleRequest = LifeCycleStatus.STARTED;
    }

    public void stop() {
        this._lifeCycleRequest = LifeCycleStatus.STOPPED;
        PauseTransition theTransition = this._transition;
        if (theTransition != null) {
            this._transition = null;
            theTransition.stop();
        }
    }

    public void cease() {
        this._lifeCycleRequest = LifeCycleStatus.CEASED;
    }

    public void destroy() {
        this.stop();
        this._startUpImages.clear();
    }

    private class AnimationDaemon
    implements Runnable {
        private int _index = 0;

        private AnimationDaemon() {
        }

        @Override
        public void run() {
            FxFlipBookBuilderImpl.this._transition = new PauseTransition();
            if (FxFlipBookBuilderImpl.this._lifeCycleStatus != LifeCycleStatus.INITIALIZED || FxFlipBookBuilderImpl.this._startUpDelayInMs <= 0) {
                this.flipImage();
                FxFlipBookBuilderImpl.this._transition.setDuration(Duration.millis((double)FxFlipBookBuilderImpl.this._imageDurationInMs));
            } else {
                FxFlipBookBuilderImpl.this._transition.setDuration(Duration.millis((double)FxFlipBookBuilderImpl.this._startUpDelayInMs));
            }
            FxFlipBookBuilderImpl.this._transition.setCycleCount(1);
            FxFlipBookBuilderImpl.this._transition.play();
            EventHandler<ActionEvent> onFinished = new EventHandler<ActionEvent>(){

                public void handle(ActionEvent t) {
                    AnimationDaemon.this.flipImage();
                    PauseTransition theTransition = FxFlipBookBuilderImpl.this._transition;
                    if (theTransition != null) {
                        theTransition.setDuration(Duration.millis((double)FxFlipBookBuilderImpl.this._imageDurationInMs));
                        theTransition.play();
                    }
                }
            };
            FxFlipBookBuilderImpl.this._transition.setOnFinished((EventHandler)onFinished);
        }

        private void flipImage() {
            FxFlipBookBuilderImpl.this.setVisible(true);
            List theImages = null;
            switch (FxFlipBookBuilderImpl.this._lifeCycleStatus) {
                case CEASED: {
                    theImages = FxFlipBookBuilderImpl.this._ceaseImages;
                    break;
                }
                case DESTROYED: {
                    break;
                }
                case INITIALIZED: {
                    theImages = FxFlipBookBuilderImpl.this._startUpImages;
                    if (this._index <= theImages.size() - 1) break;
                    this._index = 0;
                    FxFlipBookBuilderImpl.this._lifeCycleStatus = LifeCycleStatus.STARTED;
                    FxFlipBookBuilderImpl.this._lifeCycleRequest = LifeCycleStatus.NONE;
                    theImages = FxFlipBookBuilderImpl.this._mainLoopImages;
                    break;
                }
                case NONE: {
                    break;
                }
                case PAUSED: {
                    break;
                }
                case STARTED: {
                    theImages = FxFlipBookBuilderImpl.this._mainLoopImages;
                    break;
                }
                case STOPPED: {
                    break;
                }
            }
            switch (FxFlipBookBuilderImpl.this._lifeCycleRequest) {
                case CEASED: {
                    if (this._index <= theImages.size() - 1) break;
                    this._index = 0;
                    FxFlipBookBuilderImpl.this._lifeCycleStatus = LifeCycleStatus.CEASED;
                    FxFlipBookBuilderImpl.this._lifeCycleRequest = LifeCycleStatus.NONE;
                    theImages = FxFlipBookBuilderImpl.this._ceaseImages;
                    break;
                }
                case DESTROYED: {
                    break;
                }
                case INITIALIZED: {
                    this._index = 0;
                    FxFlipBookBuilderImpl.this._lifeCycleStatus = LifeCycleStatus.INITIALIZED;
                    FxFlipBookBuilderImpl.this._lifeCycleRequest = LifeCycleStatus.NONE;
                    theImages = FxFlipBookBuilderImpl.this._startUpImages;
                    break;
                }
                case NONE: {
                    break;
                }
                case PAUSED: {
                    return;
                }
                case STARTED: {
                    break;
                }
                case STOPPED: {
                    if (this._index > theImages.size() - 1) {
                        this._index = 0;
                        FxFlipBookBuilderImpl.this._lifeCycleStatus = LifeCycleStatus.STOPPED;
                        FxFlipBookBuilderImpl.this._lifeCycleRequest = LifeCycleStatus.NONE;
                    }
                    return;
                }
            }
            if (theImages.size() > 0) {
                if (this._index > theImages.size() - 1) {
                    this._index = 0;
                }
                FxFlipBookBuilderImpl.this.setImage((Image)theImages.get(this._index++));
            }
        }
    }
}

