/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.graphical.ext.javafx;

import javafx.animation.TranslateTransition;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.layout.Pane;
import javafx.util.Duration;
import org.refcodes.graphical.Dimension;
import org.refcodes.graphical.FieldDimension;
import org.refcodes.graphical.GridMode;
import org.refcodes.graphical.MoveMode;
import org.refcodes.graphical.Offset;
import org.refcodes.graphical.Opacity;
import org.refcodes.graphical.Position;
import org.refcodes.graphical.ViewportDimension;
import org.refcodes.graphical.ViewportOffset;
import org.refcodes.graphical.ext.javafx.FxDragSpriteEventHandlerImpl;
import org.refcodes.graphical.ext.javafx.FxViewportPane;

public class FxViewportPaneImpl
extends Pane
implements FxViewportPane {
    private FxDragSpriteEventHandlerImpl _contentEventHandler = null;
    private int _viewportWidth;
    private int _viewportHeight;
    private int _viewportOffsetX;
    private int _viewportOffsetY;
    private double _viewportOffsetDurationInMs = 300.0;
    private int _fieldWidth;
    private int _fieldHeight;
    private int _fieldGap;
    private double _dragOpacity = Opacity.DRAG.getOpacity();
    private MoveMode _moveMode = MoveMode.SMOOTH;
    private GridMode _gridMode = GridMode.NONE;
    private boolean _hasContent = false;

    public Node getContent() {
        FxDragSpriteEventHandlerImpl theContentEventHandler = this._contentEventHandler;
        if (theContentEventHandler != null) {
            return theContentEventHandler.getSprite();
        }
        return null;
    }

    public int getViewportOffsetX() {
        FxDragSpriteEventHandlerImpl theContentEventHandler = this._contentEventHandler;
        if (theContentEventHandler != null) {
            return theContentEventHandler.getOffsetX();
        }
        return this._viewportOffsetX;
    }

    public int getViewportOffsetY() {
        FxDragSpriteEventHandlerImpl theContentEventHandler = this._contentEventHandler;
        if (theContentEventHandler != null) {
            return theContentEventHandler.getOffsetY();
        }
        return this._viewportOffsetY;
    }

    public void setViewportOffsetX(int aOffsetX) {
        this.setViewportOffset(aOffsetX, this._viewportOffsetY);
    }

    public FxViewportPane withViewportOffsetX(int aOffsetX) {
        this.setViewportOffsetX(aOffsetX);
        return this;
    }

    public void setViewportOffsetY(int aOffsetY) {
        this.setViewportOffset(this._viewportOffsetX, aOffsetY);
    }

    public FxViewportPane withViewportOffsetY(int aOffsetY) {
        this.setViewportOffsetY(aOffsetY);
        return this;
    }

    public FxViewportPane withViewportOffset(int aOffsetX, int aOffsetY) {
        this.setViewportOffset(aOffsetX, aOffsetY);
        return this;
    }

    public FxViewportPane withViewportOffset(ViewportOffset aOffset) {
        this.setViewportOffset(aOffset);
        return this;
    }

    public void setViewportOffset(ViewportOffset aOffset) {
        this.setViewportOffset(aOffset.getViewportOffsetX(), aOffset.getViewportOffsetY());
    }

    public FxViewportPane withViewportOffset(Offset aOffset) {
        this.setViewportOffset(aOffset.getOffsetX(), aOffset.getOffsetY());
        return this;
    }

    public void setViewportOffset(Offset aOffset) {
        this._viewportOffsetY = aOffset.getOffsetY();
        this.setViewportOffset(aOffset.getOffsetX(), this._viewportOffsetY);
    }

    public FxViewportPane withViewportOffset(Position aOffset) {
        this.setViewportOffset(aOffset);
        return this;
    }

    public void setViewportOffset(Position aOffset) {
        this.setViewportOffset(aOffset.getPositionX(), aOffset.getPositionY());
    }

    public int getViewportWidth() {
        return this._viewportWidth;
    }

    public int getViewportHeight() {
        return this._viewportHeight;
    }

    public void setViewportWidth(int aWidth) {
        this.setViewportDimension(aWidth, this._viewportHeight);
    }

    public FxViewportPane withViewportWidth(int aWidth) {
        this.setViewportWidth(aWidth);
        return this;
    }

    public void setViewportHeight(int aHeight) {
        this.setViewportDimension(this._viewportWidth, aHeight);
    }

    public FxViewportPane withViewportHeight(int aHeight) {
        this.setViewportHeight(aHeight);
        return this;
    }

    public FxViewportPane withViewportDimension(int aWidth, int aHeight) {
        this.setViewportDimension(aWidth, aHeight);
        return this;
    }

    public FxViewportPane withViewportDimension(ViewportDimension aDimension) {
        this.setViewportDimension(aDimension);
        return this;
    }

    public void setViewportDimension(ViewportDimension aDimension) {
        this.setViewportDimension(aDimension.getViewportWidth(), aDimension.getViewportHeight());
    }

    public FxViewportPane withViewportDimension(Dimension aDimension) {
        this.setViewportDimension(aDimension.getWidth(), aDimension.getHeight());
        return this;
    }

    public void setViewportDimension(Dimension aDimension) {
        this._viewportHeight = aDimension.getHeight();
        this.setViewportDimension(aDimension.getWidth(), this._viewportHeight);
    }

    public void setViewportDimension(int aWidth, int aHeight) {
        this._viewportWidth = aWidth;
        this._viewportHeight = aHeight;
        this.resize();
    }

    public int getFieldWidth() {
        return this._fieldWidth;
    }

    public int getFieldHeight() {
        return this._fieldHeight;
    }

    public int getFieldGap() {
        return this._fieldGap;
    }

    public void setFieldWidth(int aWidth) {
        this.setFieldDimension(aWidth, this._fieldHeight);
    }

    public FxViewportPane withFieldWidth(int aWidth) {
        this.setFieldWidth(aWidth);
        return this;
    }

    public void setFieldHeight(int aHeight) {
        this.setFieldHeight(aHeight);
    }

    public FxViewportPane withFieldHeight(int aHeight) {
        this.setFieldHeight(aHeight);
        return this;
    }

    public FxViewportPane withFieldDimension(int aWidth, int aHeight) {
        this.setFieldDimension(aWidth, aHeight);
        return this;
    }

    public FxViewportPane withFieldDimension(int aWidth, int aHeight, int aGap) {
        this.setFieldDimension(aWidth, aHeight, aGap);
        return this;
    }

    public FxViewportPane withFieldDimension(FieldDimension aDimension) {
        this.setFieldDimension(aDimension);
        return this;
    }

    public void setFieldDimension(FieldDimension aDimension) {
        this.setFieldDimension(aDimension.getFieldWidth(), aDimension.getFieldHeight());
        this.setFieldGap(aDimension.getFieldGap());
    }

    public FxViewportPane withFieldDimension(Dimension aDimension) {
        this.setFieldDimension(aDimension.getWidth(), aDimension.getHeight());
        return this;
    }

    public void setFieldDimension(Dimension aDimension) {
        this.setFieldDimension(aDimension.getWidth(), aDimension.getHeight());
    }

    public FxViewportPane withFieldGap(int aGap) {
        this.setFieldGap(aGap);
        return this;
    }

    public double getDragOpacity() {
        return this._dragOpacity;
    }

    public FxViewportPane withDragOpacity(double aOpacity) {
        this.setDragOpacity(aOpacity);
        return this;
    }

    public FxViewportPane withContent(Node aContent) {
        this.setContent(aContent);
        return this;
    }

    public MoveMode getMoveMode() {
        return this._moveMode;
    }

    public FxViewportPane withMoveMode(MoveMode aMoveMode) {
        this.setMoveMode(aMoveMode);
        return this;
    }

    public GridMode getGridMode() {
        return this._gridMode;
    }

    public void setGridMode(GridMode aGridMode) {
        if (this._gridMode != aGridMode) {
            this._gridMode = aGridMode;
            this.resize();
        }
    }

    public FxViewportPane withGridMode(GridMode aGridMode) {
        this.setGridMode(aGridMode);
        return this;
    }

    public void setDragOpacity(double aOpacity) {
        this._dragOpacity = aOpacity;
        FxDragSpriteEventHandlerImpl theContentEventHandler = this._contentEventHandler;
        if (theContentEventHandler != null) {
            theContentEventHandler.setDragOpacity(aOpacity);
        }
    }

    public void setFieldDimension(int aWidth, int aHeight) {
        FxDragSpriteEventHandlerImpl theContentEventHandler;
        if (this._fieldWidth != aWidth || this._fieldHeight != aHeight) {
            this._fieldWidth = aWidth;
            this._fieldHeight = aHeight;
            this.resize();
        }
        if ((theContentEventHandler = this._contentEventHandler) != null) {
            theContentEventHandler.setFieldDimension((FieldDimension)this);
        }
    }

    public void setFieldDimension(int aWidth, int aHeight, int aGap) {
        FxDragSpriteEventHandlerImpl theContentEventHandler;
        if (this._fieldWidth != aWidth || this._fieldHeight != aHeight || this._fieldGap != aGap) {
            this._fieldWidth = aWidth;
            this._fieldHeight = aHeight;
            this._fieldGap = aGap;
            this.resize();
        }
        if ((theContentEventHandler = this._contentEventHandler) != null) {
            theContentEventHandler.setFieldDimension((FieldDimension)this);
        }
    }

    public void setFieldGap(int aGap) {
        FxDragSpriteEventHandlerImpl theContentEventHandler;
        if (this._fieldGap != aGap) {
            this._fieldGap = aGap;
            this.resize();
        }
        if ((theContentEventHandler = this._contentEventHandler) != null) {
            theContentEventHandler.setFieldGap(aGap);
        }
    }

    public void setMoveMode(MoveMode aMoveMode) {
        this._moveMode = aMoveMode;
        FxDragSpriteEventHandlerImpl theContentEventHandler = this._contentEventHandler;
        if (theContentEventHandler != null) {
            theContentEventHandler.setMoveMode(aMoveMode);
        }
    }

    public void setViewportOffset(int aOffsetX, int aOffsetY) {
        if (aOffsetX != this._viewportOffsetX || aOffsetY != this._viewportOffsetY) {
            this._viewportOffsetX = aOffsetX;
            this._viewportOffsetY = aOffsetY;
            FxDragSpriteEventHandlerImpl theContentEventHandler = this._contentEventHandler;
            if (theContentEventHandler != null) {
                final Node thePlayer = theContentEventHandler.getSprite();
                final double theToX = (this.getFieldWidth() + this.getFieldGap()) * aOffsetX;
                final double theToY = (this.getFieldWidth() + this.getFieldGap()) * aOffsetY;
                thePlayer.setOpacity(1.0);
                Runnable theRunner = new Runnable(){

                    @Override
                    public void run() {
                        TranslateTransition theTransition = new TranslateTransition(Duration.millis((double)FxViewportPaneImpl.this._viewportOffsetDurationInMs), thePlayer);
                        theTransition.setToX(theToX);
                        theTransition.setToY(theToY);
                        theTransition.setCycleCount(1);
                        theTransition.setAutoReverse(false);
                        theTransition.play();
                    }
                };
                if (Platform.isFxApplicationThread()) {
                    theRunner.run();
                } else {
                    Platform.runLater((Runnable)theRunner);
                }
            }
        }
    }

    public synchronized void setContent(Node aContent) {
        FxDragSpriteEventHandlerImpl theContentEventHandler = this._contentEventHandler;
        if (theContentEventHandler != null) {
            this.getChildren().remove((Object)theContentEventHandler.getSprite());
            theContentEventHandler.dispose();
        }
        theContentEventHandler = new FxDragSpriteEventHandlerImpl(aContent, this);
        theContentEventHandler.setDragOpacity(this.getDragOpacity());
        theContentEventHandler.setFieldDimension((FieldDimension)this);
        theContentEventHandler.setFieldGap(this.getFieldGap());
        theContentEventHandler.setMoveMode(this.getMoveMode());
        this._contentEventHandler = theContentEventHandler;
        if (this._hasContent) {
            this.getChildren().remove(0);
        } else {
            this._hasContent = true;
        }
        this.getChildren().add(0, (Object)aContent);
        this.setWidth(aContent.getBoundsInLocal().getWidth());
        this.setHeight(aContent.getBoundsInLocal().getHeight());
    }

    private void resize() {
        int theWidth = this.getViewportWidth() * (this.getFieldWidth() + this.getFieldGap());
        int theHeight = this.getViewportHeight() * (this.getFieldHeight() + this.getFieldGap());
        switch (this.getGridMode()) {
            case CLOSED: {
                theWidth += this.getFieldGap();
                theHeight += this.getFieldGap();
                break;
            }
            case PERIODIC: {
                theWidth -= this.getFieldGap();
                theHeight -= this.getFieldGap();
                break;
            }
        }
        this.setPrefSize(theWidth, theHeight);
    }
}

