/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.graphical.ext.javafx;

import java.util.function.BiConsumer;
import javafx.scene.Node;
import javafx.scene.layout.Pane;
import org.refcodes.graphical.Dimension;
import org.refcodes.graphical.FieldDimension;
import org.refcodes.graphical.GridMode;
import org.refcodes.graphical.GridViewportPane;
import org.refcodes.graphical.MoveMode;
import org.refcodes.graphical.Offset;
import org.refcodes.graphical.Opacity;
import org.refcodes.graphical.Position;
import org.refcodes.graphical.ViewportDimension;
import org.refcodes.graphical.ViewportOffset;
import org.refcodes.graphical.ext.javafx.FxGridDragSpriteEventHandler;

public abstract class AbstractFxGridViewportPane<B extends AbstractFxGridViewportPane<B>>
extends Pane
implements GridViewportPane<Node, B> {
    private static final int DEFAULT_MOVE_VIEWPORT_DURATION_MILLIS = 250;
    private static final int DEFAULT_DRAG_VIEWPORT_DURATION_MILLIS = 250;
    private FxGridDragSpriteEventHandler _dragEventHandler = null;
    private int _viewportWidth;
    private int _viewportHeight;
    private int _viewportOffsetY;
    private int _viewportOffsetX;
    private int _fieldWidth;
    private int _fieldHeight;
    private int _fieldGap;
    private double _dragOpacity = Opacity.DRAG.getOpacity();
    private GridMode _gridMode = GridMode.NONE;
    private boolean _hasContent = false;
    private MoveMode _moveMode = MoveMode.SMOOTH;
    private int _moveViewportDurationMillis = 250;
    private int _dragViewportDurationMillis = 250;
    private BiConsumer<Integer, Integer> _mouseClickedListener;

    public AbstractFxGridViewportPane() {
    }

    public AbstractFxGridViewportPane(BiConsumer<Integer, Integer> aMouseClickedListener) {
        this._mouseClickedListener = aMouseClickedListener;
    }

    public int getViewportOffsetX() {
        return this._viewportOffsetY;
    }

    public int getViewportOffsetY() {
        return this._viewportOffsetY;
    }

    public void setViewportOffsetX(int aOffsetX) {
        this.setViewportOffset(aOffsetX, this._viewportOffsetY);
    }

    public void setViewportOffsetY(int aOffsetY) {
        this.setViewportOffset(this._viewportOffsetX, aOffsetY);
    }

    public void setViewportOffset(ViewportOffset aOffset) {
        this.setViewportOffset(aOffset.getViewportOffsetX(), aOffset.getViewportOffsetY());
    }

    public void setViewportOffset(Offset aOffset) {
        this.setViewportOffset(aOffset.getOffsetX(), aOffset.getOffsetY());
    }

    public void setViewportOffset(Position aOffset) {
        this.setViewportOffset(aOffset.getPositionX(), aOffset.getPositionY());
    }

    public int getViewportWidth() {
        return this._viewportWidth;
    }

    public int getViewportHeight() {
        return this._viewportHeight;
    }

    public void setViewportWidth(int aWidth) {
        this.setViewportDimension(aWidth, this._viewportHeight);
    }

    public void setViewportHeight(int aHeight) {
        this.setViewportDimension(this._viewportWidth, aHeight);
    }

    public void setViewportDimension(ViewportDimension aDimension) {
        this.setViewportDimension(aDimension.getViewportWidth(), aDimension.getViewportHeight());
    }

    public void setViewportDimension(Dimension aDimension) {
        this._viewportHeight = aDimension.getHeight();
        this.setViewportDimension(aDimension.getWidth(), this._viewportHeight);
    }

    public void setViewportDimension(int aWidth, int aHeight) {
        this._viewportWidth = aWidth;
        this._viewportHeight = aHeight;
        this.resize();
    }

    public int getFieldWidth() {
        return this._fieldWidth;
    }

    public int getFieldHeight() {
        return this._fieldHeight;
    }

    public int getFieldGap() {
        return this._fieldGap;
    }

    public void setFieldWidth(int aWidth) {
        this.setFieldDimension(aWidth, this._fieldHeight);
    }

    public void setFieldHeight(int aHeight) {
        this.setFieldHeight(aHeight);
    }

    public void setFieldDimension(FieldDimension aDimension) {
        this.setFieldDimension(aDimension.getFieldWidth(), aDimension.getFieldHeight());
        this.setFieldGap(aDimension.getFieldGap());
    }

    public void setFieldDimension(Dimension aDimension) {
        this.setFieldDimension(aDimension.getWidth(), aDimension.getHeight());
    }

    public double getDragOpacity() {
        return this._dragOpacity;
    }

    public MoveMode getMoveMode() {
        return this._moveMode;
    }

    public GridMode getGridMode() {
        return this._gridMode;
    }

    public void setGridMode(GridMode aGridMode) {
        if (this._gridMode != aGridMode) {
            this._gridMode = aGridMode;
            this.resize();
        }
    }

    public void setDragOpacity(double aOpacity) {
        this._dragOpacity = aOpacity;
        if (this._dragEventHandler != null) {
            this._dragEventHandler.setDragOpacity(aOpacity);
        }
    }

    public void setFieldDimension(int aWidth, int aHeight) {
        if (this._fieldWidth != aWidth || this._fieldHeight != aHeight) {
            this._fieldWidth = aWidth;
            this._fieldHeight = aHeight;
            this.resize();
        }
        if (this._dragEventHandler != null) {
            this._dragEventHandler.setFieldDimension((FieldDimension)this);
        }
    }

    public void setFieldDimension(int aWidth, int aHeight, int aGap) {
        if (this._fieldWidth != aWidth || this._fieldHeight != aHeight || this._fieldGap != aGap) {
            this._fieldWidth = aWidth;
            this._fieldHeight = aHeight;
            this._fieldGap = aGap;
            this.resize();
        }
        if (this._dragEventHandler != null) {
            this._dragEventHandler.setFieldDimension((FieldDimension)this);
        }
    }

    public void setFieldGap(int aGap) {
        if (this._fieldGap != aGap) {
            this._fieldGap = aGap;
            this.resize();
        }
        this._fieldGap = aGap;
        if (this._dragEventHandler != null) {
            this._dragEventHandler.setFieldGap(aGap);
        }
    }

    public void setMoveMode(MoveMode aMoveMode) {
        this._moveMode = aMoveMode;
        if (this._dragEventHandler != null) {
            this._dragEventHandler.setMoveMode(aMoveMode);
        }
    }

    public void setViewportOffset(int aOffsetX, int aOffsetY) {
        if (aOffsetX != this._viewportOffsetX || aOffsetY != this._viewportOffsetY) {
            this._viewportOffsetX = aOffsetX;
            this._viewportOffsetY = aOffsetY;
            if (this._dragEventHandler != null) {
                this._dragEventHandler.setOffset(aOffsetX, aOffsetY);
            }
        }
    }

    public int getMoveViewportDurationMillis() {
        return this._moveViewportDurationMillis;
    }

    public void setMoveViewportDurationMillis(int aMoveViewportDurationMillis) {
        this._moveViewportDurationMillis = aMoveViewportDurationMillis;
    }

    public AbstractFxGridViewportPane<B> withMoveViewportDurationMillis(int aMoveViewportDurationMillis) {
        this.setMoveViewportDurationMillis(aMoveViewportDurationMillis);
        return this;
    }

    public int getDragViewportDurationMillis() {
        return this._dragViewportDurationMillis;
    }

    public void setDragViewportDurationMillis(int aDragViewportDurationMillis) {
        this._dragViewportDurationMillis = aDragViewportDurationMillis;
        if (this._dragEventHandler != null) {
            this._dragEventHandler.setDragSpriteDurationMillis(aDragViewportDurationMillis);
        }
    }

    public AbstractFxGridViewportPane<B> withDragViewportDurationMillis(int aDragViewportDurationMillis) {
        this.setDragViewportDurationMillis(aDragViewportDurationMillis);
        return this;
    }

    protected void onMouseClicked(BiConsumer<Integer, Integer> aMouseClickedListener) {
        this._mouseClickedListener = aMouseClickedListener;
    }

    protected Node getContent() {
        FxGridDragSpriteEventHandler theContentEventHandler = this._dragEventHandler;
        if (theContentEventHandler != null) {
            return theContentEventHandler.getSprite();
        }
        return null;
    }

    protected synchronized void setRoot(Node aContent) {
        if (this._dragEventHandler != null) {
            this.getChildren().remove((Object)this._dragEventHandler.getSprite());
            this._dragEventHandler.dispose();
        }
        this._dragEventHandler = new FxGridDragSpriteEventHandler(aContent, this, this._viewportOffsetX, this._viewportOffsetY, this._fieldWidth, this._fieldHeight, this._fieldGap, (aOffsetX, aOffsetY) -> {
            this._viewportOffsetX = aOffsetX;
            this._viewportOffsetY = aOffsetY;
        }, this._mouseClickedListener);
        this._dragEventHandler.setDragOpacity(this.getDragOpacity());
        this._dragEventHandler.setMoveMode(this.getMoveMode());
        this._dragEventHandler.setDragSpriteDurationMillis(this._dragViewportDurationMillis);
        this._dragEventHandler.setMoveSpriteDurationMillis(this._moveViewportDurationMillis);
        if (this._hasContent && this.getChildren().size() != 0) {
            this.getChildren().remove(0);
        } else {
            this._hasContent = true;
        }
        this.getChildren().add(0, (Object)aContent);
        this.setWidth(aContent.getBoundsInLocal().getWidth());
        this.setHeight(aContent.getBoundsInLocal().getHeight());
    }

    private void resize() {
        int theWidth = this.getViewportWidth() * (this.getFieldWidth() + this.getFieldGap());
        int theHeight = this.getViewportHeight() * (this.getFieldHeight() + this.getFieldGap());
        switch (this.getGridMode()) {
            case CLOSED: {
                theWidth += this.getFieldGap();
                theHeight += this.getFieldGap();
                break;
            }
            case PERIODIC: {
                theWidth -= this.getFieldGap();
                theHeight -= this.getFieldGap();
                break;
            }
        }
        this.setPrefSize(theWidth, theHeight);
    }
}

