/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.graphical.ext.javafx;

import java.util.ArrayList;
import java.util.List;
import javafx.animation.PauseTransition;
import javafx.application.Platform;
import javafx.event.EventHandler;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.util.Duration;
import org.refcodes.component.LifecycleStatus;
import org.refcodes.graphical.FlipBookBuilder;

public class FxFlipBookBuilder
extends ImageView
implements FlipBookBuilder<Image> {
    private final List<Image> _startUpImages = new ArrayList<Image>();
    private final List<Image> _mainLoopImages = new ArrayList<Image>();
    private final List<Image> _ceaseImages = new ArrayList<Image>();
    private LifecycleStatus _lifeCycleRequest = LifecycleStatus.NONE;
    private LifecycleStatus _lifeCycleStatus = LifecycleStatus.INITIALIZED;
    private int _imageDurationInMs = 250;
    private int _startUpDelayInMs = 1000;
    private PauseTransition _transition = null;

    public FxFlipBookBuilder() {
        this.setVisible(false);
    }

    public void addStartUpImage(Image aImage) {
        if (this._startUpImages.size() == 0) {
            this.setImage(aImage);
        }
        this._startUpImages.add(aImage);
    }

    public void addMainLoopImage(Image aImage) {
        if (this._mainLoopImages.size() == 0 && this._startUpImages.size() == 0) {
            this.setImage(aImage);
        }
        this._mainLoopImages.add(aImage);
    }

    public void addCeaseImage(Image aImage) {
        if (this._ceaseImages.size() == 0 && this._mainLoopImages.size() == 0 && this._startUpImages.size() == 0) {
            this.setImage(aImage);
        }
        this._ceaseImages.add(aImage);
    }

    public void setImageDurationInMs(int aDurationInMs) {
        this._imageDurationInMs = aDurationInMs;
    }

    public int getImageDurationInMs() {
        return this._imageDurationInMs;
    }

    public void setStartUpDelayInMs(int aStartUpDelayInMs) {
        this._startUpDelayInMs = aStartUpDelayInMs;
    }

    public int getStartUpDelayInMs() {
        return this._startUpDelayInMs;
    }

    public FxFlipBookBuilder withImageDurationInMs(int aDurationInMs) {
        this.setImageDurationInMs(aDurationInMs);
        return this;
    }

    public FxFlipBookBuilder withStartUpDelayInMs(int aStartUpDelayInMs) {
        this.setStartUpDelayInMs(aStartUpDelayInMs);
        return this;
    }

    public void initialize() {
        this._lifeCycleStatus = LifecycleStatus.INITIALIZED;
    }

    public void start() {
        if (this._lifeCycleStatus != LifecycleStatus.INITIALIZED || this._startUpImages.size() == 0) {
            this._lifeCycleStatus = LifecycleStatus.STARTED;
        }
        if (this._transition != null) {
            throw new IllegalStateException("The flip book must not be started again after it has been started but not stopped (destroyed) again");
        }
        AnimationDaemon theRunner = new AnimationDaemon();
        if (Platform.isFxApplicationThread()) {
            theRunner.run();
        } else {
            Platform.runLater((Runnable)theRunner);
        }
    }

    public void pause() {
        this._lifeCycleRequest = LifecycleStatus.PAUSED;
    }

    public void resume() {
        this._lifeCycleRequest = LifecycleStatus.STARTED;
    }

    public void stop() {
        this._lifeCycleRequest = LifecycleStatus.STOPPED;
        PauseTransition theTransition = this._transition;
        if (theTransition != null) {
            this._transition = null;
            theTransition.stop();
        }
    }

    public void cease() {
        this._lifeCycleRequest = LifecycleStatus.CEASED;
    }

    public void destroy() {
        this.stop();
        this._startUpImages.clear();
    }

    private class AnimationDaemon
    implements Runnable {
        private int _index = 0;

        private AnimationDaemon() {
        }

        @Override
        public void run() {
            FxFlipBookBuilder.this._transition = new PauseTransition();
            if (FxFlipBookBuilder.this._lifeCycleStatus != LifecycleStatus.INITIALIZED || FxFlipBookBuilder.this._startUpDelayInMs <= 0) {
                this.flipImage();
                FxFlipBookBuilder.this._transition.setDuration(Duration.millis((double)FxFlipBookBuilder.this._imageDurationInMs));
            } else {
                FxFlipBookBuilder.this._transition.setDuration(Duration.millis((double)FxFlipBookBuilder.this._startUpDelayInMs));
            }
            FxFlipBookBuilder.this._transition.setCycleCount(1);
            FxFlipBookBuilder.this._transition.play();
            EventHandler onFinished = t -> {
                this.flipImage();
                PauseTransition theTransition = FxFlipBookBuilder.this._transition;
                if (theTransition != null) {
                    theTransition.setDuration(Duration.millis((double)FxFlipBookBuilder.this._imageDurationInMs));
                    theTransition.play();
                }
            };
            FxFlipBookBuilder.this._transition.setOnFinished(onFinished);
        }

        private void flipImage() {
            FxFlipBookBuilder.this.setVisible(true);
            List<Image> theImages = null;
            switch (FxFlipBookBuilder.this._lifeCycleStatus) {
                case CEASED: {
                    theImages = FxFlipBookBuilder.this._ceaseImages;
                    break;
                }
                case DESTROYED: {
                    break;
                }
                case INITIALIZED: {
                    theImages = FxFlipBookBuilder.this._startUpImages;
                    if (this._index <= theImages.size() - 1) break;
                    this._index = 0;
                    FxFlipBookBuilder.this._lifeCycleStatus = LifecycleStatus.STARTED;
                    FxFlipBookBuilder.this._lifeCycleRequest = LifecycleStatus.NONE;
                    theImages = FxFlipBookBuilder.this._mainLoopImages;
                    break;
                }
                case NONE: {
                    break;
                }
                case PAUSED: {
                    break;
                }
                case STARTED: {
                    theImages = FxFlipBookBuilder.this._mainLoopImages;
                    break;
                }
                case STOPPED: {
                    break;
                }
            }
            switch (FxFlipBookBuilder.this._lifeCycleRequest) {
                case CEASED: {
                    if (this._index <= theImages.size() - 1) break;
                    this._index = 0;
                    FxFlipBookBuilder.this._lifeCycleStatus = LifecycleStatus.CEASED;
                    FxFlipBookBuilder.this._lifeCycleRequest = LifecycleStatus.NONE;
                    theImages = FxFlipBookBuilder.this._ceaseImages;
                    break;
                }
                case DESTROYED: {
                    break;
                }
                case INITIALIZED: {
                    this._index = 0;
                    FxFlipBookBuilder.this._lifeCycleStatus = LifecycleStatus.INITIALIZED;
                    FxFlipBookBuilder.this._lifeCycleRequest = LifecycleStatus.NONE;
                    theImages = FxFlipBookBuilder.this._startUpImages;
                    break;
                }
                case NONE: {
                    break;
                }
                case PAUSED: {
                    return;
                }
                case STARTED: {
                    break;
                }
                case STOPPED: {
                    if (this._index > theImages.size() - 1) {
                        this._index = 0;
                        FxFlipBookBuilder.this._lifeCycleStatus = LifecycleStatus.STOPPED;
                        FxFlipBookBuilder.this._lifeCycleRequest = LifecycleStatus.NONE;
                    }
                    return;
                }
            }
            if (theImages.size() > 0) {
                if (this._index > theImages.size() - 1) {
                    this._index = 0;
                }
                FxFlipBookBuilder.this.setImage(theImages.get(this._index++));
            }
        }
    }
}

