/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.graphical.ext.javafx;

import java.io.InputStream;
import javafx.geometry.Pos;
import javafx.scene.image.Image;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import org.refcodes.exception.BugException;
import org.refcodes.graphical.LayoutMode;
import org.refcodes.textual.HorizAlignTextMode;
import org.refcodes.textual.VertAlignTextMode;

public final class FxGraphicalUtility {
    private static final TextAlignModeToPos[] TEXT_ALIGN_MODE_TO_POS = new TextAlignModeToPos[]{new TextAlignModeToPos(HorizAlignTextMode.LEFT, VertAlignTextMode.TOP, Pos.TOP_LEFT), new TextAlignModeToPos(HorizAlignTextMode.CENTER, VertAlignTextMode.TOP, Pos.TOP_CENTER), new TextAlignModeToPos(HorizAlignTextMode.BLOCK, VertAlignTextMode.TOP, Pos.TOP_CENTER), new TextAlignModeToPos(HorizAlignTextMode.RIGHT, VertAlignTextMode.TOP, Pos.TOP_RIGHT), new TextAlignModeToPos(HorizAlignTextMode.LEFT, VertAlignTextMode.MIDDLE, Pos.CENTER_LEFT), new TextAlignModeToPos(HorizAlignTextMode.CENTER, VertAlignTextMode.MIDDLE, Pos.CENTER), new TextAlignModeToPos(HorizAlignTextMode.BLOCK, VertAlignTextMode.MIDDLE, Pos.CENTER), new TextAlignModeToPos(HorizAlignTextMode.RIGHT, VertAlignTextMode.MIDDLE, Pos.CENTER_RIGHT), new TextAlignModeToPos(HorizAlignTextMode.LEFT, VertAlignTextMode.BOTTOM, Pos.BOTTOM_LEFT), new TextAlignModeToPos(HorizAlignTextMode.CENTER, VertAlignTextMode.BOTTOM, Pos.BOTTOM_CENTER), new TextAlignModeToPos(HorizAlignTextMode.BLOCK, VertAlignTextMode.BOTTOM, Pos.BOTTOM_CENTER), new TextAlignModeToPos(HorizAlignTextMode.RIGHT, VertAlignTextMode.BOTTOM, Pos.BOTTOM_RIGHT)};

    private FxGraphicalUtility() {
    }

    public static Image toImage(InputStream aInputStream) {
        return new Image(aInputStream);
    }

    public static Image[] toImages(InputStream ... aInputStreams) {
        Image[] theImages = new Image[aInputStreams.length];
        for (int i = 0; i < aInputStreams.length; ++i) {
            theImages[i] = new Image(aInputStreams[i]);
        }
        return theImages;
    }

    public static double toFontSizeWidth(String aFontName, String aText, double aWidth) {
        Font theFont = new Font(aFontName, 28.0);
        double theFontSize = theFont.getSize();
        Text theText = new Text(aText);
        theText.setFont(theFont);
        double theWidth = theText.getBoundsInLocal().getWidth();
        double theFitSize = theFontSize * aWidth / theWidth;
        return theFitSize;
    }

    public static double toFontSizeHeight(String aFontName, String aText, double aHeight) {
        Font theFont = new Font(aFontName, 28.0);
        double theFontSize = theFont.getSize();
        Text theText = new Text(aText);
        theText.setFont(theFont);
        double theHeight = theText.getBoundsInLocal().getHeight();
        double theFitSize = theFontSize * aHeight / theHeight;
        return theFitSize;
    }

    public static double toFontSize(String aFontName, String aText, double aLength, LayoutMode aLayoutMode) {
        return switch (aLayoutMode) {
            default -> throw new IncompatibleClassChangeError();
            case LayoutMode.HORIZONTAL -> FxGraphicalUtility.toFontSizeWidth(aFontName, aText, aLength);
            case LayoutMode.VERTICAL -> FxGraphicalUtility.toFontSizeHeight(aFontName, aText, aLength);
        };
    }

    public static Font toFont(String aFontName, String aText, double aLength, LayoutMode aLayoutMode) {
        double theFontSize = FxGraphicalUtility.toFontSize(aFontName, aText, aLength, aLayoutMode);
        Font theFont = new Font(aFontName, theFontSize);
        return theFont;
    }

    public static Font toFontWidth(String aFontName, String aText, double aWidth) {
        return FxGraphicalUtility.toFont(aFontName, aText, aWidth, LayoutMode.HORIZONTAL);
    }

    public static Font toFontHeight(String aFontName, String aText, double aHeight) {
        return FxGraphicalUtility.toFont(aFontName, aText, aHeight, LayoutMode.VERTICAL);
    }

    public static Pos toPos(HorizAlignTextMode aHorizAlignTextMode, VertAlignTextMode aVertAlignTextMode) {
        for (TextAlignModeToPos ePos : TEXT_ALIGN_MODE_TO_POS) {
            if (ePos.vertAlignTextMode != aVertAlignTextMode || ePos.horizAlignTextMode != aHorizAlignTextMode) continue;
            return ePos.pos;
        }
        throw new BugException("Missing <Pos> definition for combination <" + String.valueOf(aHorizAlignTextMode) + "> and <" + String.valueOf(aVertAlignTextMode) + "> in implementation!");
    }

    private static class TextAlignModeToPos {
        HorizAlignTextMode horizAlignTextMode;
        VertAlignTextMode vertAlignTextMode;
        Pos pos;

        public TextAlignModeToPos(HorizAlignTextMode aHorizAlignTextMode, VertAlignTextMode aVertAlignTextMode, Pos aPos) {
            this.horizAlignTextMode = aHorizAlignTextMode;
            this.vertAlignTextMode = aVertAlignTextMode;
            this.pos = aPos;
        }
    }
}

