/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.graphical.ext.javafx;

import java.util.ArrayList;
import java.util.Random;
import javafx.scene.paint.Color;
import org.refcodes.graphical.PixGridBannerPanel;
import org.refcodes.graphical.PixelShape;
import org.refcodes.graphical.PositionImpl;
import org.refcodes.graphical.RgbPixmap;
import org.refcodes.graphical.ext.javafx.FxPixGridMatrixPane;

public class FxPixGridBannerPanel
extends FxPixGridMatrixPane
implements PixGridBannerPanel {
    private static final Random RND = new Random();

    public FxPixGridBannerPanel(int aMatrixWidth, int aMatrixHeight, Color aBackgroundColor, int aPixelWidth, int aPixelHeight, PixelShape aPixelShape, float aPixelBorderWidth, Color aPixelBorderColor, Color aInactivePixelColor, int aTopBorder, int aBottomBorder, int aLeftBorder, int aRightBorder, int aHorizontalSpace, float aPixelWidthToHorizontalSpaceRatio, boolean aIsForceHorizontalSpace, int aVerticalSpace, float aPixelHeightToVerticalSpaceRatio, boolean aIsForceVerticalSpace) {
        super(aMatrixWidth, aMatrixHeight, aBackgroundColor, aPixelWidth, aPixelHeight, aPixelShape, aPixelBorderWidth, aPixelBorderColor, aInactivePixelColor, aTopBorder, aBottomBorder, aLeftBorder, aRightBorder, aHorizontalSpace, aPixelWidthToHorizontalSpaceRatio, aIsForceHorizontalSpace, aVerticalSpace, aPixelHeightToVerticalSpaceRatio, aIsForceVerticalSpace);
    }

    public FxPixGridBannerPanel(int aMatrixWidth, int aMatrixHeight, java.awt.Color aBackgroundColor, int aPixelWidth, int aPixelHeight, PixelShape aPixelShape, float aPixelBorderWidth, java.awt.Color aPixelBorderColor, java.awt.Color aInactivePixelColor, int aTopBorder, int aBottomBorder, int aLeftBorder, int aRightBorder, int aHorizontalSpace, float aPixelWidthToHorizontalSpaceRatio, boolean isForceHorizontalSpace, int aVerticalSpace, float aPixelHeightToVerticalSpaceRatio, boolean isForceVerticalSpace) {
        super(aMatrixWidth, aMatrixHeight, aBackgroundColor, aPixelWidth, aPixelHeight, aPixelShape, aPixelBorderWidth, aPixelBorderColor, aInactivePixelColor, aTopBorder, aBottomBorder, aLeftBorder, aRightBorder, aHorizontalSpace, aPixelWidthToHorizontalSpaceRatio, isForceHorizontalSpace, aVerticalSpace, aPixelHeightToVerticalSpaceRatio, isForceVerticalSpace);
    }

    public FxPixGridBannerPanel(int aMatrixWidth, int aMatrixHeight, String aBackgroundColor, int aPixelWidth, int aPixelHeight, PixelShape aPixelShape, float aPixelBorderWidth, String aPixelBorderColor, String aInactivePixelColor, int aTopBorder, int aBottomBorder, int aLeftBorder, int aRightBorder, int aHorizontalSpace, float aPixelWidthToHorizontalSpaceRatio, boolean isForceHorizontalSpace, int aVerticalSpace, float aPixelHeightToVerticalSpaceRatio, boolean isForceVerticalSpace) {
        super(aMatrixWidth, aMatrixHeight, aBackgroundColor, aPixelWidth, aPixelHeight, aPixelShape, aPixelBorderWidth, aPixelBorderColor, aInactivePixelColor, aTopBorder, aBottomBorder, aLeftBorder, aRightBorder, aHorizontalSpace, aPixelWidthToHorizontalSpaceRatio, isForceHorizontalSpace, aVerticalSpace, aPixelHeightToVerticalSpaceRatio, isForceVerticalSpace);
    }

    public void moveNorth(int aSteps, int aStartDelayMillis, int aEndDelayMillis) {
        if (this.getRgbPixmap() != null) {
            int theXOffset = this.getPixmapOffsetX();
            if (aSteps <= 0) {
                throw new IllegalArgumentException("You provided an illegal value for the steps argument! You provided the value <" + aSteps + ">!");
            }
            int eYOffset = this.getPixmapOffsetY();
            float theDelaySteps = aStartDelayMillis < aEndDelayMillis ? (float)((aEndDelayMillis - aStartDelayMillis) / aSteps) : (float)((aStartDelayMillis - aEndDelayMillis) / aSteps * -1);
            float eDelay = aStartDelayMillis;
            for (int i = 0; i < aSteps; ++i) {
                if (--eYOffset < 0) {
                    eYOffset += this.getRgbPixmap().getHeight() - 1;
                }
                this.setPixmapOffset(theXOffset, eYOffset);
                this.repaint();
                this.delay((int)eDelay);
                eDelay += theDelaySteps;
                if (!(eDelay < 0.0f)) continue;
                eDelay = 0.0f;
            }
        }
    }

    public void moveNorthEast(int aSteps, int aStartDelayMillis, int aEndDelayMillis) {
        if (this.getRgbPixmap() != null) {
            int eXOffset = this.getPixmapOffsetX();
            if (aSteps <= 0) {
                throw new IllegalArgumentException("You provided an illegal value for the steps argument! You provided the value <" + aSteps + ">!");
            }
            int eYOffset = this.getPixmapOffsetY();
            float theDelaySteps = aStartDelayMillis < aEndDelayMillis ? (float)((aEndDelayMillis - aStartDelayMillis) / aSteps) : (float)((aStartDelayMillis - aEndDelayMillis) / aSteps * -1);
            float eDelay = aStartDelayMillis;
            for (int i = 0; i < aSteps; ++i) {
                if (++eXOffset >= this.getRgbPixmap().getWidth()) {
                    eXOffset -= this.getRgbPixmap().getWidth() - 1;
                }
                if (--eYOffset < 0) {
                    eYOffset += this.getRgbPixmap().getHeight() - 1;
                }
                this.setPixmapOffset(eXOffset, eYOffset);
                this.repaint();
                this.delay((int)eDelay);
                eDelay += theDelaySteps;
                if (!(eDelay < 0.0f)) continue;
                eDelay = 0.0f;
            }
        }
    }

    public void moveEast(int aSteps, int aStartDelayMillis, int aEndDelayMillis) {
        if (this.getRgbPixmap() != null) {
            if (aSteps <= 0) {
                throw new IllegalArgumentException("You provided an illegal value for the steps argument! You provided the value <" + aSteps + ">!");
            }
            int theYOffset = this.getPixmapOffsetY();
            int eXOffset = this.getPixmapOffsetX();
            float theDelaySteps = aStartDelayMillis < aEndDelayMillis ? (float)((aEndDelayMillis - aStartDelayMillis) / aSteps) : (float)((aStartDelayMillis - aEndDelayMillis) / aSteps * -1);
            float eDelay = aStartDelayMillis;
            for (int i = 0; i < aSteps; ++i) {
                if (++eXOffset >= this.getRgbPixmap().getWidth()) {
                    eXOffset -= this.getRgbPixmap().getWidth() - 1;
                }
                this.setPixmapOffset(eXOffset, theYOffset);
                this.repaint();
                this.delay((int)eDelay);
                eDelay += theDelaySteps;
                if (!(eDelay < 0.0f)) continue;
                eDelay = 0.0f;
            }
        }
    }

    public void moveSouthEast(int aSteps, int aStartDelayMillis, int aEndDelayMillis) {
        if (this.getRgbPixmap() != null) {
            int eXOffset = this.getPixmapOffsetX();
            if (aSteps <= 0) {
                throw new IllegalArgumentException("You provided an illegal value for the steps argument! You provided the value <" + aSteps + ">!");
            }
            int eYOffset = this.getPixmapOffsetY();
            float theDelaySteps = aStartDelayMillis < aEndDelayMillis ? (float)((aEndDelayMillis - aStartDelayMillis) / aSteps) : (float)((aStartDelayMillis - aEndDelayMillis) / aSteps * -1);
            float eDelay = aStartDelayMillis;
            for (int i = 0; i < aSteps; ++i) {
                if (++eXOffset >= this.getRgbPixmap().getWidth()) {
                    eXOffset -= this.getRgbPixmap().getWidth() - 1;
                }
                if (++eYOffset >= this.getRgbPixmap().getHeight()) {
                    eYOffset -= this.getRgbPixmap().getHeight() - 1;
                }
                this.setPixmapOffset(eXOffset, eYOffset);
                this.repaint();
                this.delay((int)eDelay);
                eDelay += theDelaySteps;
                if (!(eDelay < 0.0f)) continue;
                eDelay = 0.0f;
            }
        }
    }

    public void moveSouth(int aSteps, int aStartDelayMillis, int aEndDelayMillis) {
        if (this.getRgbPixmap() != null) {
            int theXOffset = this.getPixmapOffsetX();
            if (aSteps <= 0) {
                throw new IllegalArgumentException("You provided an illegal value for the steps argument! You provided the value <" + aSteps + ">!");
            }
            int eYOffset = this.getPixmapOffsetY();
            float theDelaySteps = aStartDelayMillis < aEndDelayMillis ? (float)((aEndDelayMillis - aStartDelayMillis) / aSteps) : (float)((aStartDelayMillis - aEndDelayMillis) / aSteps * -1);
            float eDelay = aStartDelayMillis;
            for (int i = 0; i < aSteps; ++i) {
                if (++eYOffset >= this.getRgbPixmap().getHeight()) {
                    eYOffset -= this.getRgbPixmap().getHeight() - 1;
                }
                this.setPixmapOffset(theXOffset, eYOffset);
                this.repaint();
                this.delay((int)eDelay);
                eDelay += theDelaySteps;
                if (!(eDelay < 0.0f)) continue;
                eDelay = 0.0f;
            }
        }
    }

    public void moveSouthWest(int aSteps, int aStartDelayMillis, int aEndDelayMillis) {
        if (this.getRgbPixmap() != null) {
            int eXOffset = this.getPixmapOffsetX();
            if (aSteps <= 0) {
                throw new IllegalArgumentException("You provided an illegal value for the steps argument! You provided the value <" + aSteps + ">!");
            }
            int eYOffset = this.getPixmapOffsetY();
            float theDelaySteps = aStartDelayMillis < aEndDelayMillis ? (float)((aEndDelayMillis - aStartDelayMillis) / aSteps) : (float)((aStartDelayMillis - aEndDelayMillis) / aSteps * -1);
            float eDelay = aStartDelayMillis;
            for (int i = 0; i < aSteps; ++i) {
                if (--eXOffset < 0) {
                    eXOffset += this.getRgbPixmap().getWidth() - 1;
                }
                if (++eYOffset >= this.getRgbPixmap().getHeight()) {
                    eYOffset -= this.getRgbPixmap().getHeight() - 1;
                }
                this.setPixmapOffset(eXOffset, eYOffset);
                this.repaint();
                this.delay((int)eDelay);
                eDelay += theDelaySteps;
                if (!(eDelay < 0.0f)) continue;
                eDelay = 0.0f;
            }
        }
    }

    public void moveWest(int aSteps, int aStartDelayMillis, int aEndDelayMillis) {
        if (this.getRgbPixmap() != null) {
            if (aSteps <= 0) {
                throw new IllegalArgumentException("You provided an illegal value for the steps argument! You provided the value <" + aSteps + ">!");
            }
            int theYOffset = this.getPixmapOffsetY();
            int eXOffset = this.getPixmapOffsetX();
            float theDelaySteps = aStartDelayMillis < aEndDelayMillis ? (float)((aEndDelayMillis - aStartDelayMillis) / aSteps) : (float)((aStartDelayMillis - aEndDelayMillis) / aSteps * -1);
            float eDelay = aStartDelayMillis;
            for (int i = 0; i < aSteps; ++i) {
                if (--eXOffset < 0) {
                    eXOffset += this.getRgbPixmap().getWidth() - 1;
                }
                this.setPixmapOffset(eXOffset, theYOffset);
                this.repaint();
                this.delay((int)eDelay);
                eDelay += theDelaySteps;
                if (!(eDelay < 0.0f)) continue;
                eDelay = 0.0f;
            }
        }
    }

    public void moveNorthWest(int aSteps, int aStartDelayMillis, int aEndDelayMillis) {
        if (this.getRgbPixmap() != null) {
            int eXOffset = this.getPixmapOffsetX();
            if (aSteps <= 0) {
                throw new IllegalArgumentException("You provided an illegal value for the steps argument! You provided the value <" + aSteps + ">!");
            }
            int eYOffset = this.getPixmapOffsetY();
            float theDelaySteps = aStartDelayMillis < aEndDelayMillis ? (float)((aEndDelayMillis - aStartDelayMillis) / aSteps) : (float)((aStartDelayMillis - aEndDelayMillis) / aSteps * -1);
            float eDelay = aStartDelayMillis;
            for (int i = 0; i < aSteps; ++i) {
                if (--eXOffset < 0) {
                    eXOffset += this.getRgbPixmap().getWidth() - 1;
                }
                if (--eYOffset < 0) {
                    eYOffset += this.getRgbPixmap().getHeight() - 1;
                }
                this.setPixmapOffset(eXOffset, eYOffset);
                this.setPixmapOffset(eXOffset, eYOffset);
                this.repaint();
                this.delay((int)eDelay);
                eDelay += theDelaySteps;
                if (!(eDelay < 0.0f)) continue;
                eDelay = 0.0f;
            }
        }
    }

    public void stepFadeToPixmap(RgbPixmap.RgbPixmapBuilder aFadeToColorMatrix, int aOffsetX, int aOffsetY, int aReplaceStepWidth, int aDelayMilliSec) {
        int theMatrixSize = this.getMatrixWidth() * this.getMatrixHeight();
        if (aReplaceStepWidth > 0 && aReplaceStepWidth < theMatrixSize) {
            this._rgbPixmapBuilder = this.getPixmapSnapshot();
            this.setPixmapOffset(0, 0);
            int theWidth = this.getMatrixWidth();
            int eIndex = 0;
            ArrayList<PositionImpl> theDrawnList = new ArrayList<PositionImpl>();
            for (int eDrawn = 0; eDrawn < theMatrixSize; ++eDrawn) {
                int eYPos = eIndex / theWidth;
                int eXPos = eIndex - eYPos * theWidth;
                PositionImpl ePoint = new PositionImpl(eXPos, eYPos);
                while (theDrawnList.contains(ePoint)) {
                    eYPos = ++eIndex / theWidth;
                    eXPos = eIndex - eYPos * theWidth;
                    ePoint = new PositionImpl(eXPos, eYPos);
                }
                theDrawnList.add(ePoint);
                this.paintPixelAt(aFadeToColorMatrix, eYPos, eXPos, aOffsetX, aOffsetY, this._inactivePixelColor);
                if ((eIndex += aReplaceStepWidth) >= theMatrixSize) {
                    eIndex -= theMatrixSize;
                }
                this.delay(aDelayMilliSec);
            }
            for (int x = 0; x < this._rgbPixmapBuilder.getWidth(); ++x) {
                for (int y = 0; y < this._rgbPixmapBuilder.getHeight(); ++y) {
                    this.paintPixelAt(aFadeToColorMatrix, x, y, aOffsetX, aOffsetY, this._inactivePixelColor);
                }
            }
            theDrawnList.clear();
            this._rgbPixmapBuilder = aFadeToColorMatrix;
            this.setPixmapOffset(aOffsetX, aOffsetY);
            return;
        }
        throw new IllegalArgumentException("The provided replace step with in argument <aReplaceStepWidth> must be smaller than the number of matrix pixels and greater than 0! You provided a step with of <" + aReplaceStepWidth + ">, the size of matrix is <" + theMatrixSize + "> pixels.");
    }

    public void rndFadeToPixmap(RgbPixmap.RgbPixmapBuilder aFadeToColorMatrix, int aOffsetX, int aOffsetY, float aPixelPropability, int aDelayMilliSec) {
        int x;
        int y;
        RgbPixmap.RgbPixmapBuilder theTempMatrix;
        int theMatrixSize = this.getMatrixWidth() * this.getMatrixHeight();
        this._rgbPixmapBuilder = theTempMatrix = this.getPixmapSnapshot();
        this.setPixmapOffset(0, 0);
        int eDrawn = 0;
        int thePixelNotDrawnCount = 0;
        ArrayList<PositionImpl> theDrawnList = new ArrayList<PositionImpl>();
        while (eDrawn < theMatrixSize && thePixelNotDrawnCount < 5) {
            boolean eIsPixelDrawn = false;
            for (y = 0; y < this.getMatrixHeight(); ++y) {
                for (x = 0; x < this.getMatrixWidth(); ++x) {
                    float eRandomNumber;
                    PositionImpl ePoint = new PositionImpl(x, y);
                    if (theDrawnList.contains(ePoint) || !((double)(eRandomNumber = RND.nextFloat()) <= (double)aPixelPropability)) continue;
                    theDrawnList.add(ePoint);
                    this.paintPixelAt(aFadeToColorMatrix, y, x, aOffsetX, aOffsetY, this._inactivePixelColor);
                    ++eDrawn;
                    eIsPixelDrawn = true;
                    this.delay(aDelayMilliSec);
                }
            }
            if (!eIsPixelDrawn) {
                ++thePixelNotDrawnCount;
                continue;
            }
            thePixelNotDrawnCount = 0;
        }
        for (y = 0; y < theTempMatrix.getHeight(); ++y) {
            for (x = 0; x < theTempMatrix.getWidth(); ++x) {
                this.paintPixelAt(aFadeToColorMatrix, x, y, aOffsetX, aOffsetY, this._inactivePixelColor);
            }
        }
        theDrawnList.clear();
        this._rgbPixmapBuilder = aFadeToColorMatrix;
        this.setPixmapOffset(aOffsetX, aOffsetY);
    }

    protected void paintPixelAt(RgbPixmap.RgbPixmapBuilder aFadeToColorMatrix, int aPosY, int aPosX, int aOffsetX, int aOffsetY, Color aInactiveColor) {
        int eXPosFadeTo = aPosX + aOffsetX;
        int eYPosFadeTo = aPosY + aOffsetY;
        if (eXPosFadeTo >= aFadeToColorMatrix.getWidth() && this.isHorizontalWrapEnabled()) {
            eXPosFadeTo -= aFadeToColorMatrix.getWidth();
        }
        if (eYPosFadeTo >= aFadeToColorMatrix.getHeight() && this.isVerticalWrapEnabled()) {
            eYPosFadeTo -= aFadeToColorMatrix.getHeight();
        }
        if (eXPosFadeTo < aFadeToColorMatrix.getWidth() && eYPosFadeTo < aFadeToColorMatrix.getHeight()) {
            aInactiveColor = FxPixGridBannerPanel.toFxColor(aFadeToColorMatrix.getColorAt(eXPosFadeTo, eYPosFadeTo));
        }
        this.setColorAt(aInactiveColor, aPosX, aPosY);
    }

    private void delay(long aDelayMilliSec) {
        try {
            Thread.sleep(aDelayMilliSec);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

