/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.graphical.ext.javafx;

import java.util.Map;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import org.refcodes.factory.ContextTypeFactory;
import org.refcodes.graphical.GridMode;
import org.refcodes.graphical.Raster;

public class FxRasterFactory
implements ContextTypeFactory<Pane, Raster> {
    private Color _evenFieldColor = Color.DARKGREEN;
    private Color _oddFieldColor = Color.LIGHTGREEN;
    private Color _fieldGapColor = Color.WHITE;

    public FxRasterFactory withEvenFieldColor(Color aEvenFieldColor) {
        this.setEvenFieldColor(aEvenFieldColor);
        return this;
    }

    public FxRasterFactory withOddFieldColor(Color aOddFieldColor) {
        this.setOddFieldColor(aOddFieldColor);
        return this;
    }

    public FxRasterFactory withFieldGapColor(Color aFieldGapColor) {
        this.setFieldGapColor(aFieldGapColor);
        return this;
    }

    public Color getEvenFieldColor() {
        return this._evenFieldColor;
    }

    public void setEvenFieldColor(Color eEvenFieldColor) {
        this._evenFieldColor = eEvenFieldColor;
    }

    public Color getOddFieldColor() {
        return this._oddFieldColor;
    }

    public void setOddFieldColor(Color aOddFieldColor) {
        this._oddFieldColor = aOddFieldColor;
    }

    public Color getFieldGapColor() {
        return this._fieldGapColor;
    }

    public void setFieldGapColor(Color aFieldGapColor) {
        this._fieldGapColor = aFieldGapColor;
    }

    public Pane create(Raster aRaster) {
        return this.create(aRaster, null);
    }

    public Pane create(Raster aRaster, Map<String, String> aProperties) {
        Color theColor = this._oddFieldColor;
        Pane thePane = new Pane();
        int theBoardHeight = aRaster.getFieldHeight() * aRaster.getGridHeight() + aRaster.getFieldGap() * (aRaster.getGridHeight() - 1);
        int theBoardWidth = aRaster.getFieldWidth() * aRaster.getGridWidth() + aRaster.getFieldGap() * (aRaster.getGridWidth() - 1);
        int theGridOffset = 0;
        if (aRaster.getGridMode() == GridMode.CLOSED) {
            theBoardHeight += aRaster.getFieldGap() * 2;
            theBoardWidth += aRaster.getFieldGap() * 2;
            theGridOffset = aRaster.getFieldGap();
        }
        int theBoardOffsetH = theGridOffset;
        int theBoardOffsetV = theGridOffset;
        if (aRaster.getFieldGap() > 0) {
            Rectangle theRectangle = new Rectangle(0.0, 0.0, (double)theBoardWidth, (double)theBoardHeight);
            theRectangle.setFill((Paint)this._fieldGapColor);
            thePane.getChildren().add((Object)theRectangle);
        }
        for (int y = 0; y < aRaster.getGridHeight(); ++y) {
            for (int x = 0; x < aRaster.getGridWidth(); ++x) {
                int eX = theBoardOffsetH + aRaster.getFieldWidth() * x + x * aRaster.getFieldGap();
                int eY = theBoardOffsetV + aRaster.getFieldHeight() * y + y * aRaster.getFieldGap();
                Rectangle eRect = new Rectangle((double)eX, (double)eY, (double)aRaster.getFieldWidth(), (double)aRaster.getFieldHeight());
                eRect.setFill((Paint)theColor);
                thePane.getChildren().add((Object)eRect);
                if (theColor.equals((Object)this._oddFieldColor)) {
                    theColor = this._evenFieldColor;
                    continue;
                }
                if (!theColor.equals((Object)this._evenFieldColor)) continue;
                theColor = this._oddFieldColor;
            }
            theColor = y % 2 == 0 ? this._evenFieldColor : this._oddFieldColor;
        }
        return thePane;
    }
}

