// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// =============================================================================
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// =============================================================================
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// together with the GPL linking exception applied; as being applied by the GNU
// Classpath ("http://www.gnu.org/software/classpath/license.html")
// =============================================================================
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// =============================================================================
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.graphical;

/**
 * Provides an accessor for a max grid dimension property.
 */
public interface MaxGridDimension {

	/**
	 * Retrieves the max grid dimension from the max grid dimension property.
	 * 
	 * @return The max grid dimension stored by the max grid dimension property.
	 */
	GridDimension getMaxGridDimension();

	/**
	 * Provides a mutator for a max grid dimension property.
	 */
	public interface MaxGridDimensionMutator {

		/**
		 * Sets the max grid dimension for the max grid dimension property.
		 * 
		 * @param aGridDimension The max grid dimension to be stored by the grid
		 *        dimension property.
		 */
		void setMaxGridDimension( GridDimension aGridDimension );

		/**
		 * Sets the max grid dimension for the max grid dimension property.
		 * 
		 * @param aWidth The max grid width to be stored by the max grid
		 *        dimension property.
		 * 
		 * @param aHeight The max grid height to be stored by the max grid
		 *        dimension property.
		 */
		void setMaxGridDimension( int aWidth, int aHeight );
	}

	/**
	 * Provides a builder method for a max grid dimension property returning the
	 * builder for applying multiple build operations.
	 * 
	 * @param <B> The builder to return in order to be able to apply multiple
	 *        build operations.
	 */
	public interface MaxGridDimensionBuilder<B extends MaxGridDimensionBuilder<B>> {

		/**
		 * Sets the max grid dimension for the max grid dimension property.
		 * 
		 * @param aGridDimension The max grid dimension to be stored by the grid
		 *        dimension property.
		 * 
		 * @return The builder for applying multiple build operations.
		 */
		B withMaxGridDimension( GridDimension aGridDimension );

		/**
		 * Sets the max grid dimension for the max grid dimension property.
		 * 
		 * @param aWidth The max grid width to be stored by the max grid
		 *        dimension property.
		 * 
		 * @param aHeight The max grid height to be stored by the max grid
		 *        dimension property.
		 * 
		 * @return The builder for applying multiple build operations.
		 */
		B withMaxGridDimension( int aWidth, int aHeight );

	}

	/**
	 * Provides a max grid dimension property.
	 */
	public interface MaxGridDimensionProperty extends MaxGridDimension, MaxGridDimensionMutator {}

	/**
	 * Provides a max grid dimension property builder.
	 */
	public interface MaxGridDimensionPropertyBuilder extends MaxGridDimensionProperty, MaxGridDimensionBuilder<MaxGridDimensionPropertyBuilder> {}
}
