// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// /////////////////////////////////////////////////////////////////////////////
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// -----------------------------------------------------------------------------
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// -----------------------------------------------------------------------------
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// -----------------------------------------------------------------------------
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.graphical;

/**
 * The Class PositionImpl.
 *
 * @author steiner
 */
public class PositionImpl implements Position {

	// /////////////////////////////////////////////////////////////////////////
	// STATICS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// CONSTANTS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// VARIABLES:
	// /////////////////////////////////////////////////////////////////////////

	protected int _posX;

	protected int _posY;

	// /////////////////////////////////////////////////////////////////////////
	// CONSTRUCTORS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * Instantiates a new position impl.
	 */
	protected PositionImpl() {}

	/**
	 * Instantiates a new position impl.
	 *
	 * @param aPosX the pos X
	 * @param aPosY the pos Y
	 */
	public PositionImpl( int aPosX, int aPosY ) {
		_posX = aPosX;
		_posY = aPosY;
	}

	// /////////////////////////////////////////////////////////////////////////
	// INJECTION:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// METHODS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * {@inheritDoc}
	 */
	@Override
	public int getPositionX() {
		return _posX;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public int getPositionY() {
		return _posY;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String toString() {
		return getClass().getSimpleName() + "(" + _posX + " x " + _posY + ")@" + hashCode();
	}

	// /////////////////////////////////////////////////////////////////////////
	// HOOKS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// HELPER:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// INNER CLASSES:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * The Class PositionPropertyBuilderImpl.
	 */
	public static class PositionPropertyBuilderImpl extends PositionImpl implements PositionPropertyBuilder {

		/**
		 * Instantiates a new position property builder impl.
		 */
		public PositionPropertyBuilderImpl() {
			super();
		}

		/**
		 * Instantiates a new position property builder impl.
		 *
		 * @param aPosX the pos X
		 * @param aPosY the pos Y
		 */
		public PositionPropertyBuilderImpl( int aPosX, int aPosY ) {
			super( aPosX, aPosY );
		}

	/**
	 * {@inheritDoc}
	 */
	@Override
		public void setPositionX( int aPosX ) {
			_posX = aPosX;
		}

	/**
	 * {@inheritDoc}
	 */
	@Override
		public PositionPropertyBuilderImpl withPositionX( int aPosX ) {
			_posX = aPosX;
			return this;
		}

	/**
	 * {@inheritDoc}
	 */
	@Override
		public void setPositionY( int aPosY ) {
			_posY = aPosY;
		}

	/**
	 * {@inheritDoc}
	 */
	@Override
		public PositionPropertyBuilderImpl withPositionY( int aPosY ) {
			_posY = aPosY;
			return this;
		}

	/**
	 * {@inheritDoc}
	 */
	@Override
		public PositionPropertyBuilderImpl withPosition( int aPosX, int aPosY ) {
			setPosition( aPosX, aPosY );
			return this;
		}

	/**
	 * {@inheritDoc}
	 */
	@Override
		public PositionPropertyBuilderImpl withPosition( Position aPosition ) {
			setPosition( aPosition );
			return this;
		}

	/**
	 * {@inheritDoc}
	 */
	@Override
		public void setPosition( int aPosX, int aPosY ) {
			_posX = aPosX;
			_posY = aPosY;

		}

	/**
	 * {@inheritDoc}
	 */
	@Override
		public void setPosition( Position aPosition ) {
			_posX = aPosition.getPositionX();
			_posY = aPosition.getPositionY();
		}
	}
}