// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// =============================================================================
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// =============================================================================
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// together with the GPL linking exception applied; as being applied by the GNU
// Classpath ("http://www.gnu.org/software/classpath/license.html")
// =============================================================================
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// =============================================================================
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.graphical;

/**
 * Provides an accessor for a {@link ContainerDimension} property.
 */
public interface ContainerDimension extends ContainerHeightAccessor, ContainerWidthAccessor {

	/**
	 * The Interface ContainerDimensionMutator.
	 */
	public interface ContainerDimensionMutator extends ContainerHeightMutator, ContainerWidthMutator {

		/**
		 * Sets the container dimension.
		 *
		 * @param aContainerWidth the container width
		 * @param aContainerHeight the container height
		 */
		void setContainerDimension( int aContainerWidth, int aContainerHeight );

		/**
		 * Sets the container dimension.
		 *
		 * @param aContainerDimension the new container dimension
		 */
		void setContainerDimension( ContainerDimension aContainerDimension );

		/**
		 * Sets the container dimension.
		 *
		 * @param aDimension the new container dimension
		 */
		void setContainerDimension( Dimension aDimension );
	}

	/**
	 * The Interface ContainerDimensionBuilder.
	 *
	 * @param <B> the generic type
	 */
	public interface ContainerDimensionBuilder<B extends ContainerDimensionBuilder<B>> extends ContainerWidthBuilder<B>, ContainerHeightBuilder<B> {

		/**
		 * With container dimension.
		 *
		 * @param aContainerWidth the container width
		 * @param aContainerHeight the container height
		 * @return the b
		 */
		B withContainerDimension( int aContainerWidth, int aContainerHeight );

		/**
		 * With container dimension.
		 *
		 * @param aContainerDimension the container dimension
		 * @return the b
		 */
		B withContainerDimension( ContainerDimension aContainerDimension );

		/**
		 * With container dimension.
		 *
		 * @param aDimension the dimension
		 * @return the b
		 */
		B withContainerDimension( Dimension aDimension );
	}

	/**
	 * The Interface ContainerDimensionProperty.
	 */
	public interface ContainerDimensionProperty extends ContainerDimension, ContainerDimensionMutator, ContainerWidthProperty, ContainerHeightProperty {}

	/**
	 * The Interface ContainerDimensionPropertyBuilder.
	 */
	public interface ContainerDimensionPropertyBuilder extends ContainerDimensionProperty, ContainerDimensionBuilder<ContainerDimensionPropertyBuilder> {}

	/**
	 * Equals.
	 *
	 * @param aContainerDimensionA the container dimension A
	 * @param aContainerDimensionB the container dimension B
	 * @return true, if successful
	 */
	static boolean equals( ContainerDimension aContainerDimensionA, ContainerDimension aContainerDimensionB ) {
		return aContainerDimensionA.getContainerWidth() == aContainerDimensionB.getContainerWidth() && aContainerDimensionA.getContainerHeight() == aContainerDimensionB.getContainerHeight();
	}

}
