// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// =============================================================================
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// =============================================================================
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// together with the GPL linking exception applied; as being applied by the GNU
// Classpath ("http://www.gnu.org/software/classpath/license.html")
// =============================================================================
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// =============================================================================
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.graphical;

/**
 * Provides an accessor for a Y offset property.
 */
public interface GridOffsetYAccessor {

	/**
	 * Retrieves the Y offset from the Y offset property.
	 * 
	 * @return The Y offset stored by the Y offset property.
	 */
	int getGridOffsetY();

	/**
	 * Provides a mutator for a Y offset property.
	 */
	public interface GridOffsetYMutator {

		/**
		 * Sets the Y offset for the Y offset property.
		 * 
		 * @param aOffsetY The Y offset to be stored by the Y offset property.
		 */
		void setGridOffsetY( int aOffsetY );
	}

	/**
	 * Provides a builder method for a Y offset property returning the builder
	 * for applying multiple build operations.
	 * 
	 * @param <B> The builder to return in order to be able to apply multiple
	 *        build operations.
	 */
	public interface GridOffsetYBuilder<B extends GridOffsetYBuilder<B>> {

		/**
		 * Sets the Y offset for the Y offset property.
		 * 
		 * @param aOffsetY The Y offset to be stored by the Y offset property.
		 * 
		 * @return The builder for applying multiple build operations.
		 */
		B withGridOffsetY( int aOffsetY );
	}

	/**
	 * Provides a Y offset property.
	 */
	public interface GridOffsetYProperty extends GridOffsetYAccessor, GridOffsetYMutator {}
}
