// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// /////////////////////////////////////////////////////////////////////////////
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// -----------------------------------------------------------------------------
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// -----------------------------------------------------------------------------
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// -----------------------------------------------------------------------------
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.graphical;

/**
 * The Interface RgbPixmap.
 *
 * @author steiner
 */
public interface RgbPixmap extends Pixmap<RgbPixel> {

	/**
	 * The Interface RgbPixmapMutator.
	 */
	public interface RgbPixmapMutator extends PixmapMutator<RgbPixel> {

		/**
		 * Sets an integer value interpreted as pixel in the pixmap.
		 * 
		 * @param aPixel The pixel to be placed at the given position.
		 * @param aPosX The x position of the pixel.
		 * @param aPosY The y position of the pixel.
		 * 
		 * @throws IndexOutOfBoundsException in case the index is out of bounds.
		 */
		void setPixelAt( int aPixel, int aPosX, int aPosY ) throws IndexOutOfBoundsException;
	}

	/**
	 * The Interface RgbPixmapBuilder.
	 *
	 * @param <B> the generic type
	 */
	public interface RgbPixmapBuilder<B extends RgbPixmapBuilder<B>> extends PixmapBuilder<RgbPixel, B> {
		/**
		 * Sets an integer value interpreted as pixel in the pixmap.
		 *
		 * @param aPixel The pixel to be placed at the given position.
		 * @param aPosX The x position of the pixel.
		 * @param aPosY The y position of the pixel.
		 * @return the b
		 * @throws IndexOutOfBoundsException in case the index is out of bounds.
		 */
		B withPixelAt( int aPixel, int aPosX, int aPosY ) throws IndexOutOfBoundsException;

	}

	/**
	 * The Interface RgbPixmapProperty.
	 */
	public interface RgbPixmapProperty extends RgbPixmap, RgbPixmapMutator, PixmapProperty<RgbPixel> {}

	/**
	 * The Interface RgbPixmapPropertyBuilder.
	 */
	public interface RgbPixmapPropertyBuilder extends RgbPixmapBuilder<RgbPixmapPropertyBuilder>, RgbPixmapProperty {}
}
