// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// /////////////////////////////////////////////////////////////////////////////
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// -----------------------------------------------------------------------------
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// -----------------------------------------------------------------------------
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// -----------------------------------------------------------------------------
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.graphical;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URL;

/**
 * The Interface RgbPixmapImageBuilder.
 */
public interface RgbPixmapImageBuilder extends PixmapImageBuilder<RgbPixel> {

	/**
	 * {@inheritDoc}
	 */
	@Override
	PixmapImageBuilder<RgbPixel> withWidth( int aWidth );

	/**
	 * {@inheritDoc}
	 */
	@Override
	PixmapImageBuilder<RgbPixel> withDimension( int aWidth, int aHeight );

	/**
	 * {@inheritDoc}
	 */
	@Override
	PixmapImageBuilder<RgbPixel> withDimension( Dimension aDimension );

	/**
	 * {@inheritDoc}
	 */
	@Override
	PixmapImageBuilder<RgbPixel> withHeight( int aHeight );

	/**
	 * {@inheritDoc}
	 */
	@Override
	default RgbPixmapImageBuilder withImageInputStream( InputStream aImageStream ) {
		setImageInputStream( aImageStream );
		return this;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	default RgbPixmapImageBuilder withImageFile( File aImageFile ) throws FileNotFoundException {
		setImageFile( aImageFile );
		return this;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	default RgbPixmapImageBuilder withImageURL( URL aImageUrl ) {
		setImageURL( aImageUrl );
		return this;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	RgbPixmap toPixmap();

	/**
	 * To pixmap.
	 *
	 * @param aImageUrl the image url
	 * @return the rgb pixmap
	 */
	RgbPixmap toPixmap( URL aImageUrl );

	/**
	 * To pixmap.
	 *
	 * @param aImageStream the image stream
	 * @return the rgb pixmap
	 */
	RgbPixmap toPixmap( InputStream aImageStream );

	/**
	 * To pixmap.
	 *
	 * @param aImageFile the image file
	 * @return the rgb pixmap
	 * @throws FileNotFoundException the file not found exception
	 */
	default RgbPixmap toPixmap( File aImageFile ) throws FileNotFoundException {
		return toPixmap( new FileInputStream( aImageFile ) );
	}

}
