// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// =============================================================================
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// =============================================================================
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// together with the GPL linking exception applied; as being applied by the GNU
// Classpath ("http://www.gnu.org/software/classpath/license.html")
// =============================================================================
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// =============================================================================
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.graphical;

/**
 * Provides an accessor for a container height property.
 */
public interface ContainerHeightAccessor {

	/**
	 * Retrieves the container height from the container height property.
	 * 
	 * @return The container height stored by the container height property.
	 */
	int getContainerHeight();

	/**
	 * Provides a mutator for a container height property.
	 */
	public interface ContainerHeightMutator {

		/**
		 * Sets the container height for the container height property.
		 * 
		 * @param aHeight The container height to be stored by the container
		 *        height property.
		 */
		void setContainerHeight( int aHeight );
	}

	/**
	 * Provides a builder method for a container height property returning the
	 * builder for applying multiple build operations.
	 * 
	 * @param <B> The builder to return in order to be able to apply multiple
	 *        build operations.
	 */
	public interface ContainerHeightBuilder<B extends ContainerHeightBuilder<B>> {

		/**
		 * Sets the container height for the container height property.
		 * 
		 * @param aHeight The container height to be stored by the container
		 *        height property.
		 * 
		 * @return The builder for applying multiple build operations.
		 */
		B withContainerHeight( int aHeight );
	}

	/**
	 * Provides a container height property.
	 */
	public interface ContainerHeightProperty extends ContainerHeightAccessor, ContainerHeightMutator {}
}
