// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// =============================================================================
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// =============================================================================
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// together with the GPL linking exception applied; as being applied by the GNU
// Classpath ("http://www.gnu.org/software/classpath/license.html")
// =============================================================================
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// =============================================================================
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.graphical;

/**
 * Provides an accessor for a dimension property (width and height).
 */
public interface Dimension extends WidthAccessor, HeightAccessor {

	/**
	 * Provides an accessor for a dimension property (width and height).
	 */
	// public interface DimensionAccessor extends Dimension {
	// Dimension getDimension();
	// }

	/**
	 * Provides a mutator for a dimension property (width and height).
	 */
	public interface DimensionMutator extends WidthMutator, HeightMutator {

		/**
		 * Sets the dimension.
		 *
		 * @param aWidth the width
		 * @param aHeight the height
		 */
		void setDimension( int aWidth, int aHeight );

		/**
		 * Sets the dimension.
		 *
		 * @param aDimension the new dimension
		 */
		void setDimension( Dimension aDimension );
	}

	/**
	 * Provides a builder for a dimension property (width and height).
	 *
	 * @param <B> the generic type
	 */
	public interface DimensionBuilder<B extends DimensionBuilder<B>> extends WidthBuilder<B>, HeightBuilder<B> {

		/**
		 * With dimension.
		 *
		 * @param aWidth the width
		 * @param aHeight the height
		 * @return the b
		 */
		B withDimension( int aWidth, int aHeight );

		/**
		 * With dimension.
		 *
		 * @param aDimension the dimension
		 * @return the b
		 */
		B withDimension( Dimension aDimension );
	}

	/**
	 * Provides a property (getter / setter) for a dimension property (width and
	 * height).
	 */
	public interface DimensionProperty extends Dimension, DimensionMutator, WidthProperty, HeightProperty {}

	/**
	 * A self sufficient type being a dimension builder and property (width and
	 * height).
	 */
	public interface DimensionPropertyBuilder extends DimensionProperty, DimensionBuilder<DimensionPropertyBuilder> {}

	/**
	 * Equals.
	 *
	 * @param aDimensionA the dimension A
	 * @param aDimensionB the dimension B
	 * @return true, if successful
	 */
	static boolean equals( Dimension aDimensionA, Dimension aDimensionB ) {
		return aDimensionA.getWidth() == aDimensionB.getWidth() && aDimensionA.getHeight() == aDimensionB.getHeight();
	}
}
