// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// /////////////////////////////////////////////////////////////////////////////
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// -----------------------------------------------------------------------------
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// -----------------------------------------------------------------------------
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// -----------------------------------------------------------------------------
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.graphical;

/**
 * The Class DimensionImpl.
 *
 * @author steiner
 */
public class DimensionImpl implements Dimension {

	// /////////////////////////////////////////////////////////////////////////
	// STATICS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// CONSTANTS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// VARIABLES:
	// /////////////////////////////////////////////////////////////////////////

	protected int _width;

	protected int _height;

	// /////////////////////////////////////////////////////////////////////////
	// CONSTRUCTORS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * Instantiates a new dimension impl.
	 */
	protected DimensionImpl() {}

	/**
	 * Instantiates a new dimension impl.
	 *
	 * @param aWidth the width
	 * @param aHeight the height
	 */
	public DimensionImpl( int aWidth, int aHeight ) {
		_width = aWidth;
		_height = aHeight;
	}

	// /////////////////////////////////////////////////////////////////////////
	// INJECTION:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// METHODS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * {@inheritDoc}
	 */
	@Override
	public int getWidth() {
		return _width;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public int getHeight() {
		return _height;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String toString() {
		return getClass().getSimpleName() + "(" + _width + ":" + _height + ")@" + hashCode();
	}

	// /////////////////////////////////////////////////////////////////////////
	// HOOKS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// HELPER:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// INNER CLASSES:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * The Class DimensionPropertyBuilderImpl.
	 */
	public static class DimensionPropertyBuilderImpl extends DimensionImpl implements DimensionPropertyBuilder {

		/**
		 * Instantiates a new dimension property builder impl.
		 */
		public DimensionPropertyBuilderImpl() {
			super();
		}

		/**
		 * Instantiates a new dimension property builder impl.
		 *
		 * @param aWidth the width
		 * @param aHeight the height
		 */
		public DimensionPropertyBuilderImpl( int aWidth, int aHeight ) {
			super( aWidth, aHeight );
		}

		/**
		 * {@inheritDoc}
		 */
		@Override
		public void setWidth( int aWidth ) {
			_width = aWidth;
		}

		/**
		 * {@inheritDoc}
		 */
		@Override
		public DimensionPropertyBuilderImpl withWidth( int aWidth ) {
			_width = aWidth;
			return this;
		}

		/**
		 * {@inheritDoc}
		 */
		@Override
		public void setHeight( int aHeight ) {
			_height = aHeight;
		}

		/**
		 * {@inheritDoc}
		 */
		@Override
		public DimensionPropertyBuilderImpl withHeight( int aHeight ) {
			_height = aHeight;
			return this;
		}

		/**
		 * {@inheritDoc}
		 */
		@Override
		public DimensionPropertyBuilderImpl withDimension( int aWidth, int aHeight ) {
			setDimension( aWidth, aHeight );
			return this;
		}

		/**
		 * {@inheritDoc}
		 */
		@Override
		public DimensionPropertyBuilderImpl withDimension( Dimension aDimension ) {
			setDimension( aDimension );
			return this;
		}

		/**
		 * {@inheritDoc}
		 */
		@Override
		public void setDimension( int aWidth, int aHeight ) {
			_width = aWidth;
			_height = aHeight;

		}

		/**
		 * {@inheritDoc}
		 */
		@Override
		public void setDimension( Dimension aDimension ) {
			_width = aDimension.getWidth();
			_height = aDimension.getHeight();
		}
	}
}