// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// /////////////////////////////////////////////////////////////////////////////
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// -----------------------------------------------------------------------------
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// -----------------------------------------------------------------------------
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// -----------------------------------------------------------------------------
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.graphical;

/**
 * The Class FieldDimensionImpl.
 *
 * @author steiner
 */
public class FieldDimensionImpl implements FieldDimension {

	// /////////////////////////////////////////////////////////////////////////
	// STATICS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// CONSTANTS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// VARIABLES:
	// /////////////////////////////////////////////////////////////////////////

	protected int _fieldWidth;

	protected int _fieldHeight;

	protected int _fieldGap;

	// /////////////////////////////////////////////////////////////////////////
	// CONSTRUCTORS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * Instantiates a new field dimension impl.
	 */
	protected FieldDimensionImpl() {}

	/**
	 * Instantiates a new field dimension impl.
	 *
	 * @param aWidth the width
	 * @param aHeight the height
	 * @param aFieldGap the field gap
	 */
	public FieldDimensionImpl( int aWidth, int aHeight, int aFieldGap ) {
		_fieldWidth = aWidth;
		_fieldHeight = aHeight;
		_fieldGap = aFieldGap;
	}

	// /////////////////////////////////////////////////////////////////////////
	// INJECTION:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// METHODS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * {@inheritDoc}
	 */
	@Override
	public int getFieldWidth() {
		return _fieldWidth;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public int getFieldHeight() {
		return _fieldHeight;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public int getFieldGap() {
		return _fieldGap;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String toString() {
		return getClass().getSimpleName() + "(" + _fieldWidth + ":" + _fieldHeight + ", " + _fieldGap + ")@" + hashCode();
	}

	// /////////////////////////////////////////////////////////////////////////
	// HOOKS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// HELPER:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// INNER CLASSES:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * The Class FieldDimensionPropertyBuilderImpl.
	 */
	public static class FieldDimensionPropertyBuilderImpl extends FieldDimensionImpl implements FieldDimensionPropertyBuilder {

		/**
		 * Instantiates a new field dimension property builder impl.
		 */
		public FieldDimensionPropertyBuilderImpl() {
			super();
		}

		/**
		 * Instantiates a new field dimension property builder impl.
		 *
		 * @param aWidth the width
		 * @param aHeight the height
		 * @param aGap the gap
		 */
		public FieldDimensionPropertyBuilderImpl( int aWidth, int aHeight, int aGap ) {
			super( aWidth, aHeight, aGap );
		}

		/**
		 * {@inheritDoc}
		 */
		@Override
		public void setFieldWidth( int aWidth ) {
			_fieldWidth = aWidth;
		}

		/**
		 * {@inheritDoc}
		 */
		@Override
		public FieldDimensionPropertyBuilderImpl withFieldWidth( int aWidth ) {
			_fieldWidth = aWidth;
			return this;
		}

		/**
		 * {@inheritDoc}
		 */
		@Override
		public void setFieldHeight( int aHeight ) {
			_fieldHeight = aHeight;
		}

		/**
		 * {@inheritDoc}
		 */
		@Override
		public FieldDimensionPropertyBuilderImpl withFieldHeight( int aHeight ) {
			_fieldHeight = aHeight;
			return this;
		}

		/**
		 * {@inheritDoc}
		 */
		@Override
		public FieldDimensionPropertyBuilderImpl withFieldDimension( int aWidth, int aHeight ) {
			setFieldDimension( aWidth, aHeight );
			return this;
		}

		/**
		 * {@inheritDoc}
		 */
		@Override
		public FieldDimensionPropertyBuilderImpl withFieldDimension( int aWidth, int aHeight, int aGap ) {
			setFieldDimension( aWidth, aHeight, aGap );
			return this;
		}

		/**
		 * {@inheritDoc}
		 */
		@Override
		public FieldDimensionPropertyBuilderImpl withFieldDimension( FieldDimension aDimension ) {
			setFieldDimension( aDimension );
			return this;
		}

		/**
		 * {@inheritDoc}
		 */
		@Override
		public void setFieldDimension( int aWidth, int aHeight ) {
			_fieldWidth = aWidth;
			_fieldHeight = aHeight;
		}

		/**
		 * {@inheritDoc}
		 */
		@Override
		public void setFieldDimension( int aWidth, int aHeight, int aGap ) {
			_fieldWidth = aWidth;
			_fieldHeight = aHeight;
			_fieldGap = aGap;
		}

		/**
		 * {@inheritDoc}
		 */
		@Override
		public void setFieldDimension( FieldDimension aDimension ) {
			_fieldWidth = aDimension.getFieldWidth();
			_fieldHeight = aDimension.getFieldHeight();
			_fieldGap = aDimension.getFieldGap();
		}

		/**
		 * {@inheritDoc}
		 */
		@Override
		public FieldDimensionPropertyBuilderImpl withFieldDimension( Dimension aDimension ) {
			setFieldDimension( aDimension );
			return this;
		}

		/**
		 * {@inheritDoc}
		 */
		@Override
		public void setFieldDimension( Dimension aDimension ) {
			_fieldWidth = aDimension.getWidth();
			_fieldHeight = aDimension.getHeight();
		}

		/**
		 * {@inheritDoc}
		 */
		@Override
		public void setFieldGap( int aFieldGap ) {
			_fieldGap = aFieldGap;

		}

		/**
		 * {@inheritDoc}
		 */
		@Override
		public FieldDimensionPropertyBuilderImpl withFieldGap( int aFieldGap ) {
			setFieldGap( aFieldGap );
			return this;
		}
	}
}