// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// /////////////////////////////////////////////////////////////////////////////
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// -----------------------------------------------------------------------------
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// -----------------------------------------------------------------------------
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// -----------------------------------------------------------------------------
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.graphical;

/**
 * The Class GridDimensionImpl.
 *
 * @author steiner
 */
public class GridDimensionImpl implements GridDimension {

	// /////////////////////////////////////////////////////////////////////////
	// STATICS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// CONSTANTS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// VARIABLES:
	// /////////////////////////////////////////////////////////////////////////

	protected int _width;

	protected int _height;

	// /////////////////////////////////////////////////////////////////////////
	// CONSTRUCTORS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * Instantiates a new grid dimension impl.
	 */
	protected GridDimensionImpl() {}

	/**
	 * Instantiates a new grid dimension impl.
	 *
	 * @param aWidth the width
	 * @param aHeight the height
	 */
	public GridDimensionImpl( int aWidth, int aHeight ) {
		_width = aWidth;
		_height = aHeight;
	}

	// /////////////////////////////////////////////////////////////////////////
	// INJECTION:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// METHODS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * {@inheritDoc}
	 */
	@Override
	public int getGridWidth() {
		return _width;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public int getGridHeight() {
		return _height;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String toString() {
		return getClass().getSimpleName() + "(" + _width + ":" + _height + ")@" + hashCode();
	}

	// /////////////////////////////////////////////////////////////////////////
	// HOOKS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// HELPER:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// INNER CLASSES:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * The Class GridDimensionPropertyBuilderImpl.
	 */
	public static class GridDimensionPropertyBuilderImpl extends GridDimensionImpl implements GridDimensionPropertyBuilder {

		/**
		 * Instantiates a new grid dimension property builder impl.
		 */
		public GridDimensionPropertyBuilderImpl() {
			super();
		}

		/**
		 * Instantiates a new grid dimension property builder impl.
		 *
		 * @param aWidth the width
		 * @param aHeight the height
		 */
		public GridDimensionPropertyBuilderImpl( int aWidth, int aHeight ) {
			super( aWidth, aHeight );
		}

		/**
		 * {@inheritDoc}
		 */
		@Override
		public void setGridWidth( int aWidth ) {
			_width = aWidth;
		}

		/**
		 * {@inheritDoc}
		 */
		@Override
		public GridDimensionPropertyBuilderImpl withGridWidth( int aWidth ) {
			_width = aWidth;
			return this;
		}

		/**
		 * {@inheritDoc}
		 */
		@Override
		public void setGridHeight( int aHeight ) {
			_height = aHeight;
		}

		/**
		 * {@inheritDoc}
		 */
		@Override
		public GridDimensionPropertyBuilderImpl withGridHeight( int aHeight ) {
			_height = aHeight;
			return this;
		}

		/**
		 * {@inheritDoc}
		 */
		@Override
		public GridDimensionPropertyBuilderImpl withGridDimension( int aWidth, int aHeight ) {
			setGridDimension( aWidth, aHeight );
			return this;
		}

		/**
		 * {@inheritDoc}
		 */
		@Override
		public GridDimensionPropertyBuilderImpl withGridDimension( GridDimension aDimension ) {
			setGridDimension( aDimension );
			return this;
		}

		/**
		 * {@inheritDoc}
		 */
		@Override
		public void setGridDimension( int aWidth, int aHeight ) {
			_width = aWidth;
			_height = aHeight;

		}

		/**
		 * {@inheritDoc}
		 */
		@Override
		public void setGridDimension( GridDimension aDimension ) {
			_width = aDimension.getGridWidth();
			_height = aDimension.getGridHeight();
		}

		/**
		 * {@inheritDoc}
		 */
		@Override
		public GridDimensionPropertyBuilderImpl withGridDimension( Dimension aDimension ) {
			setGridDimension( aDimension.getWidth(), aDimension.getHeight() );
			return this;
		}

		/**
		 * {@inheritDoc}
		 */
		@Override
		public void setGridDimension( Dimension aDimension ) {
			_width = aDimension.getWidth();
			_height = aDimension.getHeight();
		}

	}
}