// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// =============================================================================
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// =============================================================================
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// together with the GPL linking exception applied; as being applied by the GNU
// Classpath ("http://www.gnu.org/software/classpath/license.html")
// =============================================================================
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// =============================================================================
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.graphical;

/**
 * Provides an accessor for a Y offset property.
 */
public interface GridOffset extends GridOffsetXAccessor, GridOffsetYAccessor {

	/**
	 * The Interface GridOffsetMutator.
	 */
	public interface GridOffsetMutator extends GridOffsetXMutator, GridOffsetYMutator {

		/**
		 * Sets the grid offset.
		 *
		 * @param aOffsetX the offset X
		 * @param aOffsetY the offset Y
		 */
		void setGridOffset( int aOffsetX, int aOffsetY );

		/**
		 * Sets the grid offset.
		 *
		 * @param aOffset the new grid offset
		 */
		void setGridOffset( GridOffset aOffset );

		/**
		 * Sets the grid offset.
		 *
		 * @param aOffset the new grid offset
		 */
		void setGridOffset( Offset aOffset );

		/**
		 * Sets the grid offset.
		 *
		 * @param aOffset the new grid offset
		 */
		void setGridOffset( Position aOffset );
	}

	/**
	 * The Interface GridOffsetBuilder.
	 *
	 * @param <B> the generic type
	 */
	public interface GridOffsetBuilder<B extends GridOffsetBuilder<B>> extends GridOffsetXBuilder<B>, GridOffsetYBuilder<B> {

		/**
		 * With grid offset.
		 *
		 * @param aOffsetX the offset X
		 * @param aOffsetY the offset Y
		 * @return the b
		 */
		B withGridOffset( int aOffsetX, int aOffsetY );

		/**
		 * With grid offset.
		 *
		 * @param aOffset the offset
		 * @return the b
		 */
		B withGridOffset( GridOffset aOffset );

		/**
		 * With grid offset.
		 *
		 * @param aOffset the offset
		 * @return the b
		 */
		B withGridOffset( Offset aOffset );

		/**
		 * With grid offset.
		 *
		 * @param aOffset the offset
		 * @return the b
		 */
		B withGridOffset( Position aOffset );
	}

	/**
	 * The Interface GridOffsetProperty.
	 */
	public interface GridOffsetProperty extends GridOffset, GridOffsetMutator, GridOffsetXProperty, GridOffsetYProperty {}

	/**
	 * The Interface GridOffsetPropertyBuilder.
	 */
	public interface GridOffsetPropertyBuilder extends GridOffsetProperty, GridOffsetBuilder<GridOffsetPropertyBuilder> {}

	/**
	 * Equals.
	 *
	 * @param aOffsetA the offset A
	 * @param aOffsetB the offset B
	 * @return true, if successful
	 */
	static boolean equals( GridOffset aOffsetA, GridOffset aOffsetB ) {
		return aOffsetA.getGridOffsetX() == aOffsetB.getGridOffsetX() && aOffsetA.getGridOffsetY() == aOffsetB.getGridOffsetY();
	}

}
