// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// =============================================================================
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// =============================================================================
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// together with the GPL linking exception applied; as being applied by the GNU
// Classpath ("http://www.gnu.org/software/classpath/license.html")
// =============================================================================
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// =============================================================================
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.graphical;

/**
 * Provides an accessor for a Y offset property.
 */
public interface Offset extends OffsetXAccessor, OffsetYAccessor {

	/**
	 * The Interface OffsetMutator.
	 */
	public interface OffsetMutator extends OffsetXMutator, OffsetYMutator {

		/**
		 * Sets the offset.
		 *
		 * @param aOffsetX the offset X
		 * @param aOffsetY the offset Y
		 */
		void setOffset( int aOffsetX, int aOffsetY );

		/**
		 * Sets the offset.
		 *
		 * @param aOffset the new offset
		 */
		void setOffset( Offset aOffset );

		/**
		 * Sets the offset.
		 *
		 * @param aOffset the new offset
		 */
		void setOffset( Position aOffset );
	}

	/**
	 * The Interface OffsetBuilder.
	 *
	 * @param <B> the generic type
	 */
	public interface OffsetBuilder<B extends OffsetBuilder<B>> extends OffsetXBuilder<B>, OffsetYBuilder<B> {

		/**
		 * With offset.
		 *
		 * @param aOffsetX the offset X
		 * @param aOffsetY the offset Y
		 * @return the b
		 */
		B withOffset( int aOffsetX, int aOffsetY );

		/**
		 * With offset.
		 *
		 * @param aOffset the offset
		 * @return the b
		 */
		B withOffset( Offset aOffset );

		/**
		 * With offset.
		 *
		 * @param aOffset the offset
		 * @return the b
		 */
		B withOffset( Position aOffset );
	}

	/**
	 * The Interface OffsetProperty.
	 */
	public interface OffsetProperty extends Offset, OffsetMutator, OffsetXProperty, OffsetYProperty {}

	/**
	 * The Interface OffsetPropertyBuilder.
	 */
	public interface OffsetPropertyBuilder extends OffsetProperty, OffsetBuilder<OffsetPropertyBuilder> {}

	/**
	 * Equals.
	 *
	 * @param aOffsetA the offset A
	 * @param aOffsetB the offset B
	 * @return true, if successful
	 */
	static boolean equals( Offset aOffsetA, Offset aOffsetB ) {
		return aOffsetA.getOffsetX() == aOffsetB.getOffsetX() && aOffsetA.getOffsetY() == aOffsetB.getOffsetY();
	}

}
