// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// /////////////////////////////////////////////////////////////////////////////
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// -----------------------------------------------------------------------------
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// -----------------------------------------------------------------------------
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// -----------------------------------------------------------------------------
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.graphical;

/**
 * The Class RasterImpl.
 *
 * @author steiner
 */
public class RasterImpl implements Raster {

	// /////////////////////////////////////////////////////////////////////////
	// STATICS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// CONSTANTS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// VARIABLES:
	// /////////////////////////////////////////////////////////////////////////

	protected int _gridWidth = -1;

	protected int _gridHeight = -1;

	protected int _fieldHeight = -1;

	protected int _fieldWidth = -1;

	protected int _fieldGap = 0;

	protected GridMode _gridMode = GridMode.CLOSED;

	// /////////////////////////////////////////////////////////////////////////
	// CONSTRUCTORS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * Instantiates a new raster impl.
	 */
	protected RasterImpl() {}

	/**
	 * Instantiates a new raster impl.
	 *
	 * @param aGridWidth the grid width
	 * @param aGridHeight the grid height
	 * @param aWidth the width
	 * @param aHeight the height
	 * @param aGap the gap
	 * @param aGridMode the grid mode
	 */
	public RasterImpl( int aGridWidth, int aGridHeight, int aWidth, int aHeight, int aGap, GridMode aGridMode ) {
		_gridWidth = aGridWidth;
		_gridHeight = aGridHeight;
		_fieldWidth = aWidth;
		_fieldHeight = aHeight;
		_fieldGap = aGap;
		_gridMode = aGridMode;
	}

	// /////////////////////////////////////////////////////////////////////////
	// INJECTION:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// METHODS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * {@inheritDoc}
	 */
	@Override
	public int getGridWidth() {
		return _gridWidth;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public GridMode getGridMode() {
		return _gridMode;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public int getFieldGap() {
		return _fieldGap;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public int getFieldWidth() {
		return _fieldWidth;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public int getFieldHeight() {
		return _fieldHeight;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public int getGridHeight() {
		return _gridHeight;
	}

	// /////////////////////////////////////////////////////////////////////////
	// HOOKS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// HELPER:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// INNER CLASSES:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * The Class RasterPropertyBuilderImpl.
	 */
	public static class RasterPropertyBuilderImpl extends RasterImpl implements RasterPropertyBuilder {

		/**
		 * Instantiates a new raster property builder impl.
		 */
		public RasterPropertyBuilderImpl() {
			super();
		}

		/**
		 * Instantiates a new raster property builder impl.
		 *
		 * @param aGridWidth the grid width
		 * @param aGridHeight the grid height
		 * @param aWidth the width
		 * @param aHeight the height
		 * @param aGap the gap
		 * @param aGridMode the grid mode
		 */
		public RasterPropertyBuilderImpl( int aGridWidth, int aGridHeight, int aWidth, int aHeight, int aGap, GridMode aGridMode ) {
			super( aGridWidth, aGridHeight, aWidth, aHeight, aGap, aGridMode );
		}

		/**
		 * {@inheritDoc}
		 */
		@Override
		public void setGridDimension( int aWidth, int aHeight ) {
			_gridWidth = aWidth;
			_gridHeight = aHeight;
		}

		/**
		 * {@inheritDoc}
		 */
		@Override
		public void setGridDimension( GridDimension aDimension ) {
			setGridDimension( aDimension.getGridWidth(), aDimension.getGridHeight() );
		}

		/**
		 * {@inheritDoc}
		 */
		@Override
		public void setGridDimension( Dimension aDimension ) {
			setGridDimension( aDimension.getWidth(), aDimension.getHeight() );
		}

		/**
		 * {@inheritDoc}
		 */
		@Override
		public void setGridWidth( int aWidth ) {
			setGridDimension( aWidth, _gridHeight );
		}

		/**
		 * {@inheritDoc}
		 */
		@Override
		public void setGridHeight( int aHeight ) {
			setGridDimension( _gridWidth, aHeight );
		}

		/**
		 * {@inheritDoc}
		 */
		@Override
		public RasterPropertyBuilderImpl withGridDimension( int aGridWidth, int aGridHeight ) {
			setGridDimension( aGridWidth, aGridHeight );
			return this;
		}

		/**
		 * {@inheritDoc}
		 */
		@Override
		public RasterPropertyBuilderImpl withGridDimension( GridDimension aDimension ) {
			setGridDimension( aDimension );
			return this;
		}

		/**
		 * {@inheritDoc}
		 */
		@Override
		public RasterPropertyBuilderImpl withGridDimension( Dimension aDimension ) {
			setGridDimension( aDimension );
			return this;
		}

		/**
		 * {@inheritDoc}
		 */
		@Override
		public RasterPropertyBuilderImpl withGridWidth( int aWidth ) {
			setGridWidth( aWidth );
			return this;
		}

		/**
		 * {@inheritDoc}
		 */
		@Override
		public RasterPropertyBuilderImpl withGridHeight( int aHeight ) {
			setGridHeight( aHeight );
			return this;
		}

		/**
		 * {@inheritDoc}
		 */
		@Override
		public void setGridMode( GridMode aGridMode ) {
			_gridMode = aGridMode;
		}

		/**
		 * {@inheritDoc}
		 */
		@Override
		public RasterPropertyBuilderImpl withGridMode( GridMode aGridMode ) {
			setGridMode( aGridMode );
			return this;
		}

		/**
		 * {@inheritDoc}
		 */
		@Override
		public RasterPropertyBuilderImpl withFieldWidth( int aWidth ) {
			setFieldWidth( aWidth );
			return this;
		}

		/**
		 * {@inheritDoc}
		 */
		@Override
		public RasterPropertyBuilderImpl withFieldHeight( int aHeight ) {
			setFieldHeight( aHeight );
			return this;
		}

		/**
		 * {@inheritDoc}
		 */
		@Override
		public RasterPropertyBuilderImpl withFieldDimension( int aWidth, int aHeight ) {
			setFieldDimension( aWidth, aHeight );
			return this;
		}

		/**
		 * {@inheritDoc}
		 */
		@Override
		public RasterPropertyBuilderImpl withFieldDimension( int aWidth, int aHeight, int aGap ) {
			setFieldDimension( aWidth, aHeight, aGap );
			return this;
		}

		/**
		 * {@inheritDoc}
		 */
		@Override
		public RasterPropertyBuilderImpl withFieldDimension( FieldDimension aField ) {
			setFieldDimension( aField );
			return this;
		}

		/**
		 * {@inheritDoc}
		 */
		@Override
		public RasterPropertyBuilderImpl withFieldDimension( Dimension aDimension ) {
			setFieldDimension( aDimension );
			return this;
		}

		/**
		 * {@inheritDoc}
		 */
		@Override
		public void setFieldGap( int aGap ) {
			_fieldGap = aGap;
		}

		/**
		 * {@inheritDoc}
		 */
		@Override
		public RasterPropertyBuilderImpl withFieldGap( int aGap ) {
			setFieldGap( aGap );
			return this;
		}

		/**
		 * {@inheritDoc}
		 */
		@Override
		public void setFieldDimension( int aWidth, int aHeight ) {
			_fieldWidth = aWidth;
			_fieldHeight = aHeight;
		}

		/**
		 * {@inheritDoc}
		 */
		@Override
		public void setFieldDimension( int aWidth, int aHeight, int aGap ) {
			_fieldWidth = aWidth;
			_fieldHeight = aHeight;
			_fieldGap = aGap;
		}

		/**
		 * {@inheritDoc}
		 */
		@Override
		public void setFieldDimension( FieldDimension aDimension ) {
			setFieldDimension( aDimension.getFieldWidth(), aDimension.getFieldHeight(), aDimension.getFieldGap() );
		}

		/**
		 * {@inheritDoc}
		 */
		@Override
		public void setFieldDimension( Dimension aDimension ) {
			setFieldDimension( aDimension.getWidth(), aDimension.getHeight() );
		}

		/**
		 * {@inheritDoc}
		 */
		@Override
		public void setFieldWidth( int aWidth ) {
			setFieldDimension( aWidth, _fieldHeight );
		}

		/**
		 * {@inheritDoc}
		 */
		@Override
		public void setFieldHeight( int aHeight ) {
			setFieldDimension( _fieldWidth, aHeight );
		}
	}
}
