// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// /////////////////////////////////////////////////////////////////////////////
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// -----------------------------------------------------------------------------
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// -----------------------------------------------------------------------------
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// -----------------------------------------------------------------------------
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.graphical;

/**
 * The Class RgbPixmapImpl.
 *
 * @author steiner
 */
public class RgbPixmapImpl implements RgbPixmap {

	// /////////////////////////////////////////////////////////////////////////
	// STATICS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// CONSTANTS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// VARIABLES:
	// /////////////////////////////////////////////////////////////////////////

	protected RgbPixel[][] _pixels = null;

	// /////////////////////////////////////////////////////////////////////////
	// CONSTRUCTORS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * Instantiates a new rgb pixmap impl.
	 */
	public RgbPixmapImpl() {}

	/**
	 * Instantiates a new rgb pixmap impl.
	 *
	 * @param aPixels the pixels
	 */
	public RgbPixmapImpl( RgbPixel[][] aPixels ) {
		_pixels = aPixels;
	}

	/**
	 * Instantiates a new rgb pixmap impl.
	 *
	 * @param aWidth the width
	 * @param aHeight the height
	 */
	public RgbPixmapImpl( int aWidth, int aHeight ) {
		_pixels = new RgbPixel[aWidth][aHeight];
	}

	// /////////////////////////////////////////////////////////////////////////
	// INJECTION:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// METHODS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * {@inheritDoc}
	 */
	@Override
	public RgbPixel[][] getPixels() {
		return _pixels;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public int getPixmapWidth() {
		return _pixels.length;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public int getPixmapHeight() {
		return _pixels[0].length;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public RgbPixel getPixelAt( int aPosX, int aPosY ) throws IndexOutOfBoundsException {
		return _pixels[aPosX][aPosY];
	}

	// /////////////////////////////////////////////////////////////////////////
	// HOOKS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// HELPER:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// INNER CLASSES:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * The Class RgbPixmapPropertyBuilderImpl.
	 */
	public static class RgbPixmapPropertyBuilderImpl extends RgbPixmapImpl implements RgbPixmapPropertyBuilder {

		/**
		 * Instantiates a new rgb pixmap property builder impl.
		 */
		public RgbPixmapPropertyBuilderImpl() {
			super();
		}

		/**
		 * Instantiates a new rgb pixmap property builder impl.
		 *
		 * @param aWidth the width
		 * @param aHeight the height
		 */
		public RgbPixmapPropertyBuilderImpl( int aWidth, int aHeight ) {
			super( aWidth, aHeight );
		}

		/**
		 * Instantiates a new rgb pixmap property builder impl.
		 *
		 * @param aPixels the pixels
		 */
		public RgbPixmapPropertyBuilderImpl( RgbPixel[][] aPixels ) {
			super( aPixels );
		}

		/**
		 * {@inheritDoc}
		 */
		@Override
		public RgbPixmapPropertyBuilder withPixels( RgbPixel[][] aPixels ) {
			setPixels( aPixels );
			return this;
		}

		/**
		 * {@inheritDoc}
		 */
		@Override
		public void setPixelAt( RgbPixel aPixel, int aPosX, int aPosY ) throws IndexOutOfBoundsException {
			_pixels[aPosX][aPosY] = aPixel;
		}

		/**
		 * {@inheritDoc}
		 */
		@Override
		public void setPixels( RgbPixel[][] aPixels ) {
			_pixels = aPixels;

		}

		/**
		 * {@inheritDoc}
		 */
		@Override
		public RgbPixmapPropertyBuilder withPixelAt( RgbPixel aPixel, int aPosX, int aPosY ) throws IndexOutOfBoundsException {
			setPixelAt( aPixel, aPosX, aPosY );
			return this;
		}

		/**
		 * {@inheritDoc}
		 */
		@Override
		public RgbPixmapPropertyBuilder withPixelAt( int aPixel, int aPosX, int aPosY ) throws IndexOutOfBoundsException {
			setPixelAt( aPixel, aPosX, aPosY );
			return this;
		}

		/**
		 * {@inheritDoc}
		 */
		@Override
		public void setPixelAt( int aPixel, int aPosX, int aPosY ) throws IndexOutOfBoundsException {
			setPixelAt( new RgbPixelImpl( aPixel ), aPosX, aPosY );
		}

	}

}
