// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// =============================================================================
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// =============================================================================
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// together with the GPL linking exception applied; as being applied by the GNU
// Classpath ("http://www.gnu.org/software/classpath/license.html")
// =============================================================================
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// =============================================================================
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.graphical;

/**
 * Provides an accessor for a X vector property.
 */
public interface VectorXAccessor {

	/**
	 * Retrieves the X vector from the X vector property.
	 * 
	 * @return The X vector stored by the X vector property.
	 */
	int getVectorX();

	/**
	 * Provides a mutator for a X vector property.
	 */
	public interface VectorXMutator {

		/**
		 * Sets the X vector for the X vector property.
		 * 
		 * @param aVectorX The X vector to be stored by the X vector property.
		 */
		void setVectorX( int aVectorX );
	}

	/**
	 * Provides a builder method for a X vector property returning the builder
	 * for applying multiple build operations.
	 * 
	 * @param <B> The builder to return in order to be able to apply multiple
	 *        build operations.
	 */
	public interface VectorXBuilder<B extends VectorXBuilder<B>> {

		/**
		 * Sets the X vector for the X vector property.
		 * 
		 * @param aVectorX The X vector to be stored by the X vector property.
		 * 
		 * @return The builder for applying multiple build operations.
		 */
		B withVectorX( int aVectorX );
	}

	/**
	 * Provides a X vector property.
	 */
	public interface VectorXProperty extends VectorXAccessor, VectorXMutator {}
}
