// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// /////////////////////////////////////////////////////////////////////////////
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// -----------------------------------------------------------------------------
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// -----------------------------------------------------------------------------
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// -----------------------------------------------------------------------------
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.graphical;

import org.refcodes.graphical.ContentAccessor.ContentBuilder;
import org.refcodes.graphical.ContentAccessor.ContentProperty;
import org.refcodes.graphical.DragOpacityAccessor.DragOpacityBuilder;
import org.refcodes.graphical.DragOpacityAccessor.DragOpacityProperty;
import org.refcodes.graphical.FieldDimension.FieldDimensionBuilder;
import org.refcodes.graphical.FieldDimension.FieldDimensionProperty;
import org.refcodes.graphical.GridModeAccessor.GridModeBuilder;
import org.refcodes.graphical.GridModeAccessor.GridModeProperty;
import org.refcodes.graphical.MoveModeAccessor.MoveModeBuilder;
import org.refcodes.graphical.MoveModeAccessor.MoveModeProperty;
import org.refcodes.graphical.ViewportDimension.ViewportDimensionBuilder;
import org.refcodes.graphical.ViewportDimension.ViewportDimensionProperty;
import org.refcodes.graphical.ViewportOffset.ViewportOffsetBuilder;
import org.refcodes.graphical.ViewportOffset.ViewportOffsetProperty;

import javafx.scene.Node;

/**
 * The Interface ViewportPane.
 *
 * @param <B> the generic type
 */
public interface ViewportPane<B extends ViewportPane<B>> extends GridModeProperty, GridModeBuilder<B>, FieldDimensionProperty, FieldDimensionBuilder<B>, ViewportOffsetProperty, ViewportOffsetBuilder<B>, ViewportDimensionProperty, ViewportDimensionBuilder<B>, DragOpacityProperty, DragOpacityBuilder<B>, ContentProperty<Node>, ContentBuilder<Node, B>, MoveModeProperty, MoveModeBuilder<B> {

	// /////////////////////////////////////////////////////////////////////////
	// CONSTANTS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// METHODS:
	// /////////////////////////////////////////////////////////////////////////

}
