/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.graphical;

import java.awt.Color;
import org.refcodes.graphical.HeightAccessor;
import org.refcodes.graphical.RgbPixel;
import org.refcodes.graphical.WidthAccessor;

public interface Pixmap<PX>
extends WidthAccessor,
HeightAccessor {
    public PX[][] getPixels();

    @Override
    public int getWidth();

    @Override
    public int getHeight();

    public PX getPixelAt(int var1, int var2) throws IndexOutOfBoundsException;

    default public boolean hasPixelAt(int aPosX, int aPosY) throws IndexOutOfBoundsException {
        return this.getPixelAt(aPosX, aPosY) != null;
    }

    public static interface PixmapProperty<PX>
    extends Pixmap<PX>,
    PixmapMutator<PX> {
        default public PX[][] letPixels(PX[][] aPixels) {
            this.setPixels(aPixels);
            return aPixels;
        }

        default public PX letRgbAt(PX aPixel, int aPosX, int aPosY) {
            this.setPixelAt(aPixel, aPosX, aPosY);
            return aPixel;
        }
    }

    public static interface PixmapBuilder<PX, B extends PixmapBuilder<PX, B>>
    extends PixmapProperty<PX> {
        default public void mergeWith(B aSourcePixmap, int aSourcePosX, int aSourcePosY, boolean isWrapHorizontically, boolean isWrapVertically, int aDestionationPosX, int aDestionationPosY, int aWidth, int aHeight) {
            this.mergeWith(aSourcePixmap, aSourcePosX, aSourcePosY, isWrapHorizontically, isWrapVertically, aDestionationPosX, aDestionationPosY, aWidth, aHeight, null);
        }

        default public void mergeWith(B aSourcePixmap, int aSourcePosX, int aSourcePosY, boolean isWrapHorizontically, boolean isWrapVertically, int aDestinationPosX, int aDestinationPosY, int aWidth, int aHeight, Color aTransparency) {
            block0: for (int x = 0; x < aWidth; ++x) {
                int eSourceX;
                if (isWrapHorizontically) {
                    for (eSourceX = x + aSourcePosX; eSourceX >= aSourcePixmap.getWidth(); eSourceX -= aSourcePixmap.getWidth()) {
                    }
                }
                if (eSourceX >= aSourcePixmap.getWidth() || x + aDestinationPosX >= this.getWidth()) break;
                for (int y = 0; y < aHeight; ++y) {
                    int eSourceY;
                    if (isWrapVertically) {
                        for (eSourceY = y + aSourcePosY; eSourceY >= aSourcePixmap.getHeight(); eSourceY -= aSourcePixmap.getHeight()) {
                        }
                    }
                    if (eSourceY >= aSourcePixmap.getHeight() || y + aDestinationPosY >= this.getHeight()) continue block0;
                    Object ePixel = aSourcePixmap.getPixelAt(eSourceX, eSourceY);
                    Color theTransparency = null;
                    if (ePixel instanceof Color) {
                        theTransparency = (Color)ePixel;
                    }
                    if (ePixel instanceof RgbPixel) {
                        theTransparency = ((RgbPixel)ePixel).toColor();
                    }
                    if (aTransparency != null && theTransparency != null && theTransparency.equals(aTransparency)) continue;
                    this.setPixelAt(aSourcePixmap.getPixelAt(eSourceX, eSourceY), x + aDestinationPosX, y + aDestinationPosY);
                }
            }
        }

        default public void mergeColorArrays(Pixmap<PX> aSourceColorArray) {
            int theWidth = this.getWidth();
            for (int x = 0; x < theWidth && aSourceColorArray.getWidth() > x; ++x) {
                for (int y = 0; y < this.getHeight() && aSourceColorArray.getHeight() > y; ++y) {
                    this.setPixelAt(aSourceColorArray.getPixelAt(x, y), x, y);
                }
            }
        }

        public B withPixelAt(PX var1, int var2, int var3) throws IndexOutOfBoundsException;

        public B withPixels(PX[][] var1);
    }

    public static interface PixmapMutator<PX> {
        public void setPixelAt(PX var1, int var2, int var3) throws IndexOutOfBoundsException;

        public void setPixels(PX[][] var1);
    }
}

