/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.graphical;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.refcodes.graphical.Dimension;
import org.refcodes.graphical.PixmapImageBuilder;
import org.refcodes.graphical.RgbPixel;
import org.refcodes.graphical.RgbPixmap;
import org.refcodes.graphical.RgbPixmapImpl;

public class RgbPixmapImageBuilder
implements PixmapImageBuilder<RgbPixel> {
    private InputStream _imageStream = null;
    private URL _imageUrl = null;
    private int _width = -1;
    private int _height = -1;

    @Override
    public int getWidth() {
        return this._width;
    }

    @Override
    public int getHeight() {
        return this._height;
    }

    @Override
    public void setDimension(int aWidth, int aHeight) {
        this._width = aWidth;
        this._height = aHeight;
    }

    @Override
    public void setDimension(Dimension aDimension) {
        this._width = aDimension.getWidth();
        this._height = aDimension.getHeight();
    }

    @Override
    public void setWidth(int aWidth) {
        this._width = aWidth;
    }

    @Override
    public void setHeight(int aHeight) {
        this._height = aHeight;
    }

    @Override
    public RgbPixmapImageBuilder withDimension(int aWidth, int aHeight) {
        this.setDimension(aWidth, aHeight);
        return this;
    }

    @Override
    public RgbPixmapImageBuilder withDimension(Dimension aDimension) {
        this.setDimension(aDimension);
        return this;
    }

    @Override
    public RgbPixmapImageBuilder withWidth(int aWidth) {
        this.setWidth(aWidth);
        return this;
    }

    @Override
    public RgbPixmapImageBuilder withHeight(int aHeight) {
        this.setHeight(aHeight);
        return this;
    }

    @Override
    public void setImageInputStream(InputStream aImageStream) {
        this._imageStream = aImageStream;
        this._imageUrl = null;
    }

    @Override
    public void setImageURL(URL aImageUrl) {
        this._imageStream = null;
        this._imageUrl = aImageUrl;
    }

    public RgbPixmap toPixmap() throws IOException {
        if (this._imageUrl != null) {
            return new RgbPixmapImpl(this._imageUrl, this._width, this._height);
        }
        if (this._imageStream != null) {
            return new RgbPixmapImpl(this._imageStream, this._width, this._height);
        }
        throw new IllegalStateException("Either an image URL or an image Input-Stream (File) must be set to produce a pixmap!");
    }

    public RgbPixmap toPixmap(InputStream aImageStream) throws IOException {
        return new RgbPixmapImpl(aImageStream, this._width, this._height);
    }

    public RgbPixmapImageBuilder withImageInputStream(InputStream aImageStream) {
        this.setImageInputStream(aImageStream);
        return this;
    }

    public RgbPixmapImageBuilder withImageFile(File aImageFile) throws FileNotFoundException {
        this.setImageFile(aImageFile);
        return this;
    }

    public RgbPixmapImageBuilder withImageURL(URL aImageUrl) {
        this.setImageURL(aImageUrl);
        return this;
    }

    public RgbPixmap toPixmap(File aImageFile) throws IOException {
        return new RgbPixmapImpl(aImageFile);
    }
}

