/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.graphical;

import java.awt.Color;
import org.refcodes.graphical.GraphicalUtility;
import org.refcodes.graphical.Pixmap;
import org.refcodes.graphical.RgbPixel;
import org.refcodes.graphical.RgbPixelImpl;

public interface RgbPixmap
extends Pixmap<RgbPixel> {
    default public int getRgbAt(int aPosX, int aPosY) {
        RgbPixel thePixel = (RgbPixel)this.getPixelAt(aPosX, aPosY);
        return GraphicalUtility.toRgb(thePixel.getAlpha(), thePixel.getRed(), thePixel.getGreen(), thePixel.getBlue());
    }

    default public Color getColorAt(int aPosX, int aPosY) {
        RgbPixel thePixel = (RgbPixel)this.getPixelAt(aPosX, aPosY);
        return thePixel != null ? thePixel.toColor() : null;
    }

    public static interface RgbPixmapBuilder
    extends Pixmap.PixmapBuilder<RgbPixel, RgbPixmapBuilder>,
    RgbPixmapProperty {
        default public RgbPixmapBuilder withRgbAt(int aRgbPixel, int aPosX, int aPosY) throws IndexOutOfBoundsException {
            this.setRgbAt(aRgbPixel, aPosX, aPosY);
            return this;
        }

        default public RgbPixmapBuilder withColorlAt(Color aPixel, int aPosX, int aPosY) throws IndexOutOfBoundsException {
            this.setColorAt(aPixel, aPosX, aPosY);
            return this;
        }
    }

    public static interface RgbPixmapProperty
    extends RgbPixmap,
    RgbPixmapMutator,
    Pixmap.PixmapProperty<RgbPixel> {
        @Override
        default public int letRgbAt(int aRgbPixel, int aPosX, int aPosY) {
            this.setRgbAt(aRgbPixel, aPosX, aPosY);
            return aRgbPixel;
        }

        default public Color letColorAt(Color aPixel, int aPosX, int aPosY) {
            this.setColorAt(aPixel, aPosX, aPosY);
            return aPixel;
        }
    }

    public static interface RgbPixmapMutator
    extends Pixmap.PixmapMutator<RgbPixel> {
        default public void setRgbAt(int aRgbPixel, int aPosX, int aPosY) throws IndexOutOfBoundsException {
            this.setPixelAt(new RgbPixelImpl(aRgbPixel), aPosX, aPosY);
        }

        default public void setColorAt(Color aPixel, int aPosX, int aPosY) throws IndexOutOfBoundsException {
            this.setRgbAt(aPixel.getRGB(), aPosX, aPosY);
        }
    }
}

