// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// /////////////////////////////////////////////////////////////////////////////
// This code is copyright (c) by Siegfried Steiner, Munich, Germany, distributed
// on an "AS IS" BASIS WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, and licen-
// sed under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// -----------------------------------------------------------------------------
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// -----------------------------------------------------------------------------
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// -----------------------------------------------------------------------------
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.graphical;

/**
 * The {@link Viewport} defines some elementary functionality regarding a
 * {@link Viewport} being the visible rectangle of a big scene..
 */
public interface Viewport extends ViewportDimension {

	/**
	 * Centers the viewport around the provided positions as best as possoble
	 * while keeping the viewport in bounds of the grid.
	 * 
	 * @param aPositionX The x position to which to center the viewport.
	 * @param aPositionY The y position to which to center the viewport.
	 */
	void centerViewortOffset( int aPositionX, int aPositionY );

	/**
	 * Centers the viewport around the provided positions as best as possoble
	 * while keeping the viewport in bounds of the grid.
	 *
	 * @param aPositionX The x position to which to center the viewport.
	 * @param aPositionY The y position to which to center the viewport.
	 * @param aViewportWidth The viewport width to use (overrides the actual
	 *        viewport width).
	 * @param aViewportHeight The viewport height to use (overrides the actual
	 *        viewport height).
	 */
	void centerViewortOffset( int aPositionX, int aPositionY, int aViewportWidth, int aViewportHeight );

}
