// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// =============================================================================
// This code is copyright (c) by Siegfried Steiner, Munich, Germany, distributed
// on an "AS IS" BASIS WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, and licen-
// sed under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// =============================================================================
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// together with the GPL linking exception applied; as being applied by the GNU
// Classpath ("http://www.gnu.org/software/classpath/license.html")
// =============================================================================
// Apache License, v2.0 ("http://www.apache.org/licenses/TEXT-2.0")
// =============================================================================
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.graphical;

/**
 * Provides an accessor for a width property.
 */
public interface WidthAccessor {

	/**
	 * Retrieves the width from the width property.
	 * 
	 * @return The width stored by the width property.
	 */
	int getWidth();

	/**
	 * Provides a mutator for a width property.
	 */
	public interface WidthMutator {

		/**
		 * Sets the width for the width property.
		 * 
		 * @param aWidth The width to be stored by the width property.
		 */
		void setWidth( int aWidth );
	}

	/**
	 * Provides a builder method for a width property returning the builder for
	 * applying multiple build operations.
	 * 
	 * @param <B> The builder to return in order to be able to apply multiple
	 *        build operations.
	 */
	public interface WidthBuilder<B extends WidthBuilder<B>> {

		/**
		 * Sets the width for the width property.
		 * 
		 * @param aWidth The width to be stored by the width property.
		 * 
		 * @return The builder for applying multiple build operations.
		 */
		B withWidth( int aWidth );
	}

	/**
	 * Provides a width property.
	 */
	public interface WidthProperty extends WidthAccessor, WidthMutator {

		/**
		 * This method stores and passes through the given argument, which is
		 * very useful for builder APIs: Sets the given integer (setter) as of
		 * {@link #setWidth(int)} and returns the very same value (getter).
		 * 
		 * @param aWidth The integer to set (via {@link #setWidth(int)}).
		 * 
		 * @return Returns the value passed for it to be used in conclusive
		 *         processing steps.
		 */
		default int letWidth( int aWidth ) {
			setWidth( aWidth );
			return aWidth;
		}
	}
}
