/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.graphical;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.refcodes.graphical.BoxBorderMode;

public class BoxBorderModeTest {
    private static final boolean IS_LOG_TESTS_ENABLED = Boolean.getBoolean("log.tests");
    private final boolean[][] BOX_BORDERS = new boolean[][]{{false, false, false, false}, {false, false, false, true}, {false, false, true, false}, {false, false, true, true}, {false, true, false, false}, {false, true, false, true}, {false, true, true, false}, {false, true, true, true}, {true, false, false, false}, {true, false, false, true}, {true, false, true, false}, {true, false, true, true}, {true, true, false, false}, {true, true, false, true}, {true, true, true, false}, {true, true, true, true}};

    @Test
    public void testBoxBorders() {
        for (boolean[] eBorders : this.BOX_BORDERS) {
            Object eName;
            if (!(eBorders[0] || eBorders[1] || eBorders[2] || eBorders[3])) {
                eName = "NONE";
            } else {
                eName = "";
                if (eBorders[0]) {
                    eName = (String)eName + "TOP";
                }
                if (eBorders[1]) {
                    eName = (String)eName + (((String)eName).length() > 0 ? "_" : "") + "RIGHT";
                }
                if (eBorders[2]) {
                    eName = (String)eName + (((String)eName).length() > 0 ? "_" : "") + "BOTTOM";
                }
                if (eBorders[3]) {
                    eName = (String)eName + (((String)eName).length() > 0 ? "_" : "") + "LEFT";
                }
            }
            BoxBorderMode eBox = BoxBorderMode.fromBoxBorders((boolean)eBorders[0], (boolean)eBorders[1], (boolean)eBorders[2], (boolean)eBorders[3]);
            if (IS_LOG_TESTS_ENABLED) {
                System.out.println("Expecting <" + (String)eName + "> to evaluate to <" + eBox.name() + "> ...");
            }
            Assertions.assertEquals((Object)eName, (Object)eBox.name());
        }
    }
}

