/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.graphical;

import java.awt.Color;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.refcodes.graphical.ColorDepth;

public class ColorDepthTest {
    private static final boolean IS_LOG_TESTS_ENABLED = Boolean.getBoolean("log.tests");

    @Test
    public void testAwtColorDepth() {
        Color theAwtColor = new Color(128, 128, 128);
        int theAwtRgb = theAwtColor.getRGB();
        int theAlpha = ColorDepth.TRUE_COLOR_24_BIT.toAlphaValue(theAwtRgb);
        int theRed = ColorDepth.TRUE_COLOR_24_BIT.toRedValue(theAwtRgb);
        int theGreen = ColorDepth.TRUE_COLOR_24_BIT.toGreenValue(theAwtRgb);
        int theBlue = ColorDepth.TRUE_COLOR_24_BIT.toBlueValue(theAwtRgb);
        if (IS_LOG_TESTS_ENABLED) {
            System.out.println("ALPHA = " + theAlpha);
            System.out.println("RED = " + theRed);
            System.out.println("GREEN = " + theGreen);
            System.out.println("BLUE = " + theBlue);
        }
        Assertions.assertEquals((int)theAlpha, (int)0);
        Assertions.assertEquals((int)theRed, (int)128);
        Assertions.assertEquals((int)theGreen, (int)128);
        Assertions.assertEquals((int)theBlue, (int)128);
    }

    @Test
    public void testEdgeCase() {
        int theGrayColor = 128;
        int theRgbGrayColor = ColorDepth.TRUE_COLOR_24_BIT.toColor(128, ColorDepth.GRAYSCALE_8_BIT);
        if (IS_LOG_TESTS_ENABLED) {
            System.out.println("128 --> " + theRgbGrayColor);
        }
        Assertions.assertEquals((int)theRgbGrayColor, (int)0x808080);
    }
}

