/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.interceptor;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.refcodes.interceptor.CompositeSequentialInterceptorImpl;
import org.refcodes.interceptor.Interceptor;
import org.refcodes.interceptor.WorkPieceException;

public class CompositeSequentialInterceptorTest {
    @Test
    public void testExitOnAll() throws WorkPieceException {
        AddInterceptor theAddInterceptor = new AddInterceptor(2);
        Result theResult = new Result();
        CompositeSequentialInterceptorImpl theCompoundSequentialInterceptor = new CompositeSequentialInterceptorImpl(false, false, new Interceptor[]{theAddInterceptor, theAddInterceptor, theAddInterceptor});
        theCompoundSequentialInterceptor.doIntercept((Object)theResult);
        Assertions.assertEquals((int)2, (int)theResult.getResult());
    }

    @Test
    public void testContinueOnFinished() throws WorkPieceException {
        AddInterceptor theAddInterceptor = new AddInterceptor(2);
        Result theResult = new Result();
        CompositeSequentialInterceptorImpl theCompoundSequentialInterceptor = new CompositeSequentialInterceptorImpl(true, false, new Interceptor[]{theAddInterceptor, theAddInterceptor, theAddInterceptor});
        theCompoundSequentialInterceptor.doIntercept((Object)theResult);
        Assertions.assertEquals((int)6, (int)theResult.getResult());
    }

    @Test
    public void testFaliOnError() {
        AddInterceptor theAddInterceptor = new AddInterceptor(2);
        DivInterceptor theDivInterceptor = new DivInterceptor(0);
        Result theResult = new Result();
        CompositeSequentialInterceptorImpl theCompoundSequentialInterceptor = new CompositeSequentialInterceptorImpl(false, false, new Interceptor[]{theDivInterceptor, theAddInterceptor, theAddInterceptor, theAddInterceptor});
        try {
            theCompoundSequentialInterceptor.doIntercept((Object)theResult);
            Assertions.fail((String)"Should not reach this code!");
        }
        catch (WorkPieceException workPieceException) {
            // empty catch block
        }
    }

    @Test
    public void testContinueOnAll() throws WorkPieceException {
        AddInterceptor theAddInterceptor = new AddInterceptor(2);
        DivInterceptor theDivInterceptor = new DivInterceptor(0);
        Result theResult = new Result();
        CompositeSequentialInterceptorImpl theCompoundSequentialInterceptor = new CompositeSequentialInterceptorImpl(true, true, new Interceptor[]{theAddInterceptor, theDivInterceptor, theAddInterceptor, theAddInterceptor});
        theCompoundSequentialInterceptor.doIntercept((Object)theResult);
        Assertions.assertEquals((int)6, (int)theResult.getResult());
    }

    public class Result {
        private int _result = 0;

        public int getResult() {
            return this._result;
        }

        public void setResult(int aResult) {
            this._result = aResult;
        }
    }

    public class DivInterceptor
    implements Interceptor<Result> {
        private int _divisor;

        public DivInterceptor(int aDivisor) {
            this._divisor = aDivisor;
        }

        public boolean doIntercept(Result aWorkPiece) throws WorkPieceException {
            try {
                aWorkPiece.setResult(aWorkPiece.getResult() / this._divisor);
            }
            catch (ArithmeticException e) {
                throw new WorkPieceException((Object)aWorkPiece, e.getMessage(), (Throwable)e);
            }
            return true;
        }
    }

    public class AddInterceptor
    implements Interceptor<Result> {
        private int _summand;

        public AddInterceptor(int aSummand) {
            this._summand = aSummand;
        }

        public boolean doIntercept(Result aWorkPiece) throws WorkPieceException {
            aWorkPiece.setResult(aWorkPiece.getResult() + this._summand);
            return true;
        }
    }
}

