/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.interceptor;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.refcodes.component.ComponentUtility;
import org.refcodes.component.CompositeComponent;
import org.refcodes.component.InitializeException;
import org.refcodes.component.PauseException;
import org.refcodes.component.ResumeException;
import org.refcodes.component.StartException;
import org.refcodes.component.StopException;
import org.refcodes.controlflow.ExecutionStrategy;
import org.refcodes.interceptor.Interceptor;
import org.refcodes.interceptor.WorkPieceException;

public class CompositeSequentialInterceptorImpl<WP>
implements Interceptor<WP>,
CompositeComponent {
    private ExecutionStrategy _componentExecutionStrategy;
    private boolean _isContinueOnFinished;
    private boolean _isContinueOnError;
    private List<Interceptor<WP>> _interceptors;

    @SafeVarargs
    public CompositeSequentialInterceptorImpl(Interceptor<WP> ... aInterceptors) {
        this(ExecutionStrategy.JOIN, false, false, aInterceptors);
    }

    @SafeVarargs
    public CompositeSequentialInterceptorImpl(ExecutionStrategy aComponentExecutionStrategy, Interceptor<WP> ... aInterceptors) {
        this(aComponentExecutionStrategy, false, false, aInterceptors);
    }

    @SafeVarargs
    public CompositeSequentialInterceptorImpl(boolean isContinueOnFinished, boolean isContinueOnError, Interceptor<WP> ... aInterceptors) {
        this(ExecutionStrategy.JOIN, isContinueOnFinished, isContinueOnError, aInterceptors);
    }

    @SafeVarargs
    public CompositeSequentialInterceptorImpl(ExecutionStrategy aComponentExecutionStrategy, boolean isContinueOnFinished, boolean isContinueOnError, Interceptor<WP> ... aInterceptors) {
        this._isContinueOnFinished = isContinueOnFinished;
        this._isContinueOnError = isContinueOnError;
        this._interceptors = Arrays.asList(aInterceptors);
        this._componentExecutionStrategy = aComponentExecutionStrategy;
    }

    @Override
    public boolean doIntercept(WP aWorkPiece) throws WorkPieceException {
        boolean isFinished = false;
        for (Interceptor<WP> eInterceptor : this._interceptors) {
            try {
                if (eInterceptor.doIntercept(aWorkPiece)) {
                    isFinished = true;
                }
                if (this._isContinueOnFinished || !isFinished) continue;
                return true;
            }
            catch (WorkPieceException e) {
                if (this._isContinueOnError) continue;
                throw e;
            }
        }
        return isFinished;
    }

    public void initialize() throws InitializeException {
        ComponentUtility.initialize((ExecutionStrategy)this._componentExecutionStrategy, this._interceptors);
    }

    public void start() throws StartException {
        ComponentUtility.start((ExecutionStrategy)this._componentExecutionStrategy, this._interceptors);
    }

    public void pause() throws PauseException {
        ComponentUtility.pause((ExecutionStrategy)this._componentExecutionStrategy, this._interceptors);
    }

    public void resume() throws ResumeException {
        ComponentUtility.resume((ExecutionStrategy)this._componentExecutionStrategy, this._interceptors);
    }

    public void stop() throws StopException {
        ComponentUtility.stop((ExecutionStrategy)this._componentExecutionStrategy, this._interceptors);
    }

    public void decompose() {
        ComponentUtility.decompose((ExecutionStrategy)this._componentExecutionStrategy, this._interceptors);
        this._interceptors.clear();
    }

    public void flush() throws IOException {
        ComponentUtility.flush((ExecutionStrategy)this._componentExecutionStrategy, this._interceptors);
    }

    public void destroy() {
        ComponentUtility.destroy((ExecutionStrategy)this._componentExecutionStrategy, this._interceptors);
        this._interceptors.clear();
    }

    public void reset() {
        ComponentUtility.reset((ExecutionStrategy)this._componentExecutionStrategy, this._interceptors);
    }

    public void open() throws IOException {
        ComponentUtility.open((ExecutionStrategy)this._componentExecutionStrategy, this._interceptors);
    }

    public void close() {
        ComponentUtility.close((ExecutionStrategy)this._componentExecutionStrategy, this._interceptors);
    }

    public void dispose() {
        ComponentUtility.dispose((ExecutionStrategy)this._componentExecutionStrategy, this._interceptors);
    }
}

