// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// /////////////////////////////////////////////////////////////////////////////
// This code is copyright (c) by Siegfried Steiner, Munich, Germany, distributed
// on an "AS IS" BASIS WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, and licen-
// sed under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// -----------------------------------------------------------------------------
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// -----------------------------------------------------------------------------
// Apache License, v2.0 ("http://www.apache.org/licenses/TEXT-2.0")
// -----------------------------------------------------------------------------
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.io;

import java.io.IOException;

import org.refcodes.component.Closable;

/**
 * (as {@link java.io.OutputStream} does not provide some useful *interface*)
 * 
 * @see java.io.OutputStream
 */
public interface BytesOutputStream extends Closable {

	/**
	 * Write.
	 *
	 * @param b the b
	 * 
	 * @throws IOException the open exception
	 */
	void write( int b ) throws IOException;

	/**
	 * Write.
	 *
	 * @param b the b
	 * 
	 * @throws IOException the open exception
	 */
	void write( byte b[] ) throws IOException;

	/**
	 * Write.
	 *
	 * @param b the b
	 * @param off the off
	 * @param len the len
	 * 
	 * @throws IOException the open exception
	 */
	void write( byte b[], int off, int len ) throws IOException;

	/**
	 * Flush.
	 *
	 * @throws IOException the open exception
	 */
	void flush() throws IOException;

	// void close() throws IOException;
}