// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// /////////////////////////////////////////////////////////////////////////////
// This code is copyright (c) by Siegfried Steiner, Munich, Germany, distributed
// on an "AS IS" BASIS WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, and licen-
// sed under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// -----------------------------------------------------------------------------
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// -----------------------------------------------------------------------------
// Apache License, v2.0 ("http://www.apache.org/licenses/TEXT-2.0")
// -----------------------------------------------------------------------------
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.concurrent.ExecutorService;

import org.refcodes.component.ConnectionStatus;

/**
 * The Class PrefetchInputStreamReceiver.
 *
 * @author steiner
 * 
 * @param <DATA> the generic type
 */
public class PrefetchInputStreamReceiver<DATA extends Serializable> implements DatagramsReceiver<DATA> {

	// /////////////////////////////////////////////////////////////////////////
	// VARIABLES:
	// /////////////////////////////////////////////////////////////////////////

	private final InputStreamConnectionReceiver<DATA> _receiver;

	// /////////////////////////////////////////////////////////////////////////
	// CONSTRUCTORS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * Instantiates a new prefetch input stream receiver impl.
	 *
	 * @param aInputStream the input stream
	 * 
	 * @throws IOException the open exception
	 */
	public PrefetchInputStreamReceiver( InputStream aInputStream ) throws IOException {
		_receiver = new PrefetchInputStreamConnectionReceiver<>();
		_receiver.open( aInputStream );
	}

	/**
	 * Instantiates a new prefetch input stream receiver impl.
	 *
	 * @param aInputStream the input stream
	 * @param aExecutorService the executor service
	 * 
	 * @throws IOException the open exception
	 */
	public PrefetchInputStreamReceiver( InputStream aInputStream, ExecutorService aExecutorService ) throws IOException {
		_receiver = new PrefetchInputStreamConnectionReceiver<>( aExecutorService );
		_receiver.open( aInputStream );
	}

	// /////////////////////////////////////////////////////////////////////////
	// METHODS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * {@inheritDoc}
	 */
	@Override
	public boolean isClosed() {
		return _receiver.isClosed();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public boolean isOpened() {
		return _receiver.isOpened();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public int available() throws IOException {
		return _receiver.available();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public DATA[] receiveAll() throws IOException {
		return _receiver.receiveAll();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public ConnectionStatus getConnectionStatus() {
		return _receiver.getConnectionStatus();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void close() throws IOException {
		_receiver.close();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public DATA receive() throws IOException {
		return _receiver.receive();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public boolean isClosable() {
		return _receiver.isClosable();
	}
}
