// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// =============================================================================
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// =============================================================================
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// together with the GPL linking exception applied; as being applied by the GNU
// Classpath ("http://www.gnu.org/software/classpath/license.html")
// =============================================================================
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// =============================================================================
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

/**
 * The refcodes-jobbus artifact makes use of the command pattern and provides a
 * frame to work with commands (jobs) also in a distributed environment (e.g.
 * REST, SOA, Cloud Computing) and provides do/undo functionality.
 * <p>
 * The terms "command" and "job" are used interchangeably. To understand the
 * benefits which the job-bus offers, we should briefly understand the command
 * pattern. Below I will describe the command pattern in the context of the
 * job-bus; which might differ slightly from the command pattern as described in
 * litera
 * <p>
 * ture.
 * 
 * Simply speaking, you push a job into your job-bus. You can either wait for
 * the job to be executed and grab its result when done or you us a handle to
 * grab the result later on. The job is being executed asynchronously, it is up
 * to the job-bus where and when it is being executed: For example the job could
 * be transported to some remote JVM to be executed there or the job could get
 * executed as soon as a worker thread is happy to grab the job from a
 * job-queue.
 *
 * <h2>Command (Job):</h2>
 *
 * A command (job) represents an (atomic) operation applied to a context
 * encapsulated in an object (as of object oriented programming). Usually a
 * command also provides means to undo its operation applied before. The command
 * is created by a client (e.g. the business logic) and passed to the job-bus
 * for execution.
 *
 * <h2>Client:</h2>
 *
 * The client may be the business logic creating a command (job) to be executed.
 *
 * <h2>Context:</h2>
 *
 * The context can be a service, a service-bus (providing a handful of
 * services), a component or a plain POJO (this depends on your requirements and
 * your implementation).
 *
 * <h2>Job-Bus:</h2>
 *
 * The job-bus takes a client's command (job) to be executed. For asynchronous
 * execution a handle is passed back to the client with which the state (in
 * progress, failure, success) of the command (job) can be determined as well as
 * the command's (job's) result be requested (the actual result or an exception
 * in case of failure). For synchronous operation, the job-bus halts your
 * invoking thread till either the result is (available and) passed back or an
 * exception is thrown.
 * <p>
 * To invoke a command (job), the job-bus, being the invoker, passes the context
 * to the command (job) and requests the command (job) to apply its operation
 * with regard to the context.
 * <p>
 * As you can see, the job-bus is responsible for managing the context and for
 * invoking the command (job). This decouples the business logic from the
 * knowledge on how to retrieve a context or where the command is actually being
 * executed (more on this later).
 * <p>
 * As of the implemented handle paradigm, the job-bus may be used by various
 * parties without revealing their command (job) instances (to each other) being
 * processed by the job-bus.
 *
 * <h2>Job-Bus directory:</h2>
 *
 * The job-bus directory is actually a plain extension of the job-bus providing
 * access to all the handles currently being managed by the job-bus. The job-bus
 * directory provides means to get a full listing of currently known
 * {@link org.refcodes.command.Command} (job) instances and the according
 * handles. Only privileged systems should access the job-bus directory as any
 * system having access can intervene with the
 * {@link org.refcodes.command.Command} (job) instances without owning those
 * {@link org.refcodes.command.Command} (job) instances (without owning the
 * according handle).
 *
 * <h2>Distributed environment:</h2>
 *
 * The operation a command (job) represents is atomic, encapsulated in an object
 * and applied to a context. The job-bus may distribute the command (job) to a
 * different job-bus, probably located on a different machine, where the command
 * (job) eventually gets executed. The result of the command (job) execution
 * then gets passed back to the originating job-bus, which then passes it back
 * to the client.
 * <p>
 * (this scenario assumes that a) your command (job) is serializable as well as
 * b) your result is serializable)
 *
 * <h2>Do-/Undo-Stack:</h2>
 *
 * As a command (job) may also undo things it has done (executed), an undo stack
 * may hold your application's command (job) instances in the order of their
 * execution. Using to undo stack in reverse order, the executed operations can
 * be undone one-by-one or in batch.
 *
 * <h2>Component / Service:</h2>
 *
 * In a component or service driven environment, the job-bus may be one of the
 * services centrally being set up and configured as well as centrally being
 * provided to your application's component (service) instances. So you have one
 * point of command (job) execution; application wide; providing the benefits of
 * the job-bus in a transparent manner to your application.
 */
package org.refcodes.jobbus;
