/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.jobbus;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ExecutorService;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.refcodes.command.NoExceptionAvailableRuntimeException;
import org.refcodes.command.NoResultAvailableRuntimeException;
import org.refcodes.command.NotYetExecutedRuntimeException;
import org.refcodes.command.Undoable;
import org.refcodes.component.Flushable;
import org.refcodes.component.HandleGenerator;
import org.refcodes.component.HandleTimeoutRuntimeException;
import org.refcodes.component.OpenException;
import org.refcodes.component.ProgressAccessor;
import org.refcodes.component.Resetable;
import org.refcodes.component.UnknownHandleRuntimeException;
import org.refcodes.component.UnsupportedHandleOperationRuntimeException;
import org.refcodes.controlflow.ControlFlowUtility;
import org.refcodes.controlflow.RetryTimeoutImpl;
import org.refcodes.data.LoopSleepTime;
import org.refcodes.data.RetryLoopCount;
import org.refcodes.exception.ExceptionUtility;
import org.refcodes.jobbus.JobBus;
import org.refcodes.logger.RuntimeLogger;
import org.refcodes.logger.RuntimeLoggerFactorySingleton;

public abstract class AbstractJobBus<CTX, H>
implements JobBus<CTX, H> {
    private static RuntimeLogger LOGGER = RuntimeLoggerFactorySingleton.createRuntimeLogger();
    private final Map<H, JobDescriptor<?>> _handleToJobDescriptors = new WeakHashMap();
    private HandleGenerator<H> _handleGenerator;
    private final CTX _context;
    private ExecutorService _executorService;

    public AbstractJobBus(CTX aContext, HandleGenerator<H> aHandleGenerator) {
        this(aContext, aHandleGenerator, null);
    }

    public AbstractJobBus(CTX aContext, HandleGenerator<H> aHandleGenerator, ExecutorService aExecutorService) {
        assert (aHandleGenerator != null);
        assert (aContext != null);
        this._handleGenerator = aHandleGenerator;
        this._context = aContext;
        this._executorService = aExecutorService == null ? ControlFlowUtility.createCachedExecutorService((boolean)true) : ControlFlowUtility.toManagedExecutorService((ExecutorService)aExecutorService);
    }

    @Override
    public H execute(Undoable<CTX, ?, ?> aJob) {
        assert (aJob != null);
        Object theHandle = this._handleGenerator.next();
        this.start(aJob, theHandle);
        return (H)theHandle;
    }

    @Override
    public <RET, E extends Exception> void execute(Undoable<CTX, RET, E> aJob, BiConsumer<RET, E> aResultConsumer) {
        assert (aJob != null);
        assert (aResultConsumer != null);
        this.invoke(aJob, aResultConsumer);
    }

    @Override
    public <RET, E extends Exception> void execute(Undoable<CTX, RET, E> aJob, Consumer<RET> aResultConsumer) {
        assert (aJob != null);
        assert (aResultConsumer != null);
        this.invoke(aJob, aResultConsumer);
    }

    @Override
    public <E extends Exception> E getException(H aHandle) throws UnknownHandleRuntimeException, NotYetExecutedRuntimeException, NoExceptionAvailableRuntimeException {
        JobDescriptor<?> theJobDescriptor = this._handleToJobDescriptors.get(aHandle);
        if (theJobDescriptor == null) {
            throw new UnknownHandleRuntimeException(aHandle, "The given handle is not known by this job-bus.");
        }
        if (!theJobDescriptor.isExecuted()) {
            throw new NotYetExecutedRuntimeException(theJobDescriptor.getJob(), "The given job has not finished execution yet.");
        }
        if (theJobDescriptor.getException() == null) {
            throw new NoExceptionAvailableRuntimeException(theJobDescriptor.getJob(), "The given job has no execption.");
        }
        return (E)theJobDescriptor.getException();
    }

    @Override
    public <RET> RET getResult(H aHandle) throws UnknownHandleRuntimeException, NotYetExecutedRuntimeException, NoResultAvailableRuntimeException {
        JobDescriptor<?> theJobDescriptor = this._handleToJobDescriptors.get(aHandle);
        if (theJobDescriptor == null) {
            throw new UnknownHandleRuntimeException(aHandle, "The given handle is not known by this job-bus.");
        }
        if (!theJobDescriptor.isExecuted()) {
            throw new NotYetExecutedRuntimeException(theJobDescriptor.getJob(), "The given job has not finished execution yet.");
        }
        if (theJobDescriptor.getExecutionStatus() != ExecutionStatus.RESULT) {
            throw new NoResultAvailableRuntimeException(theJobDescriptor.getJob(), "The given job has no execption.");
        }
        return (RET)theJobDescriptor.getResult();
    }

    @Override
    public boolean hasException(H aHandle) throws UnknownHandleRuntimeException, NotYetExecutedRuntimeException {
        JobDescriptor<?> theJobDescriptor = this._handleToJobDescriptors.get(aHandle);
        if (theJobDescriptor == null) {
            throw new UnknownHandleRuntimeException(aHandle, "The given handle is not known by this job-bus.");
        }
        if (!theJobDescriptor.isExecuted()) {
            throw new NotYetExecutedRuntimeException(theJobDescriptor.getJob(), "The given job has not finished execution yet.");
        }
        return theJobDescriptor.getException() != null;
    }

    @Override
    public boolean hasResult(H aHandle) throws UnknownHandleRuntimeException, NotYetExecutedRuntimeException {
        JobDescriptor<?> theJobDescriptor = this._handleToJobDescriptors.get(aHandle);
        if (theJobDescriptor == null) {
            throw new UnknownHandleRuntimeException(aHandle, "The given handle is not known by this job-bus.");
        }
        if (!theJobDescriptor.isExecuted()) {
            throw new NotYetExecutedRuntimeException(theJobDescriptor.getJob(), "The given job has not finished execution yet.");
        }
        return theJobDescriptor.getExecutionStatus() == ExecutionStatus.RESULT;
    }

    @Override
    public boolean isExecuted(H aHandle) throws UnknownHandleRuntimeException {
        JobDescriptor<?> theJobDescriptor = this._handleToJobDescriptors.get(aHandle);
        if (theJobDescriptor == null) {
            throw new UnknownHandleRuntimeException(aHandle, "The given handle is not known by this job-bus.");
        }
        return theJobDescriptor.isExecuted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void waitForExecution(H aHandle) throws UnknownHandleRuntimeException {
        if (!this.hasHandle(aHandle)) {
            throw new UnknownHandleRuntimeException(aHandle, "The given handle is not known by this job-bus.");
        }
        try {
            while (!this.isExecuted(aHandle)) {
                H h = aHandle;
                synchronized (h) {
                    aHandle.wait(LoopSleepTime.MIN.getMillis());
                }
            }
            return;
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void waitForExecution(H aHandle, long aTimeoutInMs) throws UnknownHandleRuntimeException, HandleTimeoutRuntimeException {
        if (!this.hasHandle(aHandle)) {
            throw new UnknownHandleRuntimeException(aHandle, "The given handle is not known by this job-bus.");
        }
        RetryTimeoutImpl theRetryTimeout = new RetryTimeoutImpl(aTimeoutInMs, RetryLoopCount.NORM_NUM_RETRY_LOOPS.getValue().intValue());
        while (!this.isExecuted(aHandle) && theRetryTimeout.hasNextRetry()) {
            theRetryTimeout.nextRetry(aHandle);
        }
        if (!this.isExecuted(aHandle)) {
            throw new HandleTimeoutRuntimeException(aHandle, "Execution of the command referenced by the given handle did not terminate in the given amount of <" + aTimeoutInMs + "> ms, aborting wait loop.");
        }
    }

    @Override
    public <JOB extends Undoable<CTX, RET, ?>, RET> RET getResult(JOB aJob) throws NoResultAvailableRuntimeException {
        Object theHandle = this._handleGenerator.next();
        JobDescriptor<RET> theJobDescriptor = this.start(aJob, theHandle);
        if (theJobDescriptor == null) {
            throw new IllegalStateException("The job bis encountered an illegal state as a just created handle for executing a job is not konwn by the job-bus any more.");
        }
        this.waitForExecution(theHandle);
        if (theJobDescriptor.getExecutionStatus() == ExecutionStatus.EXCEPTION) {
            throw new NoResultAvailableRuntimeException(theJobDescriptor.getJob(), "No result available, the job terminated with an exception!", (Throwable)theJobDescriptor.getException());
        }
        if (theJobDescriptor.getExecutionStatus() == ExecutionStatus.RESULT) {
            return theJobDescriptor.getResult();
        }
        throw new NoResultAvailableRuntimeException(aJob, "The job for which a result is excpected does not deliver a result, it is a \"void\" job.");
    }

    @Override
    public <JOB extends Undoable<CTX, RET, ?>, RET> RET getResult(JOB aJob, long aTimeoutInMs) throws NoResultAvailableRuntimeException, HandleTimeoutRuntimeException {
        Object theHandle = this._handleGenerator.next();
        JobDescriptor<RET> theJobDescriptor = this.start(aJob, theHandle);
        if (theJobDescriptor == null) {
            throw new IllegalStateException("The job bis encountered an illegal state as a just created handle for executing a job is not konwn by the job-bus any more.");
        }
        this.waitForExecution(theHandle, aTimeoutInMs);
        if (theJobDescriptor.getExecutionStatus() == ExecutionStatus.EXCEPTION) {
            throw new NoResultAvailableRuntimeException(theJobDescriptor.getJob(), "No result available, the job terminated with an exception!", (Throwable)theJobDescriptor.getException());
        }
        if (theJobDescriptor.getExecutionStatus() == ExecutionStatus.RESULT) {
            return theJobDescriptor.getResult();
        }
        throw new NoResultAvailableRuntimeException(aJob, "The job for which a result is excpected does not deliver a result, it is a \"void\" job.");
    }

    public boolean hasHandle(H aHandle) {
        return this._handleToJobDescriptors.containsKey(aHandle);
    }

    public Undoable<CTX, ?, ?> lookupHandle(H aHandle) throws UnknownHandleRuntimeException {
        JobDescriptor<?> theJobDescriptor = this._handleToJobDescriptors.get(aHandle);
        if (theJobDescriptor == null) {
            throw new UnknownHandleRuntimeException(aHandle, "The given handle is not known by this job-bus.");
        }
        return theJobDescriptor.getJob();
    }

    public Undoable<CTX, ?, ?> removeHandle(H aHandle) throws UnknownHandleRuntimeException {
        JobDescriptor<?> theJobDescriptor = this._handleToJobDescriptors.remove(aHandle);
        if (theJobDescriptor == null) {
            throw new UnknownHandleRuntimeException(aHandle, "The given handle is not known by this job-bus.");
        }
        return theJobDescriptor.getJob();
    }

    public boolean hasProgress(H aHandle) throws UnknownHandleRuntimeException {
        Undoable<CTX, ?, ?> theJob = this.getJob(aHandle);
        return theJob instanceof ProgressAccessor;
    }

    public float getProgress(H aHandle) throws UnsupportedHandleOperationRuntimeException, UnknownHandleRuntimeException {
        Undoable<CTX, ?, ?> theJob = this.getJob(aHandle);
        if (!(theJob instanceof ProgressAccessor)) {
            throw new UnsupportedHandleOperationRuntimeException(aHandle, "The operation is not known by the job referenced by the given handle.");
        }
        return ((ProgressAccessor)theJob).getProgress();
    }

    public boolean hasReset(H aHandle) throws UnknownHandleRuntimeException {
        Undoable<CTX, ?, ?> theJob = this.getJob(aHandle);
        return theJob instanceof Resetable;
    }

    public void reset(H aHandle) throws UnknownHandleRuntimeException, UnsupportedHandleOperationRuntimeException {
        Undoable<CTX, ?, ?> theJob = this.getJob(aHandle);
        if (!(theJob instanceof Resetable)) {
            throw new UnsupportedHandleOperationRuntimeException(aHandle, "The operation is not known by the job referenced by the given handle.");
        }
        ((Resetable)theJob).reset();
    }

    public boolean hasFlush(H aHandle) throws UnknownHandleRuntimeException {
        Undoable<CTX, ?, ?> theJob = this.getJob(aHandle);
        return theJob instanceof Flushable;
    }

    public void flush(H aHandle) throws OpenException, UnknownHandleRuntimeException, UnsupportedHandleOperationRuntimeException {
        Undoable<CTX, ?, ?> theJob = this.getJob(aHandle);
        if (!(theJob instanceof Flushable)) {
            throw new UnsupportedHandleOperationRuntimeException(aHandle, "The operation is not known by the job referenced by the given handle.");
        }
        ((Flushable)theJob).flush();
    }

    protected Collection<Undoable<CTX, ?, ?>> handleReferences() {
        ArrayList theJobList = new ArrayList();
        Collection<JobDescriptor<?>> theJobDescriptorCollection = this._handleToJobDescriptors.values();
        for (JobDescriptor<?> eJobDescriptor : theJobDescriptorCollection) {
            theJobList.add(eJobDescriptor.getJob());
        }
        return theJobList;
    }

    protected Set<H> handles() {
        return new HashSet<H>(this._handleToJobDescriptors.keySet());
    }

    protected Undoable<CTX, ?, ?> getJob(H aHandle) throws UnknownHandleRuntimeException {
        JobDescriptor<?> theJobDescriptor = this._handleToJobDescriptors.get(aHandle);
        if (theJobDescriptor == null) {
            throw new UnknownHandleRuntimeException(aHandle, "The given handle is not known by this job-bus.");
        }
        return theJobDescriptor.getJob();
    }

    private <JOB extends Undoable<CTX, RET, ?>, RET> JobDescriptor<RET> start(final JOB aJob, final H aHandle) {
        final JobDescriptor theJobDescriptor = new JobDescriptor(aJob);
        this._handleToJobDescriptors.put(aHandle, theJobDescriptor);
        Runnable theJobRunnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    theJobDescriptor.setResult(aJob.execute(AbstractJobBus.this._context));
                }
                catch (Exception e) {
                    theJobDescriptor.setException(e);
                }
                theJobDescriptor.setExecuted(true);
                Object object = aHandle;
                synchronized (object) {
                    aHandle.notifyAll();
                }
            }
        };
        this._executorService.execute(theJobRunnable);
        return theJobDescriptor;
    }

    private <E extends Exception, JOB extends Undoable<CTX, RET, E>, RET> void invoke(final Undoable<CTX, RET, E> aJob, final BiConsumer<RET, E> aResultConsumer) {
        Runnable theJobRunnable = new Runnable(){

            @Override
            public void run() {
                try {
                    aResultConsumer.accept(aJob.execute(AbstractJobBus.this._context), null);
                }
                catch (Exception e) {
                    aResultConsumer.accept(null, e);
                }
            }
        };
        this._executorService.execute(theJobRunnable);
    }

    private <E extends Exception, JOB extends Undoable<CTX, RET, E>, RET> void invoke(final Undoable<CTX, RET, E> aJob, final Consumer<RET> aResultConsumer) {
        Runnable theJobRunnable = new Runnable(){

            @Override
            public void run() {
                try {
                    aResultConsumer.accept(aJob.execute(AbstractJobBus.this._context));
                }
                catch (Exception e) {
                    LOGGER.info("Ingmoring uncaught exception " + ExceptionUtility.toMessage((Throwable)e), new Object[]{e});
                }
            }
        };
        this._executorService.execute(theJobRunnable);
    }

    private class JobDescriptor<RET> {
        private Undoable<CTX, RET, ?> _job;
        private RET _result = null;
        private Exception _exception = null;
        private boolean _isExecuted = false;
        private ExecutionStatus _executionStatus = ExecutionStatus.VOID;

        public JobDescriptor(Undoable<CTX, RET, ?> aJob) {
            assert (aJob != null);
            this._job = aJob;
        }

        public Undoable<CTX, RET, ?> getJob() {
            return this._job;
        }

        public void setResult(RET aResult) {
            this._result = aResult;
            this._executionStatus = ExecutionStatus.RESULT;
        }

        public RET getResult() {
            return this._result;
        }

        public ExecutionStatus getExecutionStatus() {
            return this._executionStatus;
        }

        public void setException(Exception e) {
            this._exception = e;
            this._executionStatus = ExecutionStatus.EXCEPTION;
        }

        public Exception getException() {
            return this._exception;
        }

        public boolean isExecuted() {
            return this._isExecuted;
        }

        public void setExecuted(boolean isExecuted) {
            this._isExecuted = isExecuted;
        }
    }

    private static enum ExecutionStatus {
        VOID,
        RESULT,
        EXCEPTION;

    }
}

