/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.jobbus;

import java.util.concurrent.ExecutorService;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.refcodes.command.NoExceptionAvailableRuntimeException;
import org.refcodes.command.NoResultAvailableRuntimeException;
import org.refcodes.command.NotYetExecutedRuntimeException;
import org.refcodes.command.Undoable;
import org.refcodes.component.HandleTimeoutRuntimeException;
import org.refcodes.component.OpenException;
import org.refcodes.component.UnknownHandleRuntimeException;
import org.refcodes.component.UnsupportedHandleOperationRuntimeException;
import org.refcodes.controlflow.ControlFlowUtility;
import org.refcodes.controlflow.RetryTimeoutImpl;
import org.refcodes.data.LoopSleepTime;
import org.refcodes.data.RetryLoopCount;
import org.refcodes.exception.ExceptionUtility;
import org.refcodes.exception.HiddenException;
import org.refcodes.jobbus.JobBus;
import org.refcodes.logger.RuntimeLogger;
import org.refcodes.logger.RuntimeLoggerFactorySingleton;

public class JobBusProxyImpl<CTX, H>
implements JobBus<CTX, H> {
    private static RuntimeLogger LOGGER = RuntimeLoggerFactorySingleton.createRuntimeLogger();
    private JobBus<CTX, H> _jobBus;
    private ExecutorService _executorService;

    public JobBusProxyImpl(JobBus<CTX, H> aJobBus) {
        this(aJobBus, null);
    }

    public JobBusProxyImpl(JobBus<CTX, H> aJobBus, ExecutorService aExecutorService) {
        this._jobBus = aJobBus;
        this._executorService = aExecutorService == null ? ControlFlowUtility.createCachedExecutorService((boolean)true) : ControlFlowUtility.toManagedExecutorService((ExecutorService)aExecutorService);
    }

    public boolean hasHandle(H aHandle) {
        return this._jobBus.hasHandle(aHandle);
    }

    public boolean hasProgress(H aHandle) throws UnknownHandleRuntimeException {
        return this._jobBus.hasProgress(aHandle);
    }

    public boolean hasReset(H aHandle) throws UnknownHandleRuntimeException {
        return this._jobBus.hasReset(aHandle);
    }

    public boolean hasFlush(H aHandle) throws UnknownHandleRuntimeException {
        return this._jobBus.hasFlush(aHandle);
    }

    public Undoable<CTX, ?, ?> lookupHandle(H aHandle) throws UnknownHandleRuntimeException {
        return (Undoable)this._jobBus.lookupHandle(aHandle);
    }

    public Undoable<CTX, ?, ?> removeHandle(H aHandle) throws UnknownHandleRuntimeException {
        return (Undoable)this._jobBus.removeHandle(aHandle);
    }

    public void reset(H aHandle) throws UnknownHandleRuntimeException, UnsupportedHandleOperationRuntimeException {
        this._jobBus.reset(aHandle);
    }

    public float getProgress(H aHandle) throws UnsupportedHandleOperationRuntimeException, UnknownHandleRuntimeException {
        return this._jobBus.getProgress(aHandle);
    }

    public void flush(H aHandle) throws OpenException, UnknownHandleRuntimeException, UnsupportedHandleOperationRuntimeException {
        this._jobBus.flush(aHandle);
    }

    @Override
    public H execute(Undoable<CTX, ?, ?> aJob) {
        return this._jobBus.execute(aJob);
    }

    @Override
    public boolean isExecuted(H aHandle) throws UnknownHandleRuntimeException {
        return this._jobBus.isExecuted(aHandle);
    }

    @Override
    public boolean hasResult(H aHandle) throws UnknownHandleRuntimeException, NotYetExecutedRuntimeException {
        return this._jobBus.hasResult(aHandle);
    }

    @Override
    public boolean hasException(H aHandle) throws UnknownHandleRuntimeException, NotYetExecutedRuntimeException {
        return this._jobBus.hasException(aHandle);
    }

    @Override
    public <RET> RET getResult(H aHandle) throws UnknownHandleRuntimeException, NotYetExecutedRuntimeException, NoResultAvailableRuntimeException {
        return this._jobBus.getResult(aHandle);
    }

    @Override
    public <E extends Exception> E getException(H aHandle) throws UnknownHandleRuntimeException, NotYetExecutedRuntimeException, NoExceptionAvailableRuntimeException {
        return this._jobBus.getException(aHandle);
    }

    @Override
    public <RET, E extends Exception> void execute(Undoable<CTX, RET, E> aJob, final Consumer<RET> aResultConsumer) {
        final H theHandle = this._jobBus.execute(aJob);
        Runnable theLambdaRunnable = new Runnable(){

            @Override
            public void run() {
                JobBusProxyImpl.this.waitForExecution(theHandle);
                try {
                    aResultConsumer.accept(JobBusProxyImpl.this.getResult(theHandle));
                }
                catch (NoResultAvailableRuntimeException | NotYetExecutedRuntimeException | UnknownHandleRuntimeException e) {
                    LOGGER.warn(ExceptionUtility.toMessage((Throwable)e), e);
                }
            }
        };
        this._executorService.execute(theLambdaRunnable);
    }

    @Override
    public <RET, E extends Exception> void execute(Undoable<CTX, RET, E> aJob, final BiConsumer<RET, E> aResultConsumer) {
        final H theHandle = this._jobBus.execute(aJob);
        Runnable theLambdaRunnable = new Runnable(){

            @Override
            public void run() {
                JobBusProxyImpl.this.waitForExecution(theHandle);
                try {
                    try {
                        aResultConsumer.accept(JobBusProxyImpl.this.getResult(theHandle), null);
                    }
                    catch (NoResultAvailableRuntimeException e) {
                        aResultConsumer.accept(null, JobBusProxyImpl.this.getException(theHandle));
                    }
                }
                catch (NoExceptionAvailableRuntimeException | NotYetExecutedRuntimeException | UnknownHandleRuntimeException e) {
                    LOGGER.warn(ExceptionUtility.toMessage((Throwable)e), e);
                }
            }
        };
        this._executorService.execute(theLambdaRunnable);
    }

    @Override
    public void waitForExecution(H aHandle) throws UnknownHandleRuntimeException {
        while (!this._jobBus.isExecuted(aHandle)) {
            try {
                Thread.sleep(LoopSleepTime.NORM.getMillis());
            }
            catch (InterruptedException e) {
                break;
            }
        }
    }

    @Override
    public void waitForExecution(H aHandle, long aTimeoutInMs) throws UnknownHandleRuntimeException, HandleTimeoutRuntimeException {
        RetryTimeoutImpl theRetryTimeout = new RetryTimeoutImpl(aTimeoutInMs, RetryLoopCount.NORM_NUM_RETRY_LOOPS.getValue().intValue());
        while (!this._jobBus.isExecuted(aHandle) && theRetryTimeout.hasNextRetry()) {
            theRetryTimeout.nextRetry();
        }
        if (!this.isExecuted(aHandle)) {
            throw new HandleTimeoutRuntimeException(aHandle, "Execution of the command referenced by the given handle did not terminate in the given amount of <" + aTimeoutInMs + "> ms, aborting wait loop.");
        }
    }

    @Override
    public <JOB extends Undoable<CTX, RET, ?>, RET> RET getResult(JOB aJob) throws NoResultAvailableRuntimeException {
        H theHandle = this.execute(aJob);
        this.waitForExecution(theHandle);
        try {
            return this._jobBus.getResult(theHandle);
        }
        catch (NotYetExecutedRuntimeException | UnknownHandleRuntimeException e) {
            throw new HiddenException(e);
        }
    }

    @Override
    public <JOB extends Undoable<CTX, RET, ?>, RET> RET getResult(JOB aJob, long aTimeoutInMs) throws NoResultAvailableRuntimeException, HandleTimeoutRuntimeException {
        H theHandle = this.execute(aJob);
        this.waitForExecution(theHandle, aTimeoutInMs);
        try {
            return this._jobBus.getResult(theHandle);
        }
        catch (NotYetExecutedRuntimeException | UnknownHandleRuntimeException e) {
            throw new HiddenException(e);
        }
    }
}

