/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.jobbus;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ExecutorService;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.refcodes.command.NoExceptionAvailableRuntimeException;
import org.refcodes.command.NoResultAvailableRuntimeException;
import org.refcodes.command.NotYetExecutedRuntimeException;
import org.refcodes.command.Undoable;
import org.refcodes.component.Flushable;
import org.refcodes.component.HandleGenerator;
import org.refcodes.component.HandleTimeoutRuntimeException;
import org.refcodes.component.ProgressAccessor;
import org.refcodes.component.Resetable;
import org.refcodes.component.UnknownHandleRuntimeException;
import org.refcodes.component.UnsupportedHandleOperationRuntimeException;
import org.refcodes.controlflow.ControlFlowUtility;
import org.refcodes.controlflow.RetryTimeout;
import org.refcodes.data.RetryLoopCount;
import org.refcodes.data.SleepLoopTime;
import org.refcodes.exception.ExceptionUtility;
import org.refcodes.jobbus.JobBus;
import org.refcodes.logger.RuntimeLogger;
import org.refcodes.logger.RuntimeLoggerFactorySingleton;

public abstract class AbstractJobBus<CTX, H>
implements JobBus<CTX, H> {
    private static RuntimeLogger LOGGER = RuntimeLoggerFactorySingleton.createRuntimeLogger();
    private final Map<H, JobDescriptor<?>> _handleToJobDescriptors = new WeakHashMap();
    private HandleGenerator<H> _handleGenerator;
    private final CTX _context;
    private ExecutorService _executorService;

    public AbstractJobBus(CTX CTX, HandleGenerator<H> handleGenerator) {
        this(CTX, handleGenerator, null);
    }

    public AbstractJobBus(CTX CTX, HandleGenerator<H> handleGenerator, ExecutorService executorService) {
        assert (handleGenerator != null);
        assert (CTX != null);
        this._handleGenerator = handleGenerator;
        this._context = CTX;
        this._executorService = executorService == null ? ControlFlowUtility.createCachedExecutorService((boolean)true) : ControlFlowUtility.toManagedExecutorService((ExecutorService)executorService);
    }

    @Override
    public H execute(Undoable<CTX, ?, ?> undoable) {
        assert (undoable != null);
        Object object = this._handleGenerator.next();
        this.start(undoable, object);
        return (H)object;
    }

    @Override
    public <RET, E extends Exception> void execute(Undoable<CTX, RET, E> undoable, BiConsumer<RET, E> biConsumer) {
        assert (undoable != null);
        assert (biConsumer != null);
        this.invoke(undoable, biConsumer);
    }

    @Override
    public <RET, E extends Exception> void execute(Undoable<CTX, RET, E> undoable, Consumer<RET> consumer) {
        assert (undoable != null);
        assert (consumer != null);
        this.invoke(undoable, consumer);
    }

    @Override
    public <E extends Exception> E getException(H h) throws UnknownHandleRuntimeException, NotYetExecutedRuntimeException, NoExceptionAvailableRuntimeException {
        JobDescriptor<?> jobDescriptor = this._handleToJobDescriptors.get(h);
        if (jobDescriptor == null) {
            throw new UnknownHandleRuntimeException(h, "The given handle is not known by this job-bus.");
        }
        if (!jobDescriptor.isExecuted()) {
            throw new NotYetExecutedRuntimeException(jobDescriptor.getJob(), "The given job has not finished execution yet.");
        }
        if (jobDescriptor.getException() == null) {
            throw new NoExceptionAvailableRuntimeException(jobDescriptor.getJob(), "The given job has no execption.");
        }
        return (E)jobDescriptor.getException();
    }

    @Override
    public <RET> RET getResult(H h) throws UnknownHandleRuntimeException, NotYetExecutedRuntimeException, NoResultAvailableRuntimeException {
        JobDescriptor<?> jobDescriptor = this._handleToJobDescriptors.get(h);
        if (jobDescriptor == null) {
            throw new UnknownHandleRuntimeException(h, "The given handle is not known by this job-bus.");
        }
        if (!jobDescriptor.isExecuted()) {
            throw new NotYetExecutedRuntimeException(jobDescriptor.getJob(), "The given job has not finished execution yet.");
        }
        if (jobDescriptor.getExecutionStatus() != ExecutionStatus.RESULT) {
            throw new NoResultAvailableRuntimeException(jobDescriptor.getJob(), "The given job has no execption.");
        }
        return (RET)jobDescriptor.getResult();
    }

    @Override
    public boolean hasException(H h) throws UnknownHandleRuntimeException, NotYetExecutedRuntimeException {
        JobDescriptor<?> jobDescriptor = this._handleToJobDescriptors.get(h);
        if (jobDescriptor == null) {
            throw new UnknownHandleRuntimeException(h, "The given handle is not known by this job-bus.");
        }
        if (!jobDescriptor.isExecuted()) {
            throw new NotYetExecutedRuntimeException(jobDescriptor.getJob(), "The given job has not finished execution yet.");
        }
        return jobDescriptor.getException() != null;
    }

    @Override
    public boolean hasResult(H h) throws UnknownHandleRuntimeException, NotYetExecutedRuntimeException {
        JobDescriptor<?> jobDescriptor = this._handleToJobDescriptors.get(h);
        if (jobDescriptor == null) {
            throw new UnknownHandleRuntimeException(h, "The given handle is not known by this job-bus.");
        }
        if (!jobDescriptor.isExecuted()) {
            throw new NotYetExecutedRuntimeException(jobDescriptor.getJob(), "The given job has not finished execution yet.");
        }
        return jobDescriptor.getExecutionStatus() == ExecutionStatus.RESULT;
    }

    @Override
    public boolean isExecuted(H h) throws UnknownHandleRuntimeException {
        JobDescriptor<?> jobDescriptor = this._handleToJobDescriptors.get(h);
        if (jobDescriptor == null) {
            throw new UnknownHandleRuntimeException(h, "The given handle is not known by this job-bus.");
        }
        return jobDescriptor.isExecuted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void waitForExecution(H h) throws UnknownHandleRuntimeException {
        if (!this.hasHandle(h)) {
            throw new UnknownHandleRuntimeException(h, "The given handle is not known by this job-bus.");
        }
        try {
            while (!this.isExecuted(h)) {
                H h2 = h;
                synchronized (h2) {
                    h.wait(SleepLoopTime.MIN.getTimeInMs());
                }
            }
            return;
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void waitForExecution(H h, long l) throws UnknownHandleRuntimeException, HandleTimeoutRuntimeException {
        if (!this.hasHandle(h)) {
            throw new UnknownHandleRuntimeException(h, "The given handle is not known by this job-bus.");
        }
        RetryTimeout retryTimeout = new RetryTimeout(l, RetryLoopCount.NORM_NUM_RETRY_LOOPS.getValue().intValue());
        while (!this.isExecuted(h) && retryTimeout.hasNextRetry()) {
            retryTimeout.nextRetry(h);
        }
        if (!this.isExecuted(h)) {
            throw new HandleTimeoutRuntimeException(h, "Execution of the command referenced by the given handle did not terminate in the given amount of <" + l + "> ms, aborting wait loop.");
        }
    }

    @Override
    public <JOB extends Undoable<CTX, RET, ?>, RET> RET getResult(JOB JOB) throws NoResultAvailableRuntimeException {
        Object object = this._handleGenerator.next();
        JobDescriptor<RET> jobDescriptor = this.start(JOB, object);
        if (jobDescriptor == null) {
            throw new IllegalStateException("The job bis encountered an illegal state as a just created handle for executing a job is not konwn by the job-bus any more.");
        }
        this.waitForExecution(object);
        if (jobDescriptor.getExecutionStatus() == ExecutionStatus.EXCEPTION) {
            throw new NoResultAvailableRuntimeException(jobDescriptor.getJob(), "No result available, the job terminated with an exception!", (Throwable)jobDescriptor.getException());
        }
        if (jobDescriptor.getExecutionStatus() == ExecutionStatus.RESULT) {
            return jobDescriptor.getResult();
        }
        throw new NoResultAvailableRuntimeException(JOB, "The job for which a result is excpected does not deliver a result, it is a \"void\" job.");
    }

    @Override
    public <JOB extends Undoable<CTX, RET, ?>, RET> RET getResult(JOB JOB, long l) throws NoResultAvailableRuntimeException, HandleTimeoutRuntimeException {
        Object object = this._handleGenerator.next();
        JobDescriptor<RET> jobDescriptor = this.start(JOB, object);
        if (jobDescriptor == null) {
            throw new IllegalStateException("The job bis encountered an illegal state as a just created handle for executing a job is not konwn by the job-bus any more.");
        }
        this.waitForExecution(object, l);
        if (jobDescriptor.getExecutionStatus() == ExecutionStatus.EXCEPTION) {
            throw new NoResultAvailableRuntimeException(jobDescriptor.getJob(), "No result available, the job terminated with an exception!", (Throwable)jobDescriptor.getException());
        }
        if (jobDescriptor.getExecutionStatus() == ExecutionStatus.RESULT) {
            return jobDescriptor.getResult();
        }
        throw new NoResultAvailableRuntimeException(JOB, "The job for which a result is excpected does not deliver a result, it is a \"void\" job.");
    }

    public boolean hasHandle(H h) {
        return this._handleToJobDescriptors.containsKey(h);
    }

    public Undoable<CTX, ?, ?> lookupHandle(H h) throws UnknownHandleRuntimeException {
        JobDescriptor<?> jobDescriptor = this._handleToJobDescriptors.get(h);
        if (jobDescriptor == null) {
            throw new UnknownHandleRuntimeException(h, "The given handle is not known by this job-bus.");
        }
        return jobDescriptor.getJob();
    }

    public Undoable<CTX, ?, ?> removeHandle(H h) throws UnknownHandleRuntimeException {
        JobDescriptor<?> jobDescriptor = this._handleToJobDescriptors.remove(h);
        if (jobDescriptor == null) {
            throw new UnknownHandleRuntimeException(h, "The given handle is not known by this job-bus.");
        }
        return jobDescriptor.getJob();
    }

    public boolean hasProgress(H h) throws UnknownHandleRuntimeException {
        Undoable<CTX, ?, ?> undoable = this.getJob(h);
        return undoable instanceof ProgressAccessor;
    }

    public float getProgress(H h) throws UnsupportedHandleOperationRuntimeException, UnknownHandleRuntimeException {
        Undoable<CTX, ?, ?> undoable = this.getJob(h);
        if (!(undoable instanceof ProgressAccessor)) {
            throw new UnsupportedHandleOperationRuntimeException(h, "The operation is not known by the job referenced by the given handle.");
        }
        return ((ProgressAccessor)undoable).getProgress();
    }

    public boolean hasReset(H h) throws UnknownHandleRuntimeException {
        Undoable<CTX, ?, ?> undoable = this.getJob(h);
        return undoable instanceof Resetable;
    }

    public void reset(H h) throws UnknownHandleRuntimeException, UnsupportedHandleOperationRuntimeException {
        Undoable<CTX, ?, ?> undoable = this.getJob(h);
        if (!(undoable instanceof Resetable)) {
            throw new UnsupportedHandleOperationRuntimeException(h, "The operation is not known by the job referenced by the given handle.");
        }
        ((Resetable)undoable).reset();
    }

    public boolean hasFlush(H h) throws UnknownHandleRuntimeException {
        Undoable<CTX, ?, ?> undoable = this.getJob(h);
        return undoable instanceof Flushable;
    }

    public void flush(H h) throws IOException, UnknownHandleRuntimeException, UnsupportedHandleOperationRuntimeException {
        Undoable<CTX, ?, ?> undoable = this.getJob(h);
        if (!(undoable instanceof Flushable)) {
            throw new UnsupportedHandleOperationRuntimeException(h, "The operation is not known by the job referenced by the given handle.");
        }
        ((Flushable)undoable).flush();
    }

    protected Collection<Undoable<CTX, ?, ?>> handleReferences() {
        ArrayList arrayList = new ArrayList();
        Collection<JobDescriptor<?>> collection = this._handleToJobDescriptors.values();
        for (JobDescriptor<?> jobDescriptor : collection) {
            arrayList.add(jobDescriptor.getJob());
        }
        return arrayList;
    }

    protected Set<H> handles() {
        return new HashSet<H>(this._handleToJobDescriptors.keySet());
    }

    protected Undoable<CTX, ?, ?> getJob(H h) throws UnknownHandleRuntimeException {
        JobDescriptor<?> jobDescriptor = this._handleToJobDescriptors.get(h);
        if (jobDescriptor == null) {
            throw new UnknownHandleRuntimeException(h, "The given handle is not known by this job-bus.");
        }
        return jobDescriptor.getJob();
    }

    private <JOB extends Undoable<CTX, RET, ?>, RET> JobDescriptor<RET> start(final JOB JOB, final H h) {
        final JobDescriptor jobDescriptor = new JobDescriptor(JOB);
        this._handleToJobDescriptors.put(h, jobDescriptor);
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    jobDescriptor.setResult(JOB.execute(AbstractJobBus.this._context));
                }
                catch (Exception exception) {
                    jobDescriptor.setException(exception);
                }
                jobDescriptor.setExecuted(true);
                Object object = h;
                synchronized (object) {
                    h.notifyAll();
                }
            }
        };
        this._executorService.execute(runnable);
        return jobDescriptor;
    }

    private <E extends Exception, JOB extends Undoable<CTX, RET, E>, RET> void invoke(final Undoable<CTX, RET, E> undoable, final BiConsumer<RET, E> biConsumer) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    biConsumer.accept(undoable.execute(AbstractJobBus.this._context), null);
                }
                catch (Exception exception) {
                    biConsumer.accept(null, exception);
                }
            }
        };
        this._executorService.execute(runnable);
    }

    private <E extends Exception, JOB extends Undoable<CTX, RET, E>, RET> void invoke(final Undoable<CTX, RET, E> undoable, final Consumer<RET> consumer) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    consumer.accept(undoable.execute(AbstractJobBus.this._context));
                }
                catch (Exception exception) {
                    LOGGER.info("Ingmoring uncaught exception " + ExceptionUtility.toMessage((Throwable)exception), new Object[]{exception});
                }
            }
        };
        this._executorService.execute(runnable);
    }

    private class JobDescriptor<RET> {
        private Undoable<CTX, RET, ?> _job;
        private RET _result = null;
        private Exception _exception = null;
        private boolean _isExecuted = false;
        private ExecutionStatus _executionStatus = ExecutionStatus.VOID;

        public JobDescriptor(Undoable<CTX, RET, ?> undoable) {
            assert (undoable != null);
            this._job = undoable;
        }

        public Undoable<CTX, RET, ?> getJob() {
            return this._job;
        }

        public void setResult(RET RET) {
            this._result = RET;
            this._executionStatus = ExecutionStatus.RESULT;
        }

        public RET getResult() {
            return this._result;
        }

        public ExecutionStatus getExecutionStatus() {
            return this._executionStatus;
        }

        public void setException(Exception exception) {
            this._exception = exception;
            this._executionStatus = ExecutionStatus.EXCEPTION;
        }

        public Exception getException() {
            return this._exception;
        }

        public boolean isExecuted() {
            return this._isExecuted;
        }

        public void setExecuted(boolean bl) {
            this._isExecuted = bl;
        }
    }

    private static enum ExecutionStatus {
        VOID,
        RESULT,
        EXCEPTION;

    }
}

