/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.jobbus;

import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.refcodes.command.NoExceptionAvailableRuntimeException;
import org.refcodes.command.NoResultAvailableRuntimeException;
import org.refcodes.command.NotYetExecutedRuntimeException;
import org.refcodes.command.Undoable;
import org.refcodes.component.HandleTimeoutRuntimeException;
import org.refcodes.component.UnknownHandleRuntimeException;
import org.refcodes.component.UnsupportedHandleOperationRuntimeException;
import org.refcodes.controlflow.ControlFlowUtility;
import org.refcodes.controlflow.RetryTimeout;
import org.refcodes.data.RetryLoopCount;
import org.refcodes.data.SleepLoopTime;
import org.refcodes.exception.ExceptionUtility;
import org.refcodes.exception.HiddenException;
import org.refcodes.jobbus.JobBus;
import org.refcodes.logger.RuntimeLogger;
import org.refcodes.logger.RuntimeLoggerFactorySingleton;

public class JobBusProxy<CTX, H>
implements JobBus<CTX, H> {
    private static RuntimeLogger LOGGER = RuntimeLoggerFactorySingleton.createRuntimeLogger();
    private JobBus<CTX, H> _jobBus;
    private ExecutorService _executorService;

    public JobBusProxy(JobBus<CTX, H> jobBus) {
        this(jobBus, null);
    }

    public JobBusProxy(JobBus<CTX, H> jobBus, ExecutorService executorService) {
        this._jobBus = jobBus;
        this._executorService = executorService == null ? ControlFlowUtility.createCachedExecutorService((boolean)true) : ControlFlowUtility.toManagedExecutorService((ExecutorService)executorService);
    }

    public boolean hasHandle(H h) {
        return this._jobBus.hasHandle(h);
    }

    public boolean hasProgress(H h) throws UnknownHandleRuntimeException {
        return this._jobBus.hasProgress(h);
    }

    public boolean hasReset(H h) throws UnknownHandleRuntimeException {
        return this._jobBus.hasReset(h);
    }

    public boolean hasFlush(H h) throws UnknownHandleRuntimeException {
        return this._jobBus.hasFlush(h);
    }

    public Undoable<CTX, ?, ?> lookupHandle(H h) throws UnknownHandleRuntimeException {
        return (Undoable)this._jobBus.lookupHandle(h);
    }

    public Undoable<CTX, ?, ?> removeHandle(H h) throws UnknownHandleRuntimeException {
        return (Undoable)this._jobBus.removeHandle(h);
    }

    public void reset(H h) throws UnknownHandleRuntimeException, UnsupportedHandleOperationRuntimeException {
        this._jobBus.reset(h);
    }

    public float getProgress(H h) throws UnsupportedHandleOperationRuntimeException, UnknownHandleRuntimeException {
        return this._jobBus.getProgress(h);
    }

    public void flush(H h) throws IOException, UnknownHandleRuntimeException, UnsupportedHandleOperationRuntimeException {
        this._jobBus.flush(h);
    }

    @Override
    public H execute(Undoable<CTX, ?, ?> undoable) {
        return this._jobBus.execute(undoable);
    }

    @Override
    public boolean isExecuted(H h) throws UnknownHandleRuntimeException {
        return this._jobBus.isExecuted(h);
    }

    @Override
    public boolean hasResult(H h) throws UnknownHandleRuntimeException, NotYetExecutedRuntimeException {
        return this._jobBus.hasResult(h);
    }

    @Override
    public boolean hasException(H h) throws UnknownHandleRuntimeException, NotYetExecutedRuntimeException {
        return this._jobBus.hasException(h);
    }

    @Override
    public <RET> RET getResult(H h) throws UnknownHandleRuntimeException, NotYetExecutedRuntimeException, NoResultAvailableRuntimeException {
        return this._jobBus.getResult(h);
    }

    @Override
    public <E extends Exception> E getException(H h) throws UnknownHandleRuntimeException, NotYetExecutedRuntimeException, NoExceptionAvailableRuntimeException {
        return this._jobBus.getException(h);
    }

    @Override
    public <RET, E extends Exception> void execute(Undoable<CTX, RET, E> undoable, final Consumer<RET> consumer) {
        final H h = this._jobBus.execute(undoable);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                JobBusProxy.this.waitForExecution(h);
                try {
                    consumer.accept(JobBusProxy.this.getResult(h));
                }
                catch (NoResultAvailableRuntimeException | NotYetExecutedRuntimeException | UnknownHandleRuntimeException throwable) {
                    LOGGER.warn(ExceptionUtility.toMessage((Throwable)throwable), throwable);
                }
            }
        };
        this._executorService.execute(runnable);
    }

    @Override
    public <RET, E extends Exception> void execute(Undoable<CTX, RET, E> undoable, final BiConsumer<RET, E> biConsumer) {
        final H h = this._jobBus.execute(undoable);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                JobBusProxy.this.waitForExecution(h);
                try {
                    try {
                        biConsumer.accept(JobBusProxy.this.getResult(h), null);
                    }
                    catch (NoResultAvailableRuntimeException noResultAvailableRuntimeException) {
                        biConsumer.accept(null, JobBusProxy.this.getException(h));
                    }
                }
                catch (NoExceptionAvailableRuntimeException | NotYetExecutedRuntimeException | UnknownHandleRuntimeException throwable) {
                    LOGGER.warn(ExceptionUtility.toMessage((Throwable)throwable), throwable);
                }
            }
        };
        this._executorService.execute(runnable);
    }

    @Override
    public void waitForExecution(H h) throws UnknownHandleRuntimeException {
        while (!this._jobBus.isExecuted(h)) {
            try {
                Thread.sleep(SleepLoopTime.NORM.getTimeInMs());
            }
            catch (InterruptedException interruptedException) {
                break;
            }
        }
    }

    @Override
    public void waitForExecution(H h, long l) throws UnknownHandleRuntimeException, HandleTimeoutRuntimeException {
        RetryTimeout retryTimeout = new RetryTimeout(l, RetryLoopCount.NORM_NUM_RETRY_LOOPS.getValue().intValue());
        while (!this._jobBus.isExecuted(h) && retryTimeout.hasNextRetry()) {
            retryTimeout.nextRetry();
        }
        if (!this.isExecuted(h)) {
            throw new HandleTimeoutRuntimeException(h, "Execution of the command referenced by the given handle did not terminate in the given amount of <" + l + "> ms, aborting wait loop.");
        }
    }

    @Override
    public <JOB extends Undoable<CTX, RET, ?>, RET> RET getResult(JOB JOB) throws NoResultAvailableRuntimeException {
        H h = this.execute(JOB);
        this.waitForExecution(h);
        try {
            return this._jobBus.getResult(h);
        }
        catch (NotYetExecutedRuntimeException | UnknownHandleRuntimeException throwable) {
            throw new HiddenException(throwable);
        }
    }

    @Override
    public <JOB extends Undoable<CTX, RET, ?>, RET> RET getResult(JOB JOB, long l) throws NoResultAvailableRuntimeException, HandleTimeoutRuntimeException {
        H h = this.execute(JOB);
        this.waitForExecution(h, l);
        try {
            return this._jobBus.getResult(h);
        }
        catch (NotYetExecutedRuntimeException | UnknownHandleRuntimeException throwable) {
            throw new HiddenException(throwable);
        }
    }
}

