/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.jobbus;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.refcodes.command.AbstractUndoable;
import org.refcodes.command.NoResultAvailableRuntimeException;
import org.refcodes.command.Undoable;
import org.refcodes.component.HandleTimeoutRuntimeException;
import org.refcodes.jobbus.JobBus;
import org.refcodes.jobbus.JobBusProxy;
import org.refcodes.jobbus.SimpleJobBus;

public class JobBusProxyImplTest {
    private static boolean IS_LOG_TESTS = Boolean.getBoolean("log.tests");
    private static final String APPEND_TEXT = "123456789101112131415161718192021222324252627282930313233343536373839404142434445464748495051525354555657585960616263646566676869707172737475767778798081828384858687888990919293949596979899100";
    private static final String DONE = "Done!";
    private List<Integer> _context = new ArrayList<Integer>();
    private JobBus<List<Integer>, String> _jobBus;
    private int _ret;

    @BeforeEach
    public void setUp() {
        this._jobBus = new JobBusProxy((JobBus)new SimpleJobBus(this._context));
        for (int i = 1; i <= 100; ++i) {
            this._context.add(i);
        }
    }

    @Test
    public void testGetResult() throws NoResultAvailableRuntimeException, Exception {
        SumCommand sumCommand = new SumCommand();
        MulCommand mulCommand = new MulCommand();
        AppendCommand appendCommand = new AppendCommand();
        int n = (Integer)this._jobBus.getResult((Undoable)sumCommand);
        if (IS_LOG_TESTS) {
            System.out.println("" + n);
        }
        Double d = (Double)this._jobBus.getResult((Undoable)mulCommand);
        if (IS_LOG_TESTS) {
            System.out.println("" + d);
        }
        String string = (String)this._jobBus.getResult((Undoable)appendCommand);
        if (IS_LOG_TESTS) {
            System.out.println(string);
        }
        Assertions.assertEquals((int)5050, (int)n);
        Assertions.assertEquals((Object)"9.33262154439441E157", (Object)d.toString());
        Assertions.assertEquals((Object)APPEND_TEXT, (Object)string);
    }

    @Test
    public void testExecute() throws NoResultAvailableRuntimeException, Exception {
        SumCommand sumCommand = new SumCommand();
        MulCommand mulCommand = new MulCommand();
        AppendCommand appendCommand = new AppendCommand();
        String string = (String)this._jobBus.execute((Undoable)sumCommand);
        String string2 = (String)this._jobBus.execute((Undoable)mulCommand);
        String string3 = (String)this._jobBus.execute((Undoable)appendCommand);
        this._jobBus.waitForExecution((Object)string);
        int n = (Integer)this._jobBus.getResult((Object)string);
        this._jobBus.waitForExecution((Object)string2);
        Double d = (Double)this._jobBus.getResult((Object)string2);
        this._jobBus.waitForExecution((Object)string3);
        String string4 = (String)this._jobBus.getResult((Object)string3);
        if (IS_LOG_TESTS) {
            System.out.println("" + n);
        }
        if (IS_LOG_TESTS) {
            System.out.println("" + d);
        }
        if (IS_LOG_TESTS) {
            System.out.println(string4);
        }
        Assertions.assertEquals((int)5050, (int)n);
        Assertions.assertEquals((Object)"9.33262154439441E157", (Object)d.toString());
        Assertions.assertEquals((Object)APPEND_TEXT, (Object)string4);
        Undoable undoable = (Undoable)this._jobBus.lookupHandle((Object)string);
        Assertions.assertEquals((Object)((Object)sumCommand), (Object)undoable);
        Undoable undoable2 = (Undoable)this._jobBus.lookupHandle((Object)string2);
        Assertions.assertEquals((Object)((Object)mulCommand), (Object)undoable2);
        Undoable undoable3 = (Undoable)this._jobBus.lookupHandle((Object)string3);
        Assertions.assertEquals((Object)((Object)appendCommand), (Object)undoable3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExecuteConsumer() {
        this._ret = -1;
        SumCommand sumCommand = new SumCommand();
        this._jobBus.execute((Undoable)sumCommand, n -> {
            Assertions.assertTrue((n == 5050 ? 1 : 0) != 0);
            this._ret = n;
            JobBusProxyImplTest jobBusProxyImplTest = this;
            synchronized (jobBusProxyImplTest) {
                this.notifyAll();
            }
        });
        JobBusProxyImplTest jobBusProxyImplTest = this;
        synchronized (jobBusProxyImplTest) {
            try {
                this.wait(3000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        Assertions.assertTrue((this._ret == 5050 ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExecuteBiConsumer() {
        this._ret = -1;
        SumCommand sumCommand = new SumCommand();
        this._jobBus.execute((Undoable)sumCommand, (n, exception) -> {
            Assertions.assertNull((Object)exception);
            Assertions.assertTrue((n == 5050 ? 1 : 0) != 0);
            this._ret = n;
            JobBusProxyImplTest jobBusProxyImplTest = this;
            synchronized (jobBusProxyImplTest) {
                this.notifyAll();
            }
        });
        JobBusProxyImplTest jobBusProxyImplTest = this;
        synchronized (jobBusProxyImplTest) {
            try {
                this.wait(3000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        Assertions.assertTrue((this._ret == 5050 ? 1 : 0) != 0);
    }

    @Test
    public void testWaitForTimeout() throws NoResultAvailableRuntimeException {
        String string;
        TimeoutCommand timeoutCommand = new TimeoutCommand(5000L);
        String string2 = (String)this._jobBus.execute((Undoable)timeoutCommand);
        try {
            this._jobBus.waitForExecution((Object)string2, 100L);
            Assertions.fail((String)"Expecting to termintate with an exception as the job takes longer for execution than the wait timeout takes for waiting.");
        }
        catch (HandleTimeoutRuntimeException handleTimeoutRuntimeException) {
            // empty catch block
        }
        timeoutCommand = new TimeoutCommand(5000L);
        try {
            string = (String)this._jobBus.getResult((Undoable)timeoutCommand, 100L);
            Assertions.assertEquals((Object)DONE, (Object)string);
            Assertions.fail((String)"Expecting to termintate with an exception as the job takes longer for execution than the wait timeout takes for waiting.");
        }
        catch (HandleTimeoutRuntimeException handleTimeoutRuntimeException) {
            // empty catch block
        }
        timeoutCommand = new TimeoutCommand(100L);
        string2 = (String)this._jobBus.execute((Undoable)timeoutCommand);
        try {
            this._jobBus.waitForExecution((Object)string2, 5000L);
        }
        catch (HandleTimeoutRuntimeException handleTimeoutRuntimeException) {
            Assertions.fail((String)"Expecting to termintate in time as the job takes shorter for execution than the wait timeout takes for waiting.");
        }
        timeoutCommand = new TimeoutCommand(100L);
        try {
            string = (String)this._jobBus.getResult((Undoable)timeoutCommand, 5000L);
            Assertions.assertEquals((Object)DONE, (Object)string);
        }
        catch (HandleTimeoutRuntimeException handleTimeoutRuntimeException) {
            Assertions.fail((String)"Expecting to termintate in time as the job takes shorter for execution than the wait timeout takes for waiting.");
        }
    }

    private class TimeoutCommand
    extends AbstractUndoable<List<Integer>, String, Exception> {
        private long _timeout;

        public TimeoutCommand(long l) {
            this._timeout = l;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String execute(List<Integer> list) {
            TimeoutCommand timeoutCommand = this;
            synchronized (timeoutCommand) {
                try {
                    Thread.sleep(this._timeout);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return JobBusProxyImplTest.DONE;
        }
    }

    private class AppendCommand
    extends AbstractUndoable<List<Integer>, String, Exception> {
        private AppendCommand() {
        }

        public String execute(List<Integer> list) {
            StringBuffer stringBuffer = new StringBuffer();
            for (Integer n : list) {
                stringBuffer.append(n);
            }
            return stringBuffer.toString();
        }
    }

    private class MulCommand
    extends AbstractUndoable<List<Integer>, Double, Exception> {
        private MulCommand() {
        }

        public Double execute(List<Integer> list) {
            if (list != null && list.size() > 0) {
                double d = list.get(0).intValue();
                Iterator<Integer> iterator = list.iterator();
                iterator.next();
                while (iterator.hasNext()) {
                    Integer n = iterator.next();
                    d *= (double)n.intValue();
                }
                return d;
            }
            return 0.0;
        }
    }

    private class SumCommand
    extends AbstractUndoable<List<Integer>, Integer, Exception> {
        private SumCommand() {
        }

        public Integer execute(List<Integer> list) {
            int n = 0;
            for (Integer n2 : list) {
                n += n2.intValue();
            }
            return n;
        }
    }
}

