/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.jobbus;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.refcodes.command.AbstractUndoable;
import org.refcodes.command.Undoable;
import org.refcodes.component.HandleTimeoutRuntimeException;
import org.refcodes.jobbus.JobBus;
import org.refcodes.jobbus.JobBusProxy;
import org.refcodes.jobbus.SimpleJobBus;

public class JobBusProxyTest {
    private static final boolean IS_LOG_TESTS_ENABLED = Boolean.getBoolean("log.tests");
    private static final String APPEND_TEXT = "123456789101112131415161718192021222324252627282930313233343536373839404142434445464748495051525354555657585960616263646566676869707172737475767778798081828384858687888990919293949596979899100";
    private static final String DONE = "Done!";
    private final List<Integer> _context = new ArrayList<Integer>();
    private JobBus<List<Integer>, String> _jobBus;
    private int _ret;

    @BeforeEach
    public void beforeEach() {
        this._jobBus = new JobBusProxy((JobBus)new SimpleJobBus(this._context));
        for (int i = 1; i <= 100; ++i) {
            this._context.add(i);
        }
    }

    @Test
    public void testGetResult() throws Exception {
        SumCommand theSumCommand = new SumCommand();
        MulCommand theMulCommand = new MulCommand();
        AppendCommand theAppendCommand = new AppendCommand();
        int theSumResult = (Integer)this._jobBus.getResult((Undoable)theSumCommand);
        if (IS_LOG_TESTS_ENABLED) {
            System.out.println(Integer.toString(theSumResult));
        }
        Double theMulResult = (Double)this._jobBus.getResult((Undoable)theMulCommand);
        if (IS_LOG_TESTS_ENABLED) {
            System.out.println(Double.toString(theMulResult));
        }
        String theAppendResult = (String)this._jobBus.getResult((Undoable)theAppendCommand);
        if (IS_LOG_TESTS_ENABLED) {
            System.out.println(theAppendResult);
        }
        Assertions.assertEquals((int)5050, (int)theSumResult);
        Assertions.assertEquals((Object)"9.33262154439441E157", (Object)theMulResult.toString());
        Assertions.assertEquals((Object)APPEND_TEXT, (Object)theAppendResult);
    }

    @Test
    public void testExecute() throws Exception {
        SumCommand theSumCommand = new SumCommand();
        MulCommand theMulCommand = new MulCommand();
        AppendCommand theAppendCommand = new AppendCommand();
        String theSumHandle = (String)this._jobBus.execute((Undoable)theSumCommand);
        String theMulHandle = (String)this._jobBus.execute((Undoable)theMulCommand);
        String theAppendHandle = (String)this._jobBus.execute((Undoable)theAppendCommand);
        this._jobBus.waitForExecution((Object)theSumHandle);
        int theSumResult = (Integer)this._jobBus.getResult((Object)theSumHandle);
        this._jobBus.waitForExecution((Object)theMulHandle);
        Double theMulResult = (Double)this._jobBus.getResult((Object)theMulHandle);
        this._jobBus.waitForExecution((Object)theAppendHandle);
        String theAppendResult = (String)this._jobBus.getResult((Object)theAppendHandle);
        if (IS_LOG_TESTS_ENABLED) {
            System.out.println(Integer.toString(theSumResult));
            System.out.println(Double.toString(theMulResult));
            System.out.println(theAppendResult);
        }
        Assertions.assertEquals((int)5050, (int)theSumResult);
        Assertions.assertEquals((Object)"9.33262154439441E157", (Object)theMulResult.toString());
        Assertions.assertEquals((Object)APPEND_TEXT, (Object)theAppendResult);
        Undoable theAddCommand2 = (Undoable)this._jobBus.lookupHandle((Object)theSumHandle);
        Assertions.assertEquals((Object)((Object)theSumCommand), (Object)theAddCommand2);
        Undoable theMulCommand2 = (Undoable)this._jobBus.lookupHandle((Object)theMulHandle);
        Assertions.assertEquals((Object)((Object)theMulCommand), (Object)theMulCommand2);
        Undoable theAppendCommand2 = (Undoable)this._jobBus.lookupHandle((Object)theAppendHandle);
        Assertions.assertEquals((Object)((Object)theAppendCommand), (Object)theAppendCommand2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExecuteConsumer() {
        this._ret = -1;
        SumCommand theSumCommand = new SumCommand();
        this._jobBus.execute((Undoable)theSumCommand, ret -> {
            Assertions.assertTrue((ret == 5050 ? 1 : 0) != 0);
            this._ret = ret;
            JobBusProxyTest jobBusProxyTest = this;
            synchronized (jobBusProxyTest) {
                this.notifyAll();
            }
        });
        JobBusProxyTest jobBusProxyTest = this;
        synchronized (jobBusProxyTest) {
            try {
                this.wait(3000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        Assertions.assertTrue((this._ret == 5050 ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExecuteBiConsumer() {
        this._ret = -1;
        SumCommand theSumCommand = new SumCommand();
        this._jobBus.execute((Undoable)theSumCommand, (ret, e) -> {
            Assertions.assertNull((Object)e);
            Assertions.assertTrue((ret == 5050 ? 1 : 0) != 0);
            this._ret = ret;
            JobBusProxyTest jobBusProxyTest = this;
            synchronized (jobBusProxyTest) {
                this.notifyAll();
            }
        });
        JobBusProxyTest jobBusProxyTest = this;
        synchronized (jobBusProxyTest) {
            try {
                this.wait(3000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        Assertions.assertTrue((this._ret == 5050 ? 1 : 0) != 0);
    }

    @Test
    public void testWaitForTimeout() {
        String theResult2;
        TimeoutCommand theTimeoutCommand = new TimeoutCommand(5000L);
        String theTimeoutHandle = (String)this._jobBus.execute((Undoable)theTimeoutCommand);
        try {
            this._jobBus.waitForExecution((Object)theTimeoutHandle, 100L);
            Assertions.fail((String)"Expecting to termintate with an exception as the job takes longer for execution than the wait timeout takes for waiting.");
        }
        catch (HandleTimeoutRuntimeException handleTimeoutRuntimeException) {
            // empty catch block
        }
        theTimeoutCommand = new TimeoutCommand(5000L);
        try {
            theResult2 = (String)this._jobBus.getResult((Undoable)theTimeoutCommand, 100L);
            Assertions.assertEquals((Object)DONE, (Object)theResult2);
            Assertions.fail((String)"Expecting to termintate with an exception as the job takes longer for execution than the wait timeout takes for waiting.");
        }
        catch (HandleTimeoutRuntimeException theResult2) {
            // empty catch block
        }
        theTimeoutCommand = new TimeoutCommand(100L);
        theTimeoutHandle = (String)this._jobBus.execute((Undoable)theTimeoutCommand);
        try {
            this._jobBus.waitForExecution((Object)theTimeoutHandle, 5000L);
        }
        catch (HandleTimeoutRuntimeException e) {
            Assertions.fail((String)"Expecting to termintate in time as the job takes shorter for execution than the wait timeout takes for waiting.");
        }
        theTimeoutCommand = new TimeoutCommand(100L);
        try {
            theResult2 = (String)this._jobBus.getResult((Undoable)theTimeoutCommand, 5000L);
            Assertions.assertEquals((Object)DONE, (Object)theResult2);
        }
        catch (HandleTimeoutRuntimeException e) {
            Assertions.fail((String)"Expecting to termintate in time as the job takes shorter for execution than the wait timeout takes for waiting.");
        }
    }

    private class SumCommand
    extends AbstractUndoable<List<Integer>, Integer, Exception> {
        private SumCommand() {
        }

        public Integer execute(List<Integer> aContext) {
            int theResult = 0;
            for (Integer eInt : aContext) {
                theResult += eInt.intValue();
            }
            return theResult;
        }
    }

    private class MulCommand
    extends AbstractUndoable<List<Integer>, Double, Exception> {
        private MulCommand() {
        }

        public Double execute(List<Integer> aContext) {
            if (aContext != null && aContext.size() > 0) {
                double theResult = aContext.get(0).intValue();
                Iterator<Integer> e = aContext.iterator();
                e.next();
                while (e.hasNext()) {
                    Integer eInt = e.next();
                    theResult *= (double)eInt.intValue();
                }
                return theResult;
            }
            return 0.0;
        }
    }

    private class AppendCommand
    extends AbstractUndoable<List<Integer>, String, Exception> {
        private AppendCommand() {
        }

        public String execute(List<Integer> aContext) {
            StringBuilder theResult = new StringBuilder();
            for (Integer eInt : aContext) {
                theResult.append(eInt);
            }
            return theResult.toString();
        }
    }

    private class TimeoutCommand
    extends AbstractUndoable<List<Integer>, String, Exception> {
        private final long _timeout;

        public TimeoutCommand(long aTimeout) {
            this._timeout = aTimeout;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String execute(List<Integer> aContext) {
            TimeoutCommand timeoutCommand = this;
            synchronized (timeoutCommand) {
                try {
                    Thread.sleep(this._timeout);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return JobBusProxyTest.DONE;
        }
    }
}

