/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.logger.alt.console.impls;

import java.io.PrintStream;
import org.fusesource.jansi.Ansi;
import org.fusesource.jansi.AnsiConsole;
import org.refcodes.component.Destroyable;
import org.refcodes.logger.IllegalRecordRuntimeException;
import org.refcodes.logger.LogPriority;
import org.refcodes.logger.LoggerField;
import org.refcodes.logger.UnexpectedLogRuntimeException;
import org.refcodes.logger.alt.console.ConsoleLogger;
import org.refcodes.logger.impls.RuntimeLoggerHeaderImpl;
import org.refcodes.runtime.CommandLineInterpreter;
import org.refcodes.runtime.OperatingSystem;
import org.refcodes.runtime.SystemUtility;
import org.refcodes.tabular.ColumnMismatchException;
import org.refcodes.tabular.Header;
import org.refcodes.tabular.HeaderMismatchException;
import org.refcodes.tabular.PrintStackTrace;
import org.refcodes.tabular.Record;
import org.refcodes.tabular.Row;
import org.refcodes.textual.ColumnWidthMetrics;
import org.refcodes.textual.ColumnWidthType;
import org.refcodes.textual.HorizAlignTextBuilder;
import org.refcodes.textual.HorizAlignTextMode;
import org.refcodes.textual.MoreTextMode;
import org.refcodes.textual.SplitTextMode;
import org.refcodes.textual.TableBuilder;
import org.refcodes.textual.TableStyle;
import org.refcodes.textual.impls.ColumnWidthMetricsImpl;
import org.refcodes.textual.impls.HorizAlignTextBuilderImpl;
import org.refcodes.textual.impls.TableBuilderImpl;

public class ConsoleLoggerImpl<T>
implements Destroyable,
ConsoleLogger<T> {
    private static final int HIGH_RES = 1;
    private static final int LOW_RES = 0;
    private static final int INDEX_LINE_NUMBER = 0;
    private static final int INDEX_EXCEPTION = 7;
    private static final ColumnWidthMetrics[] A_WIDTH_LINE_NUMBER = new ColumnWidthMetrics[]{new ColumnWidthMetricsImpl(7, ColumnWidthType.ABSOLUTE), new ColumnWidthMetricsImpl(10, ColumnWidthType.ABSOLUTE)};
    private static final ColumnWidthMetrics[] B_WIDTH_DATE = new ColumnWidthMetrics[]{new ColumnWidthMetricsImpl(19, ColumnWidthType.ABSOLUTE), new ColumnWidthMetricsImpl(19, ColumnWidthType.ABSOLUTE)};
    private static final ColumnWidthMetrics[] C_WIDTH_PRIORITY = new ColumnWidthMetrics[]{new ColumnWidthMetricsImpl(7, ColumnWidthType.ABSOLUTE), new ColumnWidthMetricsImpl(7, ColumnWidthType.ABSOLUTE)};
    private static final ColumnWidthMetrics[] D_WIDTH_THREAD = new ColumnWidthMetrics[]{new ColumnWidthMetricsImpl(2, ColumnWidthType.RELATIVE), new ColumnWidthMetricsImpl(15, ColumnWidthType.ABSOLUTE)};
    private static final ColumnWidthMetrics[] E_WIDTH_CLASS = new ColumnWidthMetrics[]{new ColumnWidthMetricsImpl(4, ColumnWidthType.RELATIVE), new ColumnWidthMetricsImpl(1, ColumnWidthType.RELATIVE)};
    private static final ColumnWidthMetrics[] F_WIDTH_METHOD = new ColumnWidthMetrics[]{new ColumnWidthMetricsImpl(3, ColumnWidthType.RELATIVE), new ColumnWidthMetricsImpl(45, ColumnWidthType.ABSOLUTE)};
    private static final ColumnWidthMetrics[] G_WIDTH_MESSAGE = new ColumnWidthMetrics[]{new ColumnWidthMetricsImpl(7, ColumnWidthType.RELATIVE), new ColumnWidthMetricsImpl(2, ColumnWidthType.RELATIVE)};
    private static final ColumnWidthMetrics[] Z_WIDTH_EXCEPTION = new ColumnWidthMetrics[]{new ColumnWidthMetricsImpl(1, ColumnWidthType.RELATIVE), new ColumnWidthMetricsImpl(1, ColumnWidthType.RELATIVE)};
    private static final String ANSI_LINE_NUMBER = Ansi.ansi().fg(Ansi.Color.MAGENTA).bg(Ansi.Color.DEFAULT).toString();
    private static final String ANSI_DATE = Ansi.ansi().fg(Ansi.Color.WHITE).toString();
    private static final String ANSI_THREAD = Ansi.ansi().fgBright(Ansi.Color.WHITE).bg(Ansi.Color.BLACK).toString();
    private static final String ANSI_MESSAGE = Ansi.ansi().fg(Ansi.Color.DEFAULT).bg(Ansi.Color.DEFAULT).toString();
    private static final String ANSI_EXCEPTION = Ansi.ansi().fgBright(Ansi.Color.RED).toString();
    private static final String ANSI_CLASS = Ansi.ansi().fg(Ansi.Color.DEFAULT).bg(Ansi.Color.DEFAULT).toString();
    private static final String ANSI_METHOD = Ansi.ansi().bold().fg(Ansi.Color.BLUE).toString();
    private static final String ANSI_PRIORITY_WARN = Ansi.ansi().bold().fg(Ansi.Color.RED).toString();
    private static final String ANSI_PRIORITY_INFO = Ansi.ansi().bold().fg(Ansi.Color.GREEN).toString();
    private static final String ANSI_PRIORITY_PANIC = Ansi.ansi().bold().fgBright(Ansi.Color.WHITE).bgBright(Ansi.Color.RED).toString();
    private static final String ANSI_PRIORITY_ERROR = Ansi.ansi().bold().fgBright(Ansi.Color.RED).toString();
    private static final String ANSI_PRIORITY_DEBUG = Ansi.ansi().bold().fgBright(Ansi.Color.YELLOW).bgBright(Ansi.Color.BLUE).toString();
    private static final String ANSI_PRIORITY_TRACE = Ansi.ansi().bold().fg(Ansi.Color.WHITE).toString();
    private static String[] ANSI_PRIORITIES = new String[]{ANSI_PRIORITY_TRACE, ANSI_PRIORITY_DEBUG, ANSI_PRIORITY_INFO, ANSI_PRIORITY_INFO, ANSI_PRIORITY_WARN, ANSI_PRIORITY_ERROR, ANSI_PRIORITY_ERROR, ANSI_PRIORITY_ERROR, ANSI_PRIORITY_PANIC};
    private Header<Object> _header = new RuntimeLoggerHeaderImpl(PrintStackTrace.EXPLODED);
    private PrintStream _outStream = SystemUtility.getCommandLineInterpreter() == CommandLineInterpreter.WIN_CMD ? AnsiConsole.out : System.out;
    private PrintStream _errStream = SystemUtility.getCommandLineInterpreter() == CommandLineInterpreter.WIN_CMD ? AnsiConsole.err : System.err;
    private TableStyle _tableStyle = SystemUtility.getOperatingSystem() == OperatingSystem.WINDOWS ? TableStyle.ASCII : TableStyle.SINGLE;
    private boolean _hasLeftBorder = false;
    private boolean _hasRightBorder = false;
    private TableBuilder[] _tableMsgBuilder = new TableBuilder[9];
    private TableBuilder[] _tableExcBuilder = new TableBuilder[9];
    private int _rowWidth = SystemUtility.getConsoleWidth();
    private TableLayout _lastLayout = TableLayout.NONE;
    private LogPriority _lastPriority = LogPriority.NONE;
    private int _resIndex;

    public ConsoleLoggerImpl() {
        this.init();
        this.setEscCodes(SystemUtility.isAnsiSupported());
    }

    public synchronized void log(Record<? extends T> aRecord) throws IllegalRecordRuntimeException, UnexpectedLogRuntimeException {
        try {
            LogPriority thePriority = (LogPriority)LoggerField.LOG_PRIORITY.getColumn().get(aRecord);
            if (thePriority != LogPriority.DISCARD) {
                Row theRow = this._header.toPrintableRow(aRecord);
                if (theRow.size() > 0) {
                    String theLineNumber = (String)theRow.remove(0);
                    theRow.add(0, (Object)((HorizAlignTextBuilder)((HorizAlignTextBuilder)new HorizAlignTextBuilderImpl().withHorizAlignTextMode(HorizAlignTextMode.RIGHT).withText(new String[]{theLineNumber})).withColumnWidth(A_WIDTH_LINE_NUMBER[this._resIndex].getColumnWidth())).withFillChar('0').toString());
                }
                String theException = null;
                if (theRow.size() > 7) {
                    theException = (String)theRow.remove(7);
                }
                if (this._lastLayout == TableLayout.EXC) {
                    this._tableMsgBuilder[thePriority.getPriority()].printRowEnd(this._tableExcBuilder[thePriority.getPriority()]);
                    this._tableMsgBuilder[thePriority.getPriority()].printRowContinue((String[])theRow.toArray((Object[])new String[theRow.size()]));
                } else if (this._lastPriority == thePriority) {
                    this._tableMsgBuilder[thePriority.getPriority()].printRowContinue((String[])theRow.toArray((Object[])new String[theRow.size()]));
                } else {
                    this._tableMsgBuilder[thePriority.getPriority()].printRow((String[])theRow.toArray((Object[])new String[theRow.size()]));
                }
                if (this._lastLayout == TableLayout.NONE) {
                    this.continueTablePrinters(this._tableMsgBuilder[thePriority.getPriority()]);
                }
                this._lastLayout = TableLayout.MSG;
                if (theException != null) {
                    theException = theException.replaceAll("\t", "--> ");
                    this._tableExcBuilder[thePriority.getPriority()].printRowEnd(this._tableMsgBuilder[thePriority.getPriority()]);
                    this._tableExcBuilder[thePriority.getPriority()].printRowContinue(new String[]{theException});
                    if (this._lastLayout == TableLayout.NONE) {
                        this.continueTablePrinters(this._tableExcBuilder[thePriority.getPriority()]);
                    }
                    this._lastLayout = TableLayout.EXC;
                }
                this._lastPriority = thePriority;
            }
        }
        catch (ClassCastException | ColumnMismatchException | HeaderMismatchException e) {
            throw new IllegalRecordRuntimeException(aRecord, e);
        }
    }

    @Override
    public PrintStream getOutStream() {
        return this._outStream;
    }

    @Override
    public void setOutStream(PrintStream aOutStream) {
        this._outStream = aOutStream;
    }

    @Override
    public PrintStream getErrStream() {
        return this._errStream;
    }

    @Override
    public void setErrStream(PrintStream aErrStream) {
        this._errStream = aErrStream;
    }

    public TableStyle getTableStyle() {
        return this._tableStyle;
    }

    public void setTableStyle(TableStyle aTableStyle) {
        this._tableStyle = aTableStyle;
        this.init();
    }

    @Override
    public void setTableStyleName(String aTableStyleName) {
        this.setTableStyle(TableStyle.valueOf((String)aTableStyleName));
    }

    @Override
    public void setEscCodes(boolean isEscCodesEnabled) {
        for (TableBuilder eBuilder : this._tableMsgBuilder) {
            eBuilder.withEscCodes(isEscCodesEnabled);
        }
        for (TableBuilder eBuilder : this._tableExcBuilder) {
            eBuilder.withEscCodes(isEscCodesEnabled);
        }
    }

    @Override
    public boolean hasLeftBorder() {
        return this._hasLeftBorder;
    }

    @Override
    public void setLeftBorder(boolean hasLeftBorder) {
        this._hasLeftBorder = hasLeftBorder;
        this.init();
    }

    @Override
    public boolean hasRightBorder() {
        return this._hasRightBorder;
    }

    @Override
    public void setRightBorder(boolean hasRightBorder) {
        this._hasRightBorder = hasRightBorder;
        this.init();
    }

    public int getRowWidth() {
        return this._rowWidth;
    }

    public void setRowWidth(int aRowWidth) {
        this._rowWidth = aRowWidth;
        this.init();
    }

    @Override
    public ConsoleLogger<T> withOutStream(PrintStream aOutStream) {
        this._outStream = aOutStream;
        return this;
    }

    @Override
    public ConsoleLogger<T> withErrStream(PrintStream aErrStream) {
        this._errStream = aErrStream;
        return this;
    }

    public ConsoleLogger<T> withTableStyle(TableStyle aTableStyle) {
        this._tableStyle = aTableStyle;
        this.init();
        return this;
    }

    @Override
    public ConsoleLogger<T> withEscCodes(boolean isEscCodesEnabled) {
        this.setEscCodes(isEscCodesEnabled);
        return this;
    }

    @Override
    public ConsoleLogger<T> withLeftBorder(boolean hasLeftBorder) {
        this._hasLeftBorder = hasLeftBorder;
        return this;
    }

    @Override
    public ConsoleLogger<T> withRightBorder(boolean hasRightBorder) {
        this._hasRightBorder = hasRightBorder;
        return this;
    }

    public ConsoleLogger<?> withRowWidth(int aRowWidth) {
        this.setRowWidth(aRowWidth);
        return this;
    }

    public void destroy() {
        if (SystemUtility.getCommandLineInterpreter() == CommandLineInterpreter.WIN_CMD) {
            AnsiConsole.systemUninstall();
        }
        if (this._lastLayout == TableLayout.MSG) {
            this._tableMsgBuilder[0].printTail();
        } else if (this._lastLayout == TableLayout.EXC) {
            this._tableExcBuilder[0].printTail();
        }
    }

    private void init() {
        boolean isLessThanWarn;
        int i;
        if (SystemUtility.getCommandLineInterpreter() == CommandLineInterpreter.WIN_CMD) {
            AnsiConsole.systemInstall();
        }
        if (this._rowWidth <= 80) {
            this._rowWidth = 80;
        }
        this._resIndex = this._rowWidth < 240 ? 0 : 1;
        boolean isLineBreak = true;
        if (SystemUtility.getCommandLineInterpreter() == CommandLineInterpreter.WIN_CMD && this._rowWidth == SystemUtility.getConsoleWidth()) {
            isLineBreak = false;
        }
        for (i = 0; i < this._tableMsgBuilder.length; ++i) {
            isLessThanWarn = i < LogPriority.WARN.getPriority();
            MoreTextMode eMoreMode = isLessThanWarn ? MoreTextMode.LEFT : MoreTextMode.NONE;
            this._tableMsgBuilder[i] = new TableBuilderImpl(this._rowWidth).withTableStyle(this._tableStyle).withPrintStream(isLessThanWarn ? this._outStream : this._errStream);
            this._tableMsgBuilder[i].withLeftBorder(this._hasLeftBorder).withRightBorder(this._hasRightBorder);
            if (!isLineBreak) {
                this._tableMsgBuilder[i].withLineBreak("");
            }
            this._tableMsgBuilder[i].addColumn().withColumnWidthMetrics(A_WIDTH_LINE_NUMBER[this._resIndex]).withColumnEscCode(ANSI_LINE_NUMBER).withColumnHorizAlignTextMode(HorizAlignTextMode.CENTER).withColumnMoreTextMode(eMoreMode);
            this._tableMsgBuilder[i].addColumn().withColumnWidthMetrics(B_WIDTH_DATE[this._resIndex]).withColumnEscCode(ANSI_DATE).withColumnHorizAlignTextMode(HorizAlignTextMode.RIGHT).withColumnMoreTextMode(eMoreMode);
            this._tableMsgBuilder[i].addColumn().withColumnWidthMetrics(C_WIDTH_PRIORITY[this._resIndex]).withColumnEscCode(ANSI_PRIORITIES[i]).withColumnHorizAlignTextMode(HorizAlignTextMode.LEFT).withColumnMoreTextMode(eMoreMode);
            this._tableMsgBuilder[i].addColumn().withColumnWidthMetrics(D_WIDTH_THREAD[this._resIndex]).withColumnEscCode(ANSI_THREAD).withColumnHorizAlignTextMode(HorizAlignTextMode.LEFT).withColumnMoreTextMode(eMoreMode);
            this._tableMsgBuilder[i].addColumn().withColumnWidthMetrics(E_WIDTH_CLASS[this._resIndex]).withColumnEscCode(ANSI_CLASS).withColumnHorizAlignTextMode(HorizAlignTextMode.LEFT).withColumnMoreTextMode(eMoreMode);
            this._tableMsgBuilder[i].addColumn().withColumnWidthMetrics(F_WIDTH_METHOD[this._resIndex]).withColumnEscCode(ANSI_METHOD).withColumnHorizAlignTextMode(HorizAlignTextMode.LEFT).withColumnMoreTextMode(eMoreMode);
            this._tableMsgBuilder[i].addColumn().withColumnWidthMetrics(G_WIDTH_MESSAGE[this._resIndex]).withColumnEscCode(ANSI_MESSAGE).withColumnHorizAlignTextMode(HorizAlignTextMode.LEFT).withColumnMoreTextMode(eMoreMode);
        }
        for (i = 0; i < this._tableExcBuilder.length; ++i) {
            isLessThanWarn = i < LogPriority.WARN.getPriority();
            this._tableExcBuilder[i] = new TableBuilderImpl(this._rowWidth).withTableStyle(this._tableStyle == TableStyle.SINGLE ? TableStyle.SINGLE_DASHED : this._tableStyle).withPrintStream(isLessThanWarn ? this._outStream : this._errStream);
            this._tableExcBuilder[i].withLeftBorder(this._hasLeftBorder).withRightBorder(this._hasRightBorder);
            if (!isLineBreak) {
                this._tableExcBuilder[i].withLineBreak("");
            }
            this._tableExcBuilder[i].addColumn().withColumnWidthMetrics(Z_WIDTH_EXCEPTION[this._resIndex]).withColumnEscCode(ANSI_EXCEPTION).withColumnHorizAlignTextMode(HorizAlignTextMode.LEFT).withColumnSplitTextMode(SplitTextMode.AT_FIRST_END_OF_LINE);
        }
    }

    private void continueTablePrinters(TableBuilder aTableBuilder) {
        for (int i = 0; i < this._tableMsgBuilder.length; ++i) {
            if (aTableBuilder != this._tableMsgBuilder[i]) {
                this._tableMsgBuilder[i].setTableStatus(aTableBuilder.getTableStatus());
            }
            if (aTableBuilder == this._tableExcBuilder[i]) continue;
            this._tableExcBuilder[i].setTableStatus(aTableBuilder.getTableStatus());
        }
    }

    private static enum TableLayout {
        NONE,
        MSG,
        EXC;

    }
}

