/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.logger.alt.console;

import org.fusesource.jansi.Ansi;
import org.refcodes.logger.ColumnLayout;
import org.refcodes.logger.LogPriority;
import org.refcodes.logger.LoggerField;
import org.refcodes.tabular.FormattedColumn;
import org.refcodes.tabular.FormattedColumnDecorator;
import org.refcodes.tabular.FormattedHeaderImpl;
import org.refcodes.tabular.PrintStackTrace;
import org.refcodes.textual.ColumnSetupMetrics;
import org.refcodes.textual.ColumnSetupMetricsImpl;
import org.refcodes.textual.ColumnWidthType;
import org.refcodes.textual.EscapeCodeFactory;
import org.refcodes.textual.HorizAlignTextMode;
import org.refcodes.textual.MoreTextMode;
import org.refcodes.textual.SplitTextMode;
import org.refcodes.textual.TextFormatMode;

public class ConsoleLoggerHeaderImpl
extends FormattedHeaderImpl<Object> {
    private static final long serialVersionUID = 1L;
    private static EscapeCodeFactory LOG_PRIORITY_ESC_CODE_FACTORY = new EscapeCodeFactory(){

        public String createInstance(Object aIdentifier) {
            if (aIdentifier != null) {
                String theIdentifier;
                String string = theIdentifier = aIdentifier instanceof String ? (String)aIdentifier : aIdentifier.toString();
                if (LogPriority.PANIC.name().equals(theIdentifier)) {
                    return ANSI_PRIORITY_PANIC;
                }
                if (LogPriority.ALERT.name().equals(theIdentifier)) {
                    return ANSI_PRIORITY_ALERT;
                }
                if (LogPriority.CRITICAL.name().equals(theIdentifier)) {
                    return ANSI_PRIORITY_CRITICAL;
                }
                if (LogPriority.ERROR.name().equals(theIdentifier)) {
                    return ANSI_PRIORITY_ERROR;
                }
                if (LogPriority.WARN.name().equals(theIdentifier)) {
                    return ANSI_PRIORITY_WARN;
                }
                if (LogPriority.NOTICE.name().equals(theIdentifier)) {
                    return ANSI_PRIORITY_NOTICE;
                }
                if (LogPriority.INFO.name().equals(theIdentifier)) {
                    return ANSI_PRIORITY_INFO;
                }
                if (LogPriority.DEBUG.name().equals(theIdentifier)) {
                    return ANSI_PRIORITY_DEBUG;
                }
                if (LogPriority.TRACE.name().equals(theIdentifier)) {
                    return ANSI_PRIORITY_TRACE;
                }
            }
            return null;
        }
    };
    private static final String EXCEPTION = "Exception";
    private static final String MESSAGE = "Message";
    private static final String METHOD = "Method";
    private static final String CODE_LINE = "@";
    private static final String CLASS = "Class";
    private static final String REQUEST = "Request";
    private static final String SESSION = "Session";
    private static final String THREAD = "Thread";
    private static final String PRIORITY = "Level";
    private static final String DATE = "Date";
    private static final String LINE_NUMBER = "#";
    private static final String ANSI_LINE_NUMBER = Ansi.ansi().fg(Ansi.Color.MAGENTA).bg(Ansi.Color.DEFAULT).toString();
    private static final String ANSI_DATE = Ansi.ansi().fg(Ansi.Color.WHITE).toString();
    private static final String ANSI_THREAD = Ansi.ansi().fg(Ansi.Color.CYAN).toString();
    private static final String ANSI_CORRELATION_ID = Ansi.ansi().fg(Ansi.Color.CYAN).bg(Ansi.Color.DEFAULT).toString();
    private static final String ANSI_MESSAGE = Ansi.ansi().fg(Ansi.Color.DEFAULT).bg(Ansi.Color.DEFAULT).toString();
    private static final String ANSI_EXCEPTION = Ansi.ansi().fgBright(Ansi.Color.RED).toString();
    private static final String ANSI_CLASS = Ansi.ansi().fg(Ansi.Color.DEFAULT).bg(Ansi.Color.DEFAULT).toString();
    private static final String ANSI_METHOD = Ansi.ansi().bold().fg(Ansi.Color.BLUE).toString();
    private static final String ANSI_PRIORITY_WARN = Ansi.ansi().bold().fg(Ansi.Color.RED).toString();
    private static final String ANSI_PRIORITY_NOTICE = Ansi.ansi().bold().fg(Ansi.Color.MAGENTA).toString();
    private static final String ANSI_PRIORITY_INFO = Ansi.ansi().bold().fg(Ansi.Color.GREEN).toString();
    private static final String ANSI_PRIORITY_PANIC = Ansi.ansi().bold().fgBright(Ansi.Color.WHITE).bgBright(Ansi.Color.RED).toString();
    private static final String ANSI_PRIORITY_ALERT = Ansi.ansi().bold().fgBright(Ansi.Color.YELLOW).bgBright(Ansi.Color.RED).toString();
    private static final String ANSI_PRIORITY_CRITICAL = Ansi.ansi().bold().fgBright(Ansi.Color.YELLOW).bgBright(Ansi.Color.MAGENTA).toString();
    private static final String ANSI_PRIORITY_ERROR = Ansi.ansi().bold().fgBright(Ansi.Color.RED).toString();
    private static final String ANSI_PRIORITY_DEBUG = Ansi.ansi().bold().fgBright(Ansi.Color.YELLOW).bgBright(Ansi.Color.BLUE).toString();
    private static final String ANSI_PRIORITY_TRACE = Ansi.ansi().bold().fg(Ansi.Color.WHITE).toString();
    private static final String ANSI_HEADER = Ansi.ansi().bold().fg(Ansi.Color.DEFAULT).bg(Ansi.Color.DEFAULT).toString();
    private static final String ANSI_RESET = Ansi.ansi().reset().toString();
    private static final ColumnSetupMetrics[] SUPERUSER_COLUMN_METRICS = new ColumnSetupMetrics[]{new ColumnSetupMetricsImpl(10, ColumnWidthType.ABSOLUTE).withHeaderTextFormatMode(TextFormatMode.CELL).withHeaderHorizAlignTextMode(HorizAlignTextMode.CENTER).withHeaderEscapeCode(ANSI_HEADER).withHeaderMoreTextMode(MoreTextMode.RIGHT).withRowHorizAlignTextMode(HorizAlignTextMode.RIGHT).withRowEscapeCode(ANSI_LINE_NUMBER).withRowMoreTextMode(MoreTextMode.NONE).withName("#"), new ColumnSetupMetricsImpl(19, ColumnWidthType.ABSOLUTE).withHeaderTextFormatMode(TextFormatMode.CELL).withHeaderHorizAlignTextMode(HorizAlignTextMode.CENTER).withHeaderEscapeCode(ANSI_HEADER).withHeaderMoreTextMode(MoreTextMode.RIGHT).withRowHorizAlignTextMode(HorizAlignTextMode.RIGHT).withRowEscapeCode(ANSI_DATE).withRowMoreTextMode(MoreTextMode.NONE).withName("Date"), new ColumnSetupMetricsImpl(7, ColumnWidthType.ABSOLUTE).withTextFormatMode(TextFormatMode.CELL).withHeaderHorizAlignTextMode(HorizAlignTextMode.CENTER).withHeaderEscapeCode(ANSI_HEADER).withHeaderMoreTextMode(MoreTextMode.RIGHT).withRowHorizAlignTextMode(HorizAlignTextMode.CENTER).withRowEscapeCodeFactory(LOG_PRIORITY_ESC_CODE_FACTORY).withRowMoreTextMode(MoreTextMode.NONE).withName("Level"), new ColumnSetupMetricsImpl(10, ColumnWidthType.ABSOLUTE).withHeaderTextFormatMode(TextFormatMode.CELL).withHeaderHorizAlignTextMode(HorizAlignTextMode.CENTER).withHeaderEscapeCode(ANSI_HEADER).withHeaderMoreTextMode(MoreTextMode.RIGHT).withRowHorizAlignTextMode(HorizAlignTextMode.LEFT).withRowEscapeCode(ANSI_THREAD).withRowMoreTextMode(MoreTextMode.LEFT).withName("Thread"), new ColumnSetupMetricsImpl(8, ColumnWidthType.ABSOLUTE).withHeaderTextFormatMode(TextFormatMode.CELL).withHeaderHorizAlignTextMode(HorizAlignTextMode.CENTER).withHeaderEscapeCode(ANSI_HEADER).withHeaderMoreTextMode(MoreTextMode.RIGHT).withRowHorizAlignTextMode(HorizAlignTextMode.CENTER).withRowEscapeCode(ANSI_CORRELATION_ID).withRowMoreTextMode(MoreTextMode.LEFT).withName("Session"), new ColumnSetupMetricsImpl(8, ColumnWidthType.ABSOLUTE).withHeaderTextFormatMode(TextFormatMode.CELL).withHeaderHorizAlignTextMode(HorizAlignTextMode.CENTER).withHeaderEscapeCode(ANSI_HEADER).withHeaderMoreTextMode(MoreTextMode.RIGHT).withRowHorizAlignTextMode(HorizAlignTextMode.CENTER).withRowEscapeCode(ANSI_CORRELATION_ID).withRowMoreTextMode(MoreTextMode.LEFT).withName("Request"), new ColumnSetupMetricsImpl(1, ColumnWidthType.RELATIVE).withHeaderTextFormatMode(TextFormatMode.CELL).withHeaderHorizAlignTextMode(HorizAlignTextMode.CENTER).withHeaderEscapeCode(ANSI_HEADER).withHeaderMoreTextMode(MoreTextMode.RIGHT).withRowHorizAlignTextMode(HorizAlignTextMode.LEFT).withRowEscapeCode(ANSI_CLASS).withRowMoreTextMode(MoreTextMode.LEFT).withName("Class"), new ColumnSetupMetricsImpl(4, ColumnWidthType.ABSOLUTE).withHeaderTextFormatMode(TextFormatMode.CELL).withHeaderHorizAlignTextMode(HorizAlignTextMode.CENTER).withHeaderEscapeCode(ANSI_HEADER).withHeaderMoreTextMode(MoreTextMode.RIGHT).withRowHorizAlignTextMode(HorizAlignTextMode.RIGHT).withRowEscapeCode(ANSI_CLASS).withRowMoreTextMode(MoreTextMode.LEFT).withName("@"), new ColumnSetupMetricsImpl(30, ColumnWidthType.ABSOLUTE).withHeaderTextFormatMode(TextFormatMode.CELL).withHeaderHorizAlignTextMode(HorizAlignTextMode.CENTER).withHeaderEscapeCode(ANSI_HEADER).withHeaderMoreTextMode(MoreTextMode.RIGHT).withRowHorizAlignTextMode(HorizAlignTextMode.LEFT).withRowEscapeCode(ANSI_METHOD).withRowMoreTextMode(MoreTextMode.LEFT).withName("Method"), new ColumnSetupMetricsImpl(2, ColumnWidthType.RELATIVE).withHeaderTextFormatMode(TextFormatMode.CELL).withHeaderHorizAlignTextMode(HorizAlignTextMode.CENTER).withHeaderEscapeCode(ANSI_HEADER).withHeaderMoreTextMode(MoreTextMode.RIGHT).withRowHorizAlignTextMode(HorizAlignTextMode.LEFT).withRowEscapeCode(ANSI_MESSAGE).withRowMoreTextMode(MoreTextMode.LEFT).withName("Message"), new ColumnSetupMetricsImpl(1, ColumnWidthType.RELATIVE).withHeaderTextFormatMode(TextFormatMode.CELL).withHeaderHorizAlignTextMode(HorizAlignTextMode.CENTER).withHeaderEscapeCode(ANSI_HEADER).withHeaderMoreTextMode(MoreTextMode.NONE).withRowHorizAlignTextMode(HorizAlignTextMode.LEFT).withRowEscapeCode(ANSI_EXCEPTION).withRowSplitTextMode(SplitTextMode.AT_FIRST_END_OF_LINE).withName("Exception")};
    private static final ColumnSetupMetrics[] GRANDPA_COLUMN_METRICS = new ColumnSetupMetrics[]{new ColumnSetupMetricsImpl().withHide(), new ColumnSetupMetricsImpl(19, ColumnWidthType.ABSOLUTE).withHeaderTextFormatMode(TextFormatMode.CELL).withHeaderHorizAlignTextMode(HorizAlignTextMode.CENTER).withHeaderEscapeCode(ANSI_HEADER).withHeaderMoreTextMode(MoreTextMode.RIGHT).withRowHorizAlignTextMode(HorizAlignTextMode.RIGHT).withRowEscapeCode(ANSI_DATE).withRowMoreTextMode(MoreTextMode.LEFT).withName("Date"), new ColumnSetupMetricsImpl(7, ColumnWidthType.ABSOLUTE).withTextFormatMode(TextFormatMode.CELL).withHeaderHorizAlignTextMode(HorizAlignTextMode.CENTER).withHeaderEscapeCode(ANSI_HEADER).withHeaderMoreTextMode(MoreTextMode.RIGHT).withRowHorizAlignTextMode(HorizAlignTextMode.CENTER).withRowEscapeCodeFactory(LOG_PRIORITY_ESC_CODE_FACTORY).withRowMoreTextMode(MoreTextMode.NONE).withName("Level"), new ColumnSetupMetricsImpl(8, ColumnWidthType.ABSOLUTE).withHeaderTextFormatMode(TextFormatMode.CELL).withHeaderHorizAlignTextMode(HorizAlignTextMode.CENTER).withHeaderEscapeCode(ANSI_HEADER).withHeaderMoreTextMode(MoreTextMode.RIGHT).withRowHorizAlignTextMode(HorizAlignTextMode.LEFT).withRowEscapeCode(ANSI_THREAD).withRowMoreTextMode(MoreTextMode.LEFT).withName("Thread"), new ColumnSetupMetricsImpl().withHide(), new ColumnSetupMetricsImpl().withHide(), new ColumnSetupMetricsImpl().withHide(), new ColumnSetupMetricsImpl().withHide(), new ColumnSetupMetricsImpl().withHide(), new ColumnSetupMetricsImpl(7, ColumnWidthType.RELATIVE).withHeaderTextFormatMode(TextFormatMode.CELL).withHeaderHorizAlignTextMode(HorizAlignTextMode.CENTER).withHeaderEscapeCode(ANSI_HEADER).withHeaderMoreTextMode(MoreTextMode.RIGHT).withRowHorizAlignTextMode(HorizAlignTextMode.LEFT).withRowEscapeCode(ANSI_MESSAGE).withRowMoreTextMode(MoreTextMode.LEFT).withName("Message"), new ColumnSetupMetricsImpl(1, ColumnWidthType.RELATIVE).withHeaderTextFormatMode(TextFormatMode.CELL).withHeaderHorizAlignTextMode(HorizAlignTextMode.CENTER).withHeaderEscapeCode(ANSI_HEADER).withHeaderMoreTextMode(MoreTextMode.NONE).withRowHorizAlignTextMode(HorizAlignTextMode.LEFT).withRowEscapeCode(ANSI_EXCEPTION).withRowSplitTextMode(SplitTextMode.AT_FIRST_END_OF_LINE).withName("Exception")};
    private static final ColumnSetupMetrics[] DEVELOPER_COLUMN_METRICS = new ColumnSetupMetrics[]{new ColumnSetupMetricsImpl().withHide(), new ColumnSetupMetricsImpl(19, ColumnWidthType.ABSOLUTE).withHeaderTextFormatMode(TextFormatMode.CELL).withHeaderHorizAlignTextMode(HorizAlignTextMode.CENTER).withHeaderEscapeCode(ANSI_HEADER).withHeaderMoreTextMode(MoreTextMode.RIGHT).withRowHorizAlignTextMode(HorizAlignTextMode.RIGHT).withRowEscapeCode(ANSI_DATE).withRowMoreTextMode(MoreTextMode.NONE).withName("Date"), new ColumnSetupMetricsImpl(7, ColumnWidthType.ABSOLUTE).withTextFormatMode(TextFormatMode.CELL).withHeaderHorizAlignTextMode(HorizAlignTextMode.CENTER).withHeaderEscapeCode(ANSI_HEADER).withHeaderMoreTextMode(MoreTextMode.RIGHT).withRowHorizAlignTextMode(HorizAlignTextMode.CENTER).withRowEscapeCodeFactory(LOG_PRIORITY_ESC_CODE_FACTORY).withRowMoreTextMode(MoreTextMode.NONE).withName("Level"), new ColumnSetupMetricsImpl(8, ColumnWidthType.ABSOLUTE).withHeaderTextFormatMode(TextFormatMode.CELL).withHeaderHorizAlignTextMode(HorizAlignTextMode.CENTER).withHeaderEscapeCode(ANSI_HEADER).withHeaderMoreTextMode(MoreTextMode.RIGHT).withRowHorizAlignTextMode(HorizAlignTextMode.LEFT).withRowEscapeCode(ANSI_THREAD).withRowMoreTextMode(MoreTextMode.LEFT).withName("Thread"), new ColumnSetupMetricsImpl().withHide(), new ColumnSetupMetricsImpl(8, ColumnWidthType.ABSOLUTE).withHeaderTextFormatMode(TextFormatMode.CELL).withHeaderHorizAlignTextMode(HorizAlignTextMode.CENTER).withHeaderEscapeCode(ANSI_HEADER).withHeaderMoreTextMode(MoreTextMode.RIGHT).withRowHorizAlignTextMode(HorizAlignTextMode.CENTER).withRowEscapeCode(ANSI_CORRELATION_ID).withRowMoreTextMode(MoreTextMode.LEFT).withName("Request"), new ColumnSetupMetricsImpl(3, ColumnWidthType.RELATIVE).withHeaderTextFormatMode(TextFormatMode.CELL).withHeaderHorizAlignTextMode(HorizAlignTextMode.CENTER).withHeaderEscapeCode(ANSI_HEADER).withHeaderMoreTextMode(MoreTextMode.RIGHT).withRowHorizAlignTextMode(HorizAlignTextMode.LEFT).withRowEscapeCode(ANSI_CLASS).withRowMoreTextMode(MoreTextMode.LEFT).withName("Class"), new ColumnSetupMetricsImpl(4, ColumnWidthType.ABSOLUTE).withHeaderTextFormatMode(TextFormatMode.CELL).withHeaderHorizAlignTextMode(HorizAlignTextMode.CENTER).withHeaderEscapeCode(ANSI_HEADER).withHeaderMoreTextMode(MoreTextMode.RIGHT).withRowHorizAlignTextMode(HorizAlignTextMode.RIGHT).withRowEscapeCode(ANSI_CLASS).withRowMoreTextMode(MoreTextMode.LEFT).withName("@"), new ColumnSetupMetricsImpl(2, ColumnWidthType.RELATIVE).withHeaderTextFormatMode(TextFormatMode.CELL).withHeaderHorizAlignTextMode(HorizAlignTextMode.CENTER).withHeaderEscapeCode(ANSI_HEADER).withHeaderMoreTextMode(MoreTextMode.RIGHT).withRowHorizAlignTextMode(HorizAlignTextMode.LEFT).withRowEscapeCode(ANSI_METHOD).withRowMoreTextMode(MoreTextMode.LEFT).withName("Method"), new ColumnSetupMetricsImpl(7, ColumnWidthType.RELATIVE).withHeaderTextFormatMode(TextFormatMode.CELL).withHeaderHorizAlignTextMode(HorizAlignTextMode.CENTER).withHeaderEscapeCode(ANSI_HEADER).withHeaderMoreTextMode(MoreTextMode.RIGHT).withRowHorizAlignTextMode(HorizAlignTextMode.LEFT).withRowEscapeCode(ANSI_MESSAGE).withRowMoreTextMode(MoreTextMode.LEFT).withName("Message"), new ColumnSetupMetricsImpl(1, ColumnWidthType.RELATIVE).withHeaderTextFormatMode(TextFormatMode.CELL).withHeaderHorizAlignTextMode(HorizAlignTextMode.CENTER).withHeaderEscapeCode(ANSI_HEADER).withHeaderMoreTextMode(MoreTextMode.NONE).withRowHorizAlignTextMode(HorizAlignTextMode.LEFT).withRowEscapeCode(ANSI_EXCEPTION).withRowSplitTextMode(SplitTextMode.AT_FIRST_END_OF_LINE).withName("Exception")};
    private static final ColumnSetupMetrics[] DEVOPS_COLUMN_METRICS = new ColumnSetupMetrics[]{new ColumnSetupMetricsImpl().withHide(), new ColumnSetupMetricsImpl(19, ColumnWidthType.ABSOLUTE).withHeaderTextFormatMode(TextFormatMode.CELL).withHeaderHorizAlignTextMode(HorizAlignTextMode.CENTER).withHeaderEscapeCode(ANSI_HEADER).withHeaderMoreTextMode(MoreTextMode.RIGHT).withRowHorizAlignTextMode(HorizAlignTextMode.RIGHT).withRowEscapeCode(ANSI_DATE).withRowMoreTextMode(MoreTextMode.NONE).withName("Date"), new ColumnSetupMetricsImpl(7, ColumnWidthType.ABSOLUTE).withTextFormatMode(TextFormatMode.CELL).withHeaderHorizAlignTextMode(HorizAlignTextMode.CENTER).withHeaderEscapeCode(ANSI_HEADER).withHeaderMoreTextMode(MoreTextMode.RIGHT).withRowHorizAlignTextMode(HorizAlignTextMode.CENTER).withRowEscapeCodeFactory(LOG_PRIORITY_ESC_CODE_FACTORY).withRowMoreTextMode(MoreTextMode.NONE).withName("Level"), new ColumnSetupMetricsImpl(8, ColumnWidthType.ABSOLUTE).withHeaderTextFormatMode(TextFormatMode.CELL).withHeaderHorizAlignTextMode(HorizAlignTextMode.CENTER).withHeaderEscapeCode(ANSI_HEADER).withHeaderMoreTextMode(MoreTextMode.RIGHT).withRowHorizAlignTextMode(HorizAlignTextMode.LEFT).withRowEscapeCode(ANSI_THREAD).withRowMoreTextMode(MoreTextMode.LEFT).withName("Thread"), new ColumnSetupMetricsImpl(8, ColumnWidthType.ABSOLUTE).withHeaderTextFormatMode(TextFormatMode.CELL).withHeaderHorizAlignTextMode(HorizAlignTextMode.CENTER).withHeaderEscapeCode(ANSI_HEADER).withHeaderMoreTextMode(MoreTextMode.RIGHT).withRowHorizAlignTextMode(HorizAlignTextMode.LEFT).withRowEscapeCode(ANSI_CORRELATION_ID).withRowMoreTextMode(MoreTextMode.LEFT).withName("Session"), new ColumnSetupMetricsImpl(8, ColumnWidthType.ABSOLUTE).withHeaderTextFormatMode(TextFormatMode.CELL).withHeaderHorizAlignTextMode(HorizAlignTextMode.CENTER).withHeaderEscapeCode(ANSI_HEADER).withHeaderMoreTextMode(MoreTextMode.RIGHT).withRowHorizAlignTextMode(HorizAlignTextMode.CENTER).withRowEscapeCode(ANSI_CORRELATION_ID).withRowMoreTextMode(MoreTextMode.LEFT).withName("Request"), new ColumnSetupMetricsImpl(3, ColumnWidthType.RELATIVE).withHeaderTextFormatMode(TextFormatMode.CELL).withHeaderHorizAlignTextMode(HorizAlignTextMode.CENTER).withHeaderEscapeCode(ANSI_HEADER).withHeaderMoreTextMode(MoreTextMode.RIGHT).withRowHorizAlignTextMode(HorizAlignTextMode.LEFT).withRowEscapeCode(ANSI_CLASS).withRowMoreTextMode(MoreTextMode.LEFT).withName("Class"), new ColumnSetupMetricsImpl().withHide(), new ColumnSetupMetricsImpl(2, ColumnWidthType.RELATIVE).withHeaderTextFormatMode(TextFormatMode.CELL).withHeaderHorizAlignTextMode(HorizAlignTextMode.CENTER).withHeaderEscapeCode(ANSI_HEADER).withHeaderMoreTextMode(MoreTextMode.RIGHT).withRowHorizAlignTextMode(HorizAlignTextMode.LEFT).withRowEscapeCode(ANSI_METHOD).withRowMoreTextMode(MoreTextMode.LEFT).withName("Method"), new ColumnSetupMetricsImpl(7, ColumnWidthType.RELATIVE).withHeaderTextFormatMode(TextFormatMode.CELL).withHeaderHorizAlignTextMode(HorizAlignTextMode.CENTER).withHeaderEscapeCode(ANSI_HEADER).withHeaderMoreTextMode(MoreTextMode.RIGHT).withRowHorizAlignTextMode(HorizAlignTextMode.LEFT).withRowEscapeCode(ANSI_MESSAGE).withRowMoreTextMode(MoreTextMode.LEFT).withName("Message"), new ColumnSetupMetricsImpl(1, ColumnWidthType.RELATIVE).withHeaderTextFormatMode(TextFormatMode.CELL).withHeaderHorizAlignTextMode(HorizAlignTextMode.CENTER).withHeaderEscapeCode(ANSI_HEADER).withHeaderMoreTextMode(MoreTextMode.NONE).withRowHorizAlignTextMode(HorizAlignTextMode.LEFT).withRowEscapeCode(ANSI_EXCEPTION).withRowSplitTextMode(SplitTextMode.AT_FIRST_END_OF_LINE).withName("Exception")};
    private static final ColumnSetupMetrics[] ENDUSER_COLUMN_METRICS = new ColumnSetupMetrics[]{new ColumnSetupMetricsImpl().withHide(), new ColumnSetupMetricsImpl(19, ColumnWidthType.ABSOLUTE).withHeaderTextFormatMode(TextFormatMode.CELL).withHeaderHorizAlignTextMode(HorizAlignTextMode.CENTER).withHeaderEscapeCode(ANSI_HEADER).withHeaderMoreTextMode(MoreTextMode.RIGHT).withRowHorizAlignTextMode(HorizAlignTextMode.RIGHT).withRowEscapeCode(ANSI_DATE).withRowMoreTextMode(MoreTextMode.NONE).withName("Date"), new ColumnSetupMetricsImpl(7, ColumnWidthType.ABSOLUTE).withTextFormatMode(TextFormatMode.CELL).withHeaderHorizAlignTextMode(HorizAlignTextMode.CENTER).withHeaderEscapeCode(ANSI_HEADER).withHeaderMoreTextMode(MoreTextMode.RIGHT).withRowHorizAlignTextMode(HorizAlignTextMode.CENTER).withRowEscapeCodeFactory(LOG_PRIORITY_ESC_CODE_FACTORY).withRowMoreTextMode(MoreTextMode.NONE).withName("Level"), new ColumnSetupMetricsImpl().withHide(), new ColumnSetupMetricsImpl().withHide(), new ColumnSetupMetricsImpl().withHide(), new ColumnSetupMetricsImpl().withHide(), new ColumnSetupMetricsImpl().withHide(), new ColumnSetupMetricsImpl().withHide(), new ColumnSetupMetricsImpl(1, ColumnWidthType.RELATIVE).withHeaderTextFormatMode(TextFormatMode.CELL).withHeaderHorizAlignTextMode(HorizAlignTextMode.CENTER).withHeaderEscapeCode(ANSI_HEADER).withHeaderMoreTextMode(MoreTextMode.RIGHT).withRowHorizAlignTextMode(HorizAlignTextMode.LEFT).withRowEscapeCode(ANSI_MESSAGE).withRowMoreTextMode(MoreTextMode.LEFT).withName("Message"), new ColumnSetupMetricsImpl(1, ColumnWidthType.RELATIVE).withHeaderTextFormatMode(TextFormatMode.CELL).withHeaderHorizAlignTextMode(HorizAlignTextMode.CENTER).withHeaderEscapeCode(ANSI_HEADER).withHeaderMoreTextMode(MoreTextMode.NONE).withRowHorizAlignTextMode(HorizAlignTextMode.LEFT).withRowEscapeCode(ANSI_EXCEPTION).withRowSplitTextMode(SplitTextMode.AT_FIRST_END_OF_LINE).withName("Exception")};
    private static final ColumnSetupMetrics[] ANALYST_COLUMN_METRICS = new ColumnSetupMetrics[]{new ColumnSetupMetricsImpl(10, ColumnWidthType.ABSOLUTE).withHeaderTextFormatMode(TextFormatMode.CELL).withHeaderHorizAlignTextMode(HorizAlignTextMode.CENTER).withHeaderEscapeCode(ANSI_HEADER).withHeaderMoreTextMode(MoreTextMode.RIGHT).withRowHorizAlignTextMode(HorizAlignTextMode.RIGHT).withRowEscapeCode(ANSI_LINE_NUMBER).withRowMoreTextMode(MoreTextMode.NONE).withName("#"), new ColumnSetupMetricsImpl(19, ColumnWidthType.ABSOLUTE).withHeaderTextFormatMode(TextFormatMode.CELL).withHeaderHorizAlignTextMode(HorizAlignTextMode.CENTER).withHeaderEscapeCode(ANSI_HEADER).withHeaderMoreTextMode(MoreTextMode.RIGHT).withRowHorizAlignTextMode(HorizAlignTextMode.RIGHT).withRowEscapeCode(ANSI_DATE).withRowMoreTextMode(MoreTextMode.NONE).withName("Date"), new ColumnSetupMetricsImpl(7, ColumnWidthType.ABSOLUTE).withTextFormatMode(TextFormatMode.CELL).withHeaderHorizAlignTextMode(HorizAlignTextMode.CENTER).withHeaderEscapeCode(ANSI_HEADER).withHeaderMoreTextMode(MoreTextMode.RIGHT).withRowHorizAlignTextMode(HorizAlignTextMode.CENTER).withRowEscapeCodeFactory(LOG_PRIORITY_ESC_CODE_FACTORY).withRowMoreTextMode(MoreTextMode.NONE).withName("Level"), new ColumnSetupMetricsImpl(10, ColumnWidthType.ABSOLUTE).withHeaderTextFormatMode(TextFormatMode.CELL).withHeaderHorizAlignTextMode(HorizAlignTextMode.CENTER).withHeaderEscapeCode(ANSI_HEADER).withHeaderMoreTextMode(MoreTextMode.RIGHT).withRowHorizAlignTextMode(HorizAlignTextMode.LEFT).withRowEscapeCode(ANSI_THREAD).withRowSplitTextMode(SplitTextMode.AT_FIXED_WIDTH).withName("Thread"), new ColumnSetupMetricsImpl(8, ColumnWidthType.ABSOLUTE).withHeaderTextFormatMode(TextFormatMode.CELL).withHeaderHorizAlignTextMode(HorizAlignTextMode.CENTER).withHeaderEscapeCode(ANSI_HEADER).withHeaderMoreTextMode(MoreTextMode.RIGHT).withRowHorizAlignTextMode(HorizAlignTextMode.CENTER).withRowEscapeCode(ANSI_CORRELATION_ID).withRowSplitTextMode(SplitTextMode.AT_FIXED_WIDTH).withName("Session"), new ColumnSetupMetricsImpl(8, ColumnWidthType.ABSOLUTE).withHeaderTextFormatMode(TextFormatMode.CELL).withHeaderHorizAlignTextMode(HorizAlignTextMode.CENTER).withHeaderEscapeCode(ANSI_HEADER).withHeaderMoreTextMode(MoreTextMode.RIGHT).withRowHorizAlignTextMode(HorizAlignTextMode.CENTER).withRowEscapeCode(ANSI_CORRELATION_ID).withRowSplitTextMode(SplitTextMode.AT_FIXED_WIDTH).withName("Request"), new ColumnSetupMetricsImpl(1, ColumnWidthType.RELATIVE).withHeaderTextFormatMode(TextFormatMode.CELL).withHeaderHorizAlignTextMode(HorizAlignTextMode.CENTER).withHeaderEscapeCode(ANSI_HEADER).withHeaderMoreTextMode(MoreTextMode.RIGHT).withRowHorizAlignTextMode(HorizAlignTextMode.LEFT).withRowEscapeCode(ANSI_CLASS).withRowSplitTextMode(SplitTextMode.AT_FIXED_WIDTH).withName("Class"), new ColumnSetupMetricsImpl(4, ColumnWidthType.ABSOLUTE).withHeaderTextFormatMode(TextFormatMode.CELL).withHeaderHorizAlignTextMode(HorizAlignTextMode.CENTER).withHeaderEscapeCode(ANSI_HEADER).withHeaderMoreTextMode(MoreTextMode.RIGHT).withRowHorizAlignTextMode(HorizAlignTextMode.RIGHT).withRowEscapeCode(ANSI_CLASS).withRowSplitTextMode(SplitTextMode.AT_FIXED_WIDTH).withName("@"), new ColumnSetupMetricsImpl(30, ColumnWidthType.ABSOLUTE).withHeaderTextFormatMode(TextFormatMode.CELL).withHeaderHorizAlignTextMode(HorizAlignTextMode.CENTER).withHeaderEscapeCode(ANSI_HEADER).withHeaderMoreTextMode(MoreTextMode.RIGHT).withRowHorizAlignTextMode(HorizAlignTextMode.LEFT).withRowEscapeCode(ANSI_METHOD).withRowSplitTextMode(SplitTextMode.AT_FIXED_WIDTH).withName("Method"), new ColumnSetupMetricsImpl(2, ColumnWidthType.RELATIVE).withHeaderTextFormatMode(TextFormatMode.CELL).withHeaderHorizAlignTextMode(HorizAlignTextMode.CENTER).withHeaderEscapeCode(ANSI_HEADER).withHeaderMoreTextMode(MoreTextMode.RIGHT).withRowHorizAlignTextMode(HorizAlignTextMode.LEFT).withRowEscapeCode(ANSI_MESSAGE).withRowSplitTextMode(SplitTextMode.AT_FIRST_END_OF_LINE).withName("Message"), new ColumnSetupMetricsImpl(1, ColumnWidthType.RELATIVE).withHeaderTextFormatMode(TextFormatMode.CELL).withHeaderHorizAlignTextMode(HorizAlignTextMode.CENTER).withHeaderEscapeCode(ANSI_HEADER).withHeaderMoreTextMode(MoreTextMode.NONE).withRowHorizAlignTextMode(HorizAlignTextMode.LEFT).withRowEscapeCode(ANSI_EXCEPTION).withRowSplitTextMode(SplitTextMode.AT_FIRST_END_OF_LINE).withName("Exception")};

    public ConsoleLoggerHeaderImpl() {
        this(PrintStackTrace.EXPLODED, DEVELOPER_COLUMN_METRICS);
    }

    public ConsoleLoggerHeaderImpl(ColumnLayout aLayout) {
        this(PrintStackTrace.EXPLODED, ConsoleLoggerHeaderImpl.toColumnSetupMetrics(aLayout));
    }

    private static ColumnSetupMetrics[] toColumnSetupMetrics(ColumnLayout aLayout) {
        switch (aLayout) {
            case SUPERUSER: {
                return SUPERUSER_COLUMN_METRICS;
            }
            case ANALYST: {
                return ANALYST_COLUMN_METRICS;
            }
            case GRANDPA: {
                return GRANDPA_COLUMN_METRICS;
            }
            case DEVOPS: {
                return DEVOPS_COLUMN_METRICS;
            }
            case END_USER: {
                return ENDUSER_COLUMN_METRICS;
            }
        }
        return DEVELOPER_COLUMN_METRICS;
    }

    public ConsoleLoggerHeaderImpl(PrintStackTrace aPrintStackTrace, ColumnSetupMetrics[] aColumnSetupMetrics) {
        super(new FormattedColumn[]{new FormattedColumnDecorator(LoggerField.LOG_LINE_NUMBER.getColumn(), aColumnSetupMetrics[0]), new FormattedColumnDecorator(LoggerField.LOG_DATE.getColumn(), aColumnSetupMetrics[1]), new FormattedColumnDecorator(LoggerField.LOG_PRIORITY.getColumn(), aColumnSetupMetrics[2]), new FormattedColumnDecorator(LoggerField.LOG_THREAD_NAME.getColumn(), aColumnSetupMetrics[3]), new FormattedColumnDecorator(LoggerField.LOG_SESSION_ID.getColumn(), aColumnSetupMetrics[4]), new FormattedColumnDecorator(LoggerField.LOG_REQUEST_ID.getColumn(), aColumnSetupMetrics[5]), new FormattedColumnDecorator(LoggerField.LOG_FULLY_QUALIFIED_CLASS_NAME.getColumn(), aColumnSetupMetrics[6]), new FormattedColumnDecorator(LoggerField.LOG_CLASS_LINE_NUMBER.getColumn(), aColumnSetupMetrics[7]), new FormattedColumnDecorator(LoggerField.LOG_METHODE_NAME.getColumn(), aColumnSetupMetrics[8]), new FormattedColumnDecorator(LoggerField.LOG_MESSAGE.getColumn(), aColumnSetupMetrics[9]), new FormattedColumnDecorator(LoggerField.toExceptionLoggerField((PrintStackTrace)aPrintStackTrace).getColumn(), aColumnSetupMetrics[10])});
        this.setResetEscapeCode(ANSI_RESET);
    }
}

