/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.logger.alt.console;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.fusesource.jansi.AnsiConsole;
import org.refcodes.component.Destroyable;
import org.refcodes.data.Text;
import org.refcodes.logger.IllegalRecordRuntimeException;
import org.refcodes.logger.UnexpectedLogRuntimeException;
import org.refcodes.logger.alt.console.FormattedLogger;
import org.refcodes.runtime.OperatingSystem;
import org.refcodes.runtime.Shell;
import org.refcodes.runtime.SystemUtility;
import org.refcodes.tabular.ColumnMismatchException;
import org.refcodes.tabular.FormattedColumn;
import org.refcodes.tabular.FormattedHeader;
import org.refcodes.tabular.HeaderMismatchException;
import org.refcodes.tabular.Record;
import org.refcodes.tabular.Row;
import org.refcodes.textual.ColumnFormatMetrics;
import org.refcodes.textual.ColumnSetupMetrics;
import org.refcodes.textual.TableBuilder;
import org.refcodes.textual.TableBuilderImpl;
import org.refcodes.textual.TableStyle;

public class FormattedLoggerImpl<T>
implements Destroyable,
FormattedLogger<T> {
    protected FormattedHeader<T> _header;
    protected TableBuilder _tableBuilder;
    protected PrintStream _stdStream = Shell.toShell() == Shell.WIN_CMD ? AnsiConsole.out : System.out;
    protected PrintStream _errStream = Shell.toShell() == Shell.WIN_CMD ? AnsiConsole.err : System.err;
    protected int _rowWidth = SystemUtility.toConsoleWidth();
    protected TableStyle _tableStyle;
    protected boolean _hasLeftBorder = false;
    protected boolean _hasRightBorder = false;
    private List<String> _columnNames;
    private boolean _isEscCodesEnabled = SystemUtility.toAnsiConsole();

    public FormattedLoggerImpl(FormattedHeader<T> aHeader) {
        this._header = aHeader;
        this._tableStyle = OperatingSystem.toOperatingSystem() == OperatingSystem.WINDOWS ? TableStyle.ASCII : TableStyle.SINGLE;
        this.init();
    }

    public synchronized void log(Record<? extends T> aRecord) throws IllegalRecordRuntimeException, UnexpectedLogRuntimeException {
        this.log(aRecord, this._header, this._tableBuilder);
    }

    public PrintStream getStandardPrintStream() {
        return this._stdStream;
    }

    public void setStandardPrintStream(PrintStream aOutStream) {
        this._stdStream = aOutStream;
    }

    public PrintStream getErrorPrintStream() {
        return this._errStream;
    }

    public void setErrorPrintStream(PrintStream aErrStream) {
        this._errStream = aErrStream;
    }

    public TableStyle getTableStyle() {
        return this._tableStyle;
    }

    public void setTableStyle(TableStyle aTableStyle) {
        this._tableStyle = aTableStyle;
        this.init();
    }

    @Override
    public void setLoggerStyle(String aTableStyleName) {
        this.setTableStyle(TableStyle.valueOf((String)aTableStyleName));
    }

    @Override
    public void setEscapeCodes(boolean isEscCodesEnabled) {
        this._isEscCodesEnabled = isEscCodesEnabled;
        TableBuilder theTableBuilder = this._tableBuilder;
        if (theTableBuilder != null) {
            theTableBuilder.withEscapeCodes(isEscCodesEnabled);
        }
    }

    @Override
    public boolean hasLeftBorder() {
        return this._hasLeftBorder;
    }

    @Override
    public void setLeftBorder(boolean hasLeftBorder) {
        this._hasLeftBorder = hasLeftBorder;
        this.init();
    }

    @Override
    public boolean hasRightBorder() {
        return this._hasRightBorder;
    }

    @Override
    public void setRightBorder(boolean hasRightBorder) {
        this._hasRightBorder = hasRightBorder;
        this.init();
    }

    public int getRowWidth() {
        return this._rowWidth;
    }

    public void setRowWidth(int aRowWidth) {
        this._rowWidth = aRowWidth;
        this.init();
    }

    @Override
    public boolean hasEscapeCodes() {
        return this._isEscCodesEnabled;
    }

    public void destroy() {
        if (Shell.toShell() == Shell.WIN_CMD) {
            AnsiConsole.systemUninstall();
        }
        this._tableBuilder.printTail();
    }

    protected void init() {
        TableBuilder theTableBuilder;
        block3: {
            if (Shell.toShell() == Shell.WIN_CMD) {
                AnsiConsole.systemInstall();
            }
            theTableBuilder = this.toPreConfiguredTableBuilder(this._header, OutputPrintStream.STANDARD);
            this._columnNames = new ArrayList<String>();
            for (ColumnSetupMetrics eMetrics : this._header) {
                if (!eMetrics.isVisible()) continue;
                this._columnNames.add(eMetrics.getName());
            }
            for (String eName : this._columnNames) {
                if (eName == null || eName.length() == 0) continue;
                break block3;
            }
            this._columnNames.clear();
            this._columnNames = null;
        }
        this._tableBuilder = theTableBuilder;
    }

    protected TableBuilder toPreConfiguredTableBuilder(FormattedHeader<?> aHeader, OutputPrintStream aOutputPrintStream) {
        TableBuilder theTableBuilder = new TableBuilderImpl(this._rowWidth).withTableStyle(this._tableStyle).withPrintStream(aOutputPrintStream == OutputPrintStream.STANDARD ? this._stdStream : this._errStream).withResetEscapeCode(this._header.getResetEscapeCode()).withLeftBorder(this._hasLeftBorder).withRightBorder(this._hasRightBorder).withEscapeCodes(this._isEscCodesEnabled).withLineBreak(SystemUtility.toLineBreak((int)this._rowWidth));
        for (ColumnSetupMetrics eMetrics : aHeader) {
            if (!eMetrics.isVisible()) continue;
            theTableBuilder.addColumn().withColumnFormatMetrics((ColumnFormatMetrics)eMetrics);
        }
        return theTableBuilder;
    }

    protected void log(Record<? extends T> aRecord, FormattedHeader<T> aHeader, TableBuilder aTableBuilder) {
        if (this._columnNames != null) {
            this._tableBuilder.printHeaderBegin();
            this._tableBuilder.printHeaderContinue(this._columnNames);
            this._tableBuilder.printHeaderComplete();
            this._columnNames.clear();
            this._columnNames = null;
        }
        try {
            int i;
            Row theRow = aHeader.toPrintableRow(aRecord);
            for (i = aHeader.size() - 1; i >= 0; --i) {
                if (((FormattedColumn)aHeader.get(i)).isVisible() || theRow.size() <= i) continue;
                theRow.remove(i);
            }
            for (i = 0; i < theRow.size(); ++i) {
                if (theRow.get(i) != null) continue;
                theRow.remove(i);
                theRow.add(i, (Object)Text.NULL_VALUE.getText());
            }
            aTableBuilder.printRowContinue((List)theRow);
        }
        catch (ClassCastException | ColumnMismatchException | HeaderMismatchException e) {
            throw new IllegalRecordRuntimeException(aRecord, e);
        }
    }

    public static enum OutputPrintStream {
        STANDARD,
        ERROR;

    }
}

