// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// /////////////////////////////////////////////////////////////////////////////
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// -----------------------------------------------------------------------------
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// -----------------------------------------------------------------------------
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// -----------------------------------------------------------------------------
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

/**
 * The {@link org.refcodes.logger.alt.console.ConsoleLoggerImpl}
 * implements the {@link java.util.logging.Logger} interface for providing
 * logging functionality for extended pimped console output (via
 * {@link System#out} and {@link System#err} to be used by
 * {@link org.refcodes.logger.RuntimeLogger} implementations.
 * <p>
 * The {@link org.refcodes.logger.alt.console.ConsoleLoggerImpl} by
 * default uses the
 * {@link org.refcodes.runtime.SystemUtility#getTerminalWidth()} method, which
 * determines the width in characters of the system's console in use. In case
 * you pass a "<code>-Dconsole.width=n</code>" JVM argument, then your width is
 * taken, else the actual console's width is being tried to be determined. See
 * also {@link org.refcodes.data.SystemProperty#CONSOLE_WIDTH}.
 * <p>
 * You can also use the {@link ConsoleLogger#setRowWidth(int)} or
 * {@link ConsoleLogger#withRowWidth(int)} method in order to programmatically
 * set the console's row width.
 */
package org.refcodes.logger.alt.console;
