/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.logger.alt.simpledb;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.PropertiesCredentials;
import com.amazonaws.services.simpledb.AmazonSimpleDB;
import com.amazonaws.services.simpledb.AmazonSimpleDBClient;
import com.amazonaws.services.simpledb.AmazonSimpleDBClientBuilder;
import com.amazonaws.services.simpledb.model.CreateDomainRequest;
import com.amazonaws.services.simpledb.model.DeleteDomainRequest;
import com.amazonaws.services.simpledb.model.DomainMetadataRequest;
import com.amazonaws.services.simpledb.model.ListDomainsResult;
import com.amazonaws.services.simpledb.model.NoSuchDomainException;
import com.amazonaws.services.simpledb.model.RequestTimeoutException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.refcodes.exception.ExceptionUtility;

abstract class AbstractSimpleDbClient {
    private static final String DEFAULT_REGION = "sdb.eu-west-1.amazonaws.com";
    private AmazonSimpleDB _amazonSimpleDb = null;
    private String _amazonSimpleDbDomainName = null;
    private static final String ERROR_CODE_SERVICE_UNAVAILABLE = "ServiceUnavailable";

    public AbstractSimpleDbClient(String string, String string2, String string3) {
        this(string, string2, string3, DEFAULT_REGION);
    }

    public AbstractSimpleDbClient(String string, String string2, String string3, String string4) {
        if (string4 == null) {
            string4 = DEFAULT_REGION;
        }
        this._amazonSimpleDb = (AmazonSimpleDB)((AmazonSimpleDBClientBuilder)((AmazonSimpleDBClientBuilder)AmazonSimpleDBClientBuilder.standard().withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)new BasicAWSCredentials(string2, string3)))).withRegion(string4)).build();
        this._amazonSimpleDbDomainName = string;
    }

    protected String getAmazonSimpleDbDomainName() {
        return this._amazonSimpleDbDomainName;
    }

    protected void setAmazonSimpleDbDomainName(String string) {
        this._amazonSimpleDbDomainName = string;
    }

    protected AmazonSimpleDB getAmazonSimpleDbClient() {
        return this._amazonSimpleDb;
    }

    protected static boolean isRequestTimeoutException(Exception exception) {
        return exception instanceof RequestTimeoutException;
    }

    protected static boolean isServiceUnavailableException(Exception exception) {
        if (!(exception instanceof AmazonServiceException)) {
            return false;
        }
        AmazonServiceException amazonServiceException = (AmazonServiceException)exception;
        return ERROR_CODE_SERVICE_UNAVAILABLE.equalsIgnoreCase(amazonServiceException.getErrorCode());
    }

    protected static String toMessage(Throwable throwable) {
        Object object = ExceptionUtility.toMessage((Throwable)throwable);
        if (throwable instanceof AmazonServiceException) {
            if (!(object == null || ((String)object).length() <= 0 || ((String)object).endsWith(".") || ((String)object).endsWith("!") || ((String)object).endsWith("?") || ((String)object).endsWith(":"))) {
                object = (String)object + ".";
            }
            AmazonServiceException amazonServiceException = (AmazonServiceException)throwable;
            object = (String)object + " AWS error code = \"" + amazonServiceException.getErrorCode() + "\" , AWS error type = <" + amazonServiceException.getErrorType() + ">, request ID = \"" + amazonServiceException.getRequestId() + "\", service name = \"" + amazonServiceException.getServiceName() + "\", status code = <" + amazonServiceException.getStatusCode() + ">.";
        }
        return object;
    }

    protected static void clearDomain(AmazonSimpleDB amazonSimpleDB, String string) {
        amazonSimpleDB.deleteDomain(new DeleteDomainRequest(string));
        amazonSimpleDB.createDomain(new CreateDomainRequest(string));
    }

    protected static AmazonSimpleDB getAmazonSimpleDbClient(File file) throws IOException {
        Properties properties = new Properties();
        properties.load(new FileInputStream(file));
        return (AmazonSimpleDB)((AmazonSimpleDBClientBuilder)AmazonSimpleDBClientBuilder.standard().withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)new PropertiesCredentials(file)))).build();
    }

    protected static List<String> getDomainNames(AmazonSimpleDBClient amazonSimpleDBClient) {
        ArrayList<String> arrayList = new ArrayList<String>();
        ListDomainsResult listDomainsResult = amazonSimpleDBClient.listDomains();
        for (String string : listDomainsResult.getDomainNames()) {
            arrayList.add(string);
        }
        return arrayList;
    }

    protected static boolean hasDomain(AmazonSimpleDBClient amazonSimpleDBClient, String string) {
        DomainMetadataRequest domainMetadataRequest = new DomainMetadataRequest();
        domainMetadataRequest.setDomainName(string);
        try {
            amazonSimpleDBClient.domainMetadata(domainMetadataRequest);
        }
        catch (NoSuchDomainException noSuchDomainException) {
            return false;
        }
        return true;
    }
}

